/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.standard.domobj;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.commons.ItemMap;
import org.uitnet.testing.smartfwk.ui.core.config.webbrowser.WebBrowser;
import org.uitnet.testing.smartfwk.ui.core.objects.DOMObject;
import org.uitnet.testing.smartfwk.ui.core.objects.DOMObjectValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.NewTextLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.radio.RadioButtonGroupValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.scrollbar.Scrollbar;
import org.uitnet.testing.smartfwk.ui.standard.domobj.RadioButtonGroupSD;

public class RadioButtonGroupValidatorSD
extends RadioButtonGroupValidator {
    protected DOMObjectValidator domObjValidator;

    public RadioButtonGroupValidatorSD(WebBrowser browser, RadioButtonGroupSD uiObject, Region region) {
        super(browser, uiObject, region);
        this.domObjValidator = new DOMObjectValidator(browser, new DOMObject(uiObject.getDisplayName(), uiObject.getLocatorXPath()), region);
    }

    public DOMObjectValidator getDOMObjectValidator() {
        return this.domObjValidator;
    }

    @Override
    public void typeText(String textToType, NewTextLocation location, int numRetries) {
        this.domObjValidator.typeText(textToType, location, numRetries);
    }

    @Override
    public boolean isPresent(int numRetries) {
        return this.domObjValidator.isPresent(numRetries);
    }

    @Override
    public boolean isVisible(int numRetries) {
        return this.domObjValidator.isVisible(numRetries);
    }

    @Override
    public void click(int numRetries) {
        this.domObjValidator.click(numRetries);
    }

    @Override
    public void doubleClick(int numRetries) {
        this.domObjValidator.doubleClick(numRetries);
    }

    @Override
    public void rightClick(int numRetries) {
        this.domObjValidator.rightClick(numRetries);
    }

    @Override
    public void clickAndHold(int numRetries) {
        this.domObjValidator.clickAndHold(numRetries);
    }

    @Override
    public void release(int numRetries) {
        this.domObjValidator.release(numRetries);
    }

    @Override
    public void performKeyDown(Keys keys, int numRetries) {
        this.domObjValidator.performKeyDown(keys, numRetries);
    }

    @Override
    public void performKeyUp(Keys keys, int numRetries) {
        this.domObjValidator.performKeyUp(keys, numRetries);
    }

    @Override
    public void performKeyPressed(Keys keys, int numRetries) {
        this.domObjValidator.performKeyPressed(keys, numRetries);
    }

    @Override
    public RadioButtonGroupValidatorSD scrollElementOnViewport(Scrollbar scrollbar) {
        this.domObjValidator.scrollElementOnViewport(scrollbar);
        return this;
    }

    public WebElement findElement(int numRetries) {
        return this.domObjValidator.findElement(numRetries);
    }

    public WebElement findElementNoException(int numRetries) {
        return this.domObjValidator.findElementNoException(numRetries);
    }

    @Override
    public List<WebElement> findElements(int numRetries) {
        return this.domObjValidator.findElements(numRetries);
    }

    @Override
    public void validateDisabled(int numRetries) {
        Object webElems = this.findElements(numRetries);
        LinkedList<String> enabledItems = new LinkedList<String>();
        Iterator iterator = webElems.iterator();
        while (iterator.hasNext()) {
            WebElement elem = (WebElement)iterator.next();
            if (!elem.isEnabled()) continue;
            enabledItems.add(elem.getAttribute("value"));
        }
        if (enabledItems.size() > 0) {
            Assert.fail((String)("Radio button group '" + this.uiObject.getDisplayName() + "' is not disabled. It has the following enabled items: " + enabledItems));
        }
    }

    @Override
    public void validateEnabled(int numRetries) {
        Object webElems = this.findElements(numRetries);
        LinkedList<String> disabledItems = new LinkedList<String>();
        Iterator iterator = webElems.iterator();
        while (iterator.hasNext()) {
            WebElement elem = (WebElement)iterator.next();
            if (elem.isEnabled()) continue;
            disabledItems.add(elem.getAttribute("value"));
        }
        if (disabledItems.size() > 0) {
            Assert.fail((String)("Radio button group '" + this.uiObject.getDisplayName() + "' is not enabled. It has the following disabled items: " + disabledItems));
        }
    }

    @Override
    public void selectOption(String value, String displayValue, int numRetries) {
        Object webElems = this.findElements(numRetries);
        Iterator iterator = webElems.iterator();
        while (iterator.hasNext()) {
            WebElement elem = (WebElement)iterator.next();
            String elemVal = elem.getAttribute("value");
            if (elemVal == null || !elemVal.equals(value)) continue;
            elem.click();
            break;
        }
        try {
            this.validateSelectedOption(value, displayValue, numRetries);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to select option with value '" + displayValue + "' in radio button group '" + this.uiObject.getDisplayName() + "'."));
        }
    }

    @Override
    public void validateSelectedOption(String value, String displayValue, int numRetries) {
        Object webElems = this.findElements(numRetries);
        boolean optionFound = false;
        Iterator iterator = webElems.iterator();
        while (iterator.hasNext()) {
            WebElement elem = (WebElement)iterator.next();
            String elemVal = elem.getAttribute("value");
            if (elemVal == null || !elemVal.equals(value) || !elem.isSelected()) continue;
            optionFound = true;
            break;
        }
        Assert.assertTrue((boolean)optionFound, (String)("Radio button with value '" + displayValue + "' is not selected."));
    }

    @Override
    public void validateNotSelectedOptions(ItemMap<String, String> options, int numRetries) {
        Object webElems = this.findElements(numRetries);
        LinkedHashMap<String, String> selectedOptions = new LinkedHashMap<String, String>();
        for (String optionValue : options.getItems().keySet()) {
            Iterator iterator = webElems.iterator();
            while (iterator.hasNext()) {
                WebElement elem = (WebElement)iterator.next();
                String elemVal = elem.getAttribute("value");
                if (elemVal == null || !elemVal.equals(optionValue) || !elem.isSelected()) continue;
                selectedOptions.put(optionValue, options.getItems().get(optionValue));
            }
        }
        if (selectedOptions.size() > 0) {
            Assert.fail((String)("Radio button group '" + this.uiObject.getDisplayName() + "' has some of the options selected. Selected options: " + selectedOptions));
        }
    }
}

