/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.actions;

import org.sikuli.script.Region;
import org.testng.Assert;
import org.testng.Reporter;
import org.uitnet.testing.smartfwk.ui.core.actions.InputAction;
import org.uitnet.testing.smartfwk.ui.core.actions.InputActions;
import org.uitnet.testing.smartfwk.ui.core.config.webbrowser.WebBrowser;
import org.uitnet.testing.smartfwk.ui.core.events.InputEvent;
import org.uitnet.testing.smartfwk.ui.core.objects.UIObject;
import org.uitnet.testing.smartfwk.ui.core.objects.tab.Tab;
import org.uitnet.testing.smartfwk.ui.core.objects.webpage.WebPage;
import org.uitnet.testing.smartfwk.ui.standard.imgobj.WebPageTitleSI;

public class InputActionHandler {
    private InputActions inputActions;
    private WebBrowser browser;

    public InputActionHandler(WebBrowser browser, InputActions inputActions) {
        this.browser = browser;
        this.inputActions = inputActions;
    }

    public InputActions getInputActions() {
        return this.inputActions;
    }

    public void setInputActions(InputActions inputActions) {
        this.inputActions = inputActions;
    }

    private boolean checkWebPagePresence(WebPage expectedWebPage, Region region, int numRetries) {
        boolean webPagePresent = true;
        try {
            for (UIObject item : this.inputActions.getPageRecognitionItems()) {
                if (item instanceof Tab) {
                    ((Tab)item).getValidator(this.browser, region).validateSelected(numRetries);
                    continue;
                }
                item.getValidator(this.browser, region).validatePresent(numRetries);
            }
        }
        catch (Throwable ex) {
            webPagePresent = false;
            Reporter.log((String)("Error during checking of web page presence. Message: " + ex.getMessage()));
        }
        return webPagePresent;
    }

    public void performActions(Region region, int numRetries) {
        Reporter.log((String)("Going to perform input action '" + this.inputActions.getName() + "' on web page - " + this.inputActions.getWebPage().getTitle().getDisplayName()));
        WebPage expectedWebPage = new WebPage(new WebPageTitleSI(this.inputActions.getWebPage().getTitle() + ":> " + this.inputActions.getReadablePath(), null), null, null);
        for (InputAction inputAction : this.inputActions.getActions()) {
            UIObject item = inputAction.getItem();
            InputEvent itemEvent = inputAction.getEvent();
            Assert.assertNotNull((Object)item, (String)("Found null item in InputActions - " + this.inputActions.getName()));
            Assert.assertNotNull((Object)itemEvent, (String)("Found null input event in InputActions - " + this.inputActions.getName()));
            item.getValidator(this.browser, region).performAction(itemEvent, numRetries);
        }
        if (this.checkWebPagePresence(expectedWebPage, region, numRetries)) {
            Reporter.log((String)("Input action '" + this.inputActions.getName() + "' performed successfully on web page - " + this.inputActions.getWebPage().getTitle().getDisplayName()));
        } else {
            Assert.fail((String)("Failed to perform input action '" + this.inputActions.getName() + "' on web page - " + this.inputActions.getWebPage().getTitle().getDisplayName() + ". Expected web page: " + expectedWebPage.getTitle().getDisplayName()));
        }
    }
}

