/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.api.core;

import java.io.File;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.api.core.support.HttpMultipartRequest;
import org.uitnet.testing.smartfwk.api.core.support.HttpRequest;
import org.uitnet.testing.smartfwk.api.core.support.HttpResponse;
import org.uitnet.testing.smartfwk.api.core.support.HttpSession;
import org.uitnet.testing.smartfwk.api.core.support.MultipartData;
import org.uitnet.testing.smartfwk.ui.core.config.ApiConfig;
import org.uitnet.testing.smartfwk.ui.core.config.TestConfigManager;
import org.uitnet.testing.smartfwk.ui.core.config.UserProfile;

public abstract class AbstractApiTestHelper {
    protected String appName;
    protected String baseURL;
    protected HttpSession session;
    protected TestConfigManager testConfigManager;
    protected String activeProfileName;

    public AbstractApiTestHelper(String appName) {
        this.appName = appName;
        this.testConfigManager = TestConfigManager.getInstance();
    }

    protected void setBaseURL(String baseUrlKey) {
        this.baseURL = this.testConfigManager.getAppConfig(this.appName).getApiConfig().getPropertyValue(baseUrlKey);
    }

    public void setActiveProfileName(String profileName) {
        if (this.activeProfileName == null || "".equals(this.activeProfileName)) {
            this.session = this.login(this.testConfigManager.getAppConfig(this.appName).getApiConfig(), this.testConfigManager.getUserProfile(this.appName, profileName));
            this.activeProfileName = profileName;
        } else if (!this.activeProfileName.equals(profileName)) {
            this.logout();
            this.session = this.login(this.testConfigManager.getAppConfig(this.appName).getApiConfig(), this.testConfigManager.getUserProfile(this.appName, profileName));
            this.activeProfileName = profileName;
        }
    }

    public HttpResponse httpGet(String relativeUrl, String responseContentType, Integer connectTimeoutInSeconds, Integer readTimeoutInSeconds) {
        OkHttpClient client = new OkHttpClient.Builder().readTimeout(readTimeoutInSeconds == null ? 60L : (long)readTimeoutInSeconds.intValue(), TimeUnit.SECONDS).connectTimeout(connectTimeoutInSeconds == null ? 30L : (long)connectTimeoutInSeconds.intValue(), TimeUnit.SECONDS).build();
        String targetURL = this.baseURL + "/" + relativeUrl;
        Request.Builder requestBuilder = new Request.Builder().get().url(targetURL);
        if (this.session != null && this.session.getParams() != null && this.session.getParams().size() > 0) {
            for (Map.Entry<String, String> kv : this.session.getParams().entrySet()) {
                requestBuilder.addHeader(kv.getKey(), kv.getValue());
            }
        }
        if (this.session != null && this.session.getCookies() != null && this.session.getCookies().size() > 0) {
            String cookie = null;
            for (Map.Entry<String, String> kv : this.session.getCookies().entrySet()) {
                if (cookie == null) {
                    cookie = kv.getKey() + "=" + kv.getValue();
                    continue;
                }
                cookie = kv + ";" + kv.getKey() + "=" + kv.getValue();
            }
            if (cookie != null) {
                requestBuilder.addHeader("Cookie", cookie);
            }
        }
        requestBuilder.removeHeader("Content-Type");
        if (responseContentType == null || "".equals(responseContentType.trim())) {
            requestBuilder.removeHeader("Accept");
        } else {
            requestBuilder.addHeader("Accept", responseContentType);
        }
        return this.prepareResponse(client, requestBuilder, responseContentType != null, targetURL);
    }

    public HttpResponse httpDelete(String relativeUrl, String responseContentType, Integer connectTimeoutInSeconds, Integer readTimeoutInSeconds) {
        OkHttpClient client = new OkHttpClient.Builder().readTimeout(readTimeoutInSeconds == null ? 60L : (long)readTimeoutInSeconds.intValue(), TimeUnit.SECONDS).connectTimeout(connectTimeoutInSeconds == null ? 30L : (long)connectTimeoutInSeconds.intValue(), TimeUnit.SECONDS).build();
        String targetURL = this.baseURL + "/" + relativeUrl;
        Request.Builder requestBuilder = new Request.Builder().delete().url(targetURL);
        if (this.session != null && this.session.getParams() != null && this.session.getParams().size() > 0) {
            for (Map.Entry<String, String> kv : this.session.getParams().entrySet()) {
                requestBuilder.addHeader(kv.getKey(), kv.getValue());
            }
        }
        if (this.session != null && this.session.getCookies() != null && this.session.getCookies().size() > 0) {
            String cookie = null;
            for (Map.Entry<String, String> kv : this.session.getCookies().entrySet()) {
                if (cookie == null) {
                    cookie = kv.getKey() + "=" + kv.getValue();
                    continue;
                }
                cookie = kv + ";" + kv.getKey() + "=" + kv.getValue();
            }
            if (cookie != null) {
                requestBuilder.addHeader("Cookie", cookie);
            }
        }
        requestBuilder.removeHeader("Content-Type");
        if (responseContentType == null || "".equals(responseContentType.trim())) {
            requestBuilder.removeHeader("Accept");
        } else {
            requestBuilder.addHeader("Accept", responseContentType);
        }
        return this.prepareResponse(client, requestBuilder, responseContentType != null, targetURL);
    }

    public HttpResponse httpPost(String relativeUrl, HttpRequest request, Integer connectTimeoutInSeconds, Integer readTimeoutInSeconds) {
        OkHttpClient client = new OkHttpClient.Builder().readTimeout(readTimeoutInSeconds == null ? 60L : (long)readTimeoutInSeconds.intValue(), TimeUnit.SECONDS).connectTimeout(connectTimeoutInSeconds == null ? 30L : (long)connectTimeoutInSeconds.intValue(), TimeUnit.SECONDS).build();
        String targetURL = this.baseURL + "/" + relativeUrl;
        Request.Builder requestBuilder = new Request.Builder().post(RequestBody.create((String)request.getPayload(), (MediaType)MediaType.parse((String)request.getPayloadType()))).url(targetURL);
        if (this.session != null && this.session.getParams() != null && this.session.getParams().size() > 0) {
            for (Map.Entry<String, String> kv : this.session.getParams().entrySet()) {
                requestBuilder.addHeader(kv.getKey(), kv.getValue());
            }
        }
        if (this.session != null && this.session.getCookies() != null && this.session.getCookies().size() > 0) {
            String cookie = null;
            for (Map.Entry<String, String> kv : this.session.getCookies().entrySet()) {
                if (cookie == null) {
                    cookie = kv.getKey() + "=" + kv.getValue();
                    continue;
                }
                cookie = kv + ";" + kv.getKey() + "=" + kv.getValue();
            }
            if (cookie != null) {
                requestBuilder.addHeader("Cookie", cookie);
            }
        }
        if (request.getResponseContentType() == null || "".equals(request.getResponseContentType().trim())) {
            requestBuilder.removeHeader("Accept");
        } else {
            requestBuilder.addHeader("Accept", request.getResponseContentType());
        }
        return this.prepareResponse(client, requestBuilder, request.getResponseContentType() != null, targetURL);
    }

    public HttpResponse httpPut(String relativeUrl, HttpRequest request, Integer connectTimeoutInSeconds, Integer readTimeoutInSeconds) {
        OkHttpClient client = new OkHttpClient.Builder().readTimeout(readTimeoutInSeconds == null ? 60L : (long)readTimeoutInSeconds.intValue(), TimeUnit.SECONDS).connectTimeout(connectTimeoutInSeconds == null ? 30L : (long)connectTimeoutInSeconds.intValue(), TimeUnit.SECONDS).build();
        String targetURL = this.baseURL + "/" + relativeUrl;
        Request.Builder requestBuilder = new Request.Builder().put(RequestBody.create((String)request.getPayload(), (MediaType)MediaType.parse((String)request.getPayloadType()))).url(targetURL);
        if (this.session != null && this.session.getParams() != null && this.session.getParams().size() > 0) {
            for (Map.Entry<String, String> kv : this.session.getParams().entrySet()) {
                requestBuilder.addHeader(kv.getKey(), kv.getValue());
            }
        }
        if (this.session != null && this.session.getCookies() != null && this.session.getCookies().size() > 0) {
            String cookie = null;
            for (Map.Entry<String, String> kv : this.session.getCookies().entrySet()) {
                if (cookie == null) {
                    cookie = kv.getKey() + "=" + kv.getValue();
                    continue;
                }
                cookie = kv + ";" + kv.getKey() + "=" + kv.getValue();
            }
            if (cookie != null) {
                requestBuilder.addHeader("Cookie", cookie);
            }
        }
        if (request.getResponseContentType() == null || "".equals(request.getResponseContentType().trim())) {
            requestBuilder.removeHeader("Accept");
        } else {
            requestBuilder.addHeader("Accept", request.getResponseContentType());
        }
        return this.prepareResponse(client, requestBuilder, request.getResponseContentType() != null, targetURL);
    }

    public HttpResponse httpUploadFormFiles(String relativeUrl, HttpMultipartRequest request, Integer connectTimeoutInSeconds, Integer readTimeoutInSeconds) {
        OkHttpClient client = new OkHttpClient.Builder().readTimeout(readTimeoutInSeconds == null ? 60L : (long)readTimeoutInSeconds.intValue(), TimeUnit.SECONDS).connectTimeout(connectTimeoutInSeconds == null ? 30L : (long)connectTimeoutInSeconds.intValue(), TimeUnit.SECONDS).build();
        MultipartBody.Builder multipartBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        for (MultipartData part : request.getParts()) {
            if (part.getContentType() == null) {
                multipartBodyBuilder.addFormDataPart(part.getName(), part.getFileName());
                continue;
            }
            multipartBodyBuilder.addFormDataPart(part.getName(), part.getFileName(), RequestBody.create((File)new File(part.getFilePath()), (MediaType)MediaType.parse((String)part.getContentType())));
        }
        String targetURL = this.baseURL + "/" + relativeUrl;
        Request.Builder requestBuilder = new Request.Builder().post((RequestBody)multipartBodyBuilder.build()).url(targetURL);
        if (this.session != null && this.session.getParams() != null && this.session.getParams().size() > 0) {
            for (Map.Entry<String, String> kv : this.session.getParams().entrySet()) {
                requestBuilder.addHeader(kv.getKey(), kv.getValue());
            }
        }
        if (this.session != null && this.session.getCookies() != null && this.session.getCookies().size() > 0) {
            String cookie = null;
            for (Map.Entry<String, String> kv : this.session.getCookies().entrySet()) {
                if (cookie == null) {
                    cookie = kv.getKey() + "=" + kv.getValue();
                    continue;
                }
                cookie = kv + ";" + kv.getKey() + "=" + kv.getValue();
            }
            if (cookie != null) {
                requestBuilder.addHeader("Cookie", cookie);
            }
        }
        if (request.getResponseContentType() == null || "".equals(request.getResponseContentType().trim())) {
            requestBuilder.removeHeader("Accept");
        } else {
            requestBuilder.addHeader("Accept", request.getResponseContentType());
        }
        requestBuilder.addHeader("Content-Type", request.getContentType());
        return this.prepareResponse(client, requestBuilder, request.getResponseContentType() != null, targetURL);
    }

    protected HttpResponse prepareResponse(OkHttpClient client, Request.Builder requestBuilder, boolean expectResponseBody, String targetURL) {
        HttpResponse httpResponse = new HttpResponse();
        try (Response response = client.newCall(requestBuilder.build()).execute();){
            httpResponse.setCode(response.code());
            httpResponse.setMessage(response.message());
            if (expectResponseBody) {
                ResponseBody body = response.body();
                httpResponse.setPayload(body.string());
            }
        }
        catch (Exception ex) {
            httpResponse.setCode(400);
            httpResponse.setMessage("Bad Request");
            Assert.fail((String)("Failed to make API call on target URL: " + targetURL), (Throwable)ex);
        }
        return httpResponse;
    }

    protected abstract HttpSession login(ApiConfig var1, UserProfile var2);

    public abstract void logout();
}

