/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.config;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.testng.Assert;

public class UserProfile {
    private String appName;
    private String name;
    private String appLoginUserId;
    private String appLoginUserPassword;
    private String userAccountType;
    private String userAccountTypeCode;
    private List<String> userRoles;
    private Map<String, String> additionalProps;

    public UserProfile(String appName, String profileName, Properties properties) {
        this.appName = appName;
        this.userRoles = new LinkedList<String>();
        this.additionalProps = new HashMap<String, String>();
        this.initUserProfile(appName, profileName, properties);
    }

    private void initUserProfile(String appName, String profileName, Properties properties) {
        this.name = properties.getProperty("PROFILE_NAME");
        if (this.name == null || !profileName.equals(this.name.trim())) {
            Assert.fail((String)("FATAL: User profile name '" + this.name + "' specified in file is not same as configured in AppConfig.properties file. AppName - '" + appName + "'. Exiting ..."));
            System.exit(1);
        } else {
            this.name = this.name.trim();
        }
        this.appLoginUserId = properties.getProperty("APP_LOGIN_USER_ID");
        if (this.appLoginUserId == null || "".equals(this.appLoginUserId.trim())) {
            Assert.fail((String)("FATAL: Please specify APP_LOGIN_USER_ID in " + profileName + ".properties file. AppName: " + appName + ". Exiting ..."));
            System.exit(1);
        } else {
            this.appLoginUserId = this.appLoginUserId.trim();
        }
        this.appLoginUserPassword = properties.getProperty("APP_LOGIN_USER_PASSWORD");
        if (this.appLoginUserPassword == null || "".equals(this.appLoginUserPassword.trim())) {
            Assert.fail((String)("FATAL: Please specify appLoginUserPassword in " + profileName + ".properties file. AppName: " + appName + ". Exiting ..."));
            System.exit(1);
        } else {
            this.appLoginUserPassword = this.appLoginUserPassword.trim();
        }
        this.userAccountType = properties.getProperty("USER_ACCOUNT_TYPE");
        if (this.userAccountType == null || "".equals(this.userAccountType.trim())) {
            Assert.fail((String)("FATAL: Please specify USER_ACCOUNT_TYPE in " + profileName + ".properties file. AppName: " + appName + ". Exiting ..."));
            System.exit(1);
        } else {
            this.userAccountType = this.userAccountType.trim();
        }
        this.userAccountTypeCode = properties.getProperty("USER_ACCOUNT_TYPE_CODE");
        if (this.userAccountTypeCode == null || "".equals(this.userAccountTypeCode.trim())) {
            Assert.fail((String)("FATAL: Please specify USER_ACCOUNT_TYPE_CODE in " + profileName + ".properties file. AppName: " + appName + ". Exiting ..."));
            System.exit(1);
        } else {
            this.userAccountTypeCode = this.userAccountTypeCode.trim();
        }
        String propValue = properties.getProperty("USER_ROLES");
        if (propValue != null && !"".equals(propValue.trim())) {
            String[] arr;
            for (String item : arr = propValue.split(",")) {
                String keyStr = item.trim();
                if ("".equals(keyStr)) continue;
                this.userRoles.add(keyStr);
            }
        }
        for (Object key : properties.keySet()) {
            String keyStr = String.valueOf(key);
            if (!keyStr.startsWith("_")) continue;
            this.additionalProps.put(keyStr, properties.getProperty(keyStr));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getAppLoginUserId() {
        return this.appLoginUserId;
    }

    public String getAppLoginUserPassword() {
        return this.appLoginUserPassword;
    }

    public String getUserAccountType() {
        return this.userAccountType;
    }

    public String getUserAccountTypeCode() {
        return this.userAccountTypeCode;
    }

    public List<String> getUserRoles() {
        return this.userRoles;
    }

    public String getAdditionalPropertyValue(String propName) {
        Assert.assertTrue((boolean)this.additionalProps.containsKey(propName), (String)("Please specify the additional property '" + propName + "' in application '" + this.appName + "' user profile '" + this.name + ".properties' file."));
        return this.additionalProps.get(propName);
    }
}

