/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.objects.webpage;

import org.sikuli.script.Region;
import org.uitnet.testing.smartfwk.ui.core.commons.LocatorType;
import org.uitnet.testing.smartfwk.ui.core.commons.UIObjectType;
import org.uitnet.testing.smartfwk.ui.core.config.webbrowser.WebBrowser;
import org.uitnet.testing.smartfwk.ui.core.objects.UIObject;
import org.uitnet.testing.smartfwk.ui.core.objects.webpage.PathItem;
import org.uitnet.testing.smartfwk.ui.core.objects.webpage.WebPagePath;
import org.uitnet.testing.smartfwk.ui.core.objects.webpage.WebPageRecognitionItems;
import org.uitnet.testing.smartfwk.ui.core.objects.webpage.WebPageStatus;
import org.uitnet.testing.smartfwk.ui.core.objects.webpage.WebPageValidator;

public class WebPage
extends UIObject {
    private UIObject title;
    private WebPagePath launchPath;
    private WebPageRecognitionItems pageRecognitionItems;
    private WebPageStatus status;

    public WebPage(UIObject webPageTitle, WebPagePath launchPath, WebPageRecognitionItems pageRecognitionItems) {
        super(LocatorType.WEB_PAGE, UIObjectType.webPage, null);
        this.title = webPageTitle;
        this.launchPath = launchPath;
        this.pageRecognitionItems = pageRecognitionItems;
        this.status = WebPageStatus.Closed;
    }

    public UIObject getTitle() {
        return this.title;
    }

    public WebPagePath getLaunchPath() {
        return this.launchPath;
    }

    public WebPageRecognitionItems getPageRecognitionItems() {
        return this.pageRecognitionItems;
    }

    @Override
    public WebPageValidator getValidator(WebBrowser browser, Region region) {
        return new WebPageValidator(browser, this);
    }

    public WebPageStatus getStatus() {
        return this.status;
    }

    public void setStatus(WebPageStatus status) {
        this.status = status;
    }

    public String getReadablePath() {
        String readablePath = "";
        if (this.launchPath == null || this.launchPath.getPath() == null) {
            return readablePath;
        }
        for (PathItem pathItem : this.launchPath.getPath()) {
            if ("".equals(readablePath)) {
                readablePath = pathItem.getItem().getDisplayName() + "(" + pathItem.getEvent().getName() + ")";
                continue;
            }
            readablePath = readablePath + " -> " + pathItem.getItem().getDisplayName() + "(" + pathItem.getEvent().getName() + ")";
        }
        return readablePath;
    }

    @Override
    public WebPage clone() {
        return null;
    }

    @Override
    public UIObject updateLocatorParameterWithValue(String paramName, String value) {
        return this;
    }
}

