/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.standard.domobj;

import java.util.LinkedList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.commons.ItemList;
import org.uitnet.testing.smartfwk.ui.core.config.webbrowser.WebBrowser;
import org.uitnet.testing.smartfwk.ui.core.objects.DOMObject;
import org.uitnet.testing.smartfwk.ui.core.objects.DOMObjectValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.NewTextLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.listbox.ListBoxValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.scrollbar.Scrollbar;
import org.uitnet.testing.smartfwk.ui.core.objects.validator.mechanisms.TextMatchMechanism;
import org.uitnet.testing.smartfwk.ui.core.utils.PageScrollUtil;
import org.uitnet.testing.smartfwk.ui.standard.domobj.ListBoxSD;

public class ListBoxValidatorSD
extends ListBoxValidator {
    protected DOMObjectValidator domObjValidator;

    public ListBoxValidatorSD(WebBrowser browser, ListBoxSD uiObject, Region region) {
        super(browser, uiObject, region);
        this.domObjValidator = new DOMObjectValidator(browser, new DOMObject(uiObject.getDisplayName(), uiObject.getLocatorXPath()), region);
    }

    public DOMObjectValidator getDOMObjectValidator() {
        return this.domObjValidator;
    }

    @Override
    public void validateDisabled(int numRetries) {
        Assert.assertTrue((boolean)this.domObjValidator.isDisabled(numRetries), (String)("'" + this.uiObject.getDisplayName() + "' element is not disabled."));
    }

    @Override
    public void validateEnabled(int numRetries) {
        Assert.assertFalse((boolean)this.domObjValidator.isDisabled(numRetries), (String)("'" + this.uiObject.getDisplayName() + "' element is not enabled."));
    }

    @Override
    public void typeText(String textToType, NewTextLocation location, int numRetries) {
        this.domObjValidator.typeText(textToType, location, numRetries);
    }

    @Override
    public boolean isPresent(int numRetries) {
        return this.domObjValidator.isPresent(numRetries);
    }

    @Override
    public boolean isVisible(int numRetries) {
        return this.domObjValidator.isVisible(numRetries);
    }

    @Override
    public void click(int numRetries) {
        this.domObjValidator.click(numRetries);
    }

    @Override
    public void doubleClick(int numRetries) {
        this.domObjValidator.doubleClick(numRetries);
    }

    @Override
    public void rightClick(int numRetries) {
        this.domObjValidator.rightClick(numRetries);
    }

    @Override
    public void clickAndHold(int numRetries) {
        this.domObjValidator.clickAndHold(numRetries);
    }

    @Override
    public void release(int numRetries) {
        this.domObjValidator.release(numRetries);
    }

    @Override
    public void performKeyDown(Keys keys, int numRetries) {
        this.domObjValidator.performKeyDown(keys, numRetries);
    }

    @Override
    public void performKeyUp(Keys keys, int numRetries) {
        this.domObjValidator.performKeyUp(keys, numRetries);
    }

    @Override
    public void performKeyPressed(Keys keys, int numRetries) {
        this.domObjValidator.performKeyPressed(keys, numRetries);
    }

    @Override
    public ListBoxValidatorSD scrollElementOnViewport(Scrollbar scrollbar) {
        this.domObjValidator.scrollElementOnViewport(scrollbar);
        return this;
    }

    @Override
    public void validateSelectedItem(String expectedSelectedValue, TextMatchMechanism validationMechanism, int numRetries) {
        try {
            for (int i = 0; i <= numRetries; ++i) {
                try {
                    WebElement selectElement = this.domObjValidator.findElement(0);
                    List options = selectElement.findElements(By.xpath((String)"./option"));
                    Assert.assertNotNull((Object)options, (String)("Failed to find items for Choices '" + this.uiObject.getDisplayName() + "'."));
                    Assert.assertTrue((options.size() > 0 ? 1 : 0) != 0, (String)("Failed to find items in Choices '" + this.uiObject.getDisplayName() + "'. Found 0 items."));
                    boolean found = false;
                    for (WebElement option : options) {
                        String optionTextValue = option.getText();
                        if (optionTextValue == null || !option.isSelected() || !this.matchTextValue(optionTextValue.trim(), expectedSelectedValue, validationMechanism)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        Assert.fail((String)("Failed to find selected item '" + expectedSelectedValue + "' in Choices '" + this.uiObject.getDisplayName() + "'."));
                    }
                    return;
                }
                catch (Throwable th) {
                    if (i == numRetries) {
                        throw th;
                    }
                    this.browser.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to validate selected item '" + expectedSelectedValue + "' for element '" + this.uiObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public String getSelectedItem(int numRetries) {
        WebElement selectElement = this.domObjValidator.findElement(numRetries);
        List options = selectElement.findElements(By.xpath((String)"./option"));
        Assert.assertNotNull((Object)options, (String)("Failed to find items for Choices '" + this.uiObject.getDisplayName() + "'."));
        Assert.assertTrue((options.size() > 0 ? 1 : 0) != 0, (String)("Failed to find items in Choices '" + this.uiObject.getDisplayName() + "'. Found 0 items."));
        for (WebElement option : options) {
            String optionTextValue = option.getText();
            if (optionTextValue == null || !option.isSelected()) continue;
            return optionTextValue;
        }
        return null;
    }

    @Override
    public List<String> getSelectedItems(int numRetries) {
        WebElement selectElement = this.domObjValidator.findElement(numRetries);
        List options = selectElement.findElements(By.xpath((String)"./option"));
        Assert.assertNotNull((Object)options, (String)("Failed to find items for Choices '" + this.uiObject.getDisplayName() + "'."));
        Assert.assertTrue((options.size() > 0 ? 1 : 0) != 0, (String)("Failed to find items in Choices '" + this.uiObject.getDisplayName() + "'. Found 0 items."));
        LinkedList<String> selectedItems = new LinkedList<String>();
        for (WebElement option : options) {
            String optionTextValue = option.getText();
            if (optionTextValue == null || !option.isSelected()) continue;
            selectedItems.add(optionTextValue);
        }
        return selectedItems;
    }

    @Override
    public void selectFirstItem(int numRetries) {
        try {
            for (int i = 0; i <= numRetries; ++i) {
                try {
                    WebElement selectElement = this.domObjValidator.findElement(0);
                    List options = selectElement.findElements(By.xpath((String)"./option"));
                    Assert.assertNotNull((Object)options, (String)("Failed to find items for Choices '" + this.uiObject.getDisplayName() + "'."));
                    Assert.assertTrue((options.size() > 0 ? 1 : 0) != 0, (String)("Failed to find items in Choices '" + this.uiObject.getDisplayName() + "'. Found 0 items."));
                    PageScrollUtil.scrollToViewportAndClick(this.browser, (WebElement)options.get(0));
                    return;
                }
                catch (Throwable th) {
                    if (i == numRetries) {
                        throw th;
                    }
                    this.browser.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to select first item for element '" + this.uiObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void selectLastItem(int numRetries) {
        try {
            for (int i = 0; i <= numRetries; ++i) {
                try {
                    WebElement selectElement = this.domObjValidator.findElement(0);
                    List options = selectElement.findElements(By.xpath((String)"./option"));
                    Assert.assertNotNull((Object)options, (String)("Failed to find items for Choices '" + this.uiObject.getDisplayName() + "'."));
                    Assert.assertTrue((options.size() > 0 ? 1 : 0) != 0, (String)("Failed to find items in Choices '" + this.uiObject.getDisplayName() + "'. Found 0 items."));
                    PageScrollUtil.scrollToViewportAndClick(this.browser, (WebElement)options.get(options.size() - 1));
                    return;
                }
                catch (Throwable th) {
                    if (i == numRetries) {
                        throw th;
                    }
                    this.browser.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to select last item for element '" + this.uiObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void selectItem(String itemName, int numRetries) {
        try {
            for (int i = 0; i <= numRetries; ++i) {
                try {
                    WebElement selectElement = this.domObjValidator.findElement(0);
                    List options = selectElement.findElements(By.xpath((String)"./option"));
                    Assert.assertNotNull((Object)options, (String)("Failed to find items for Choices '" + this.uiObject.getDisplayName() + "'."));
                    boolean found = false;
                    for (WebElement option : options) {
                        String optionTextValue = option.getText();
                        if (optionTextValue != null && itemName.equals(optionTextValue.trim())) {
                            if (!option.isSelected()) {
                                PageScrollUtil.scrollToViewportAndClick(this.browser, option);
                            }
                            found = true;
                            continue;
                        }
                        if (!option.isSelected()) continue;
                        PageScrollUtil.scrollToViewportAndClick(this.browser, option);
                    }
                    if (!found) {
                        Assert.fail((String)("Failed to find item '" + itemName + "' in Choices '" + this.uiObject.getDisplayName() + "'."));
                    }
                    return;
                }
                catch (Throwable th) {
                    if (i == numRetries) {
                        throw th;
                    }
                    this.browser.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to select item '" + itemName + "' for element '" + this.uiObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void selectItems(ItemList<String> itemsToBeSelected, int numRetries) {
        try {
            for (int i = 0; i <= numRetries; ++i) {
                try {
                    WebElement selectElement = this.domObjValidator.findElement(0);
                    List options = selectElement.findElements(By.xpath((String)"./option"));
                    Assert.assertNotNull((Object)options, (String)("Failed to find items for Choices '" + this.uiObject.getDisplayName() + "'."));
                    LinkedList<String> foundItemList = new LinkedList<String>();
                    for (WebElement option : options) {
                        String optionTextValue = option.getText();
                        if (optionTextValue == null || !itemsToBeSelected.getItems().contains(optionTextValue.trim())) continue;
                        PageScrollUtil.scrollToViewportAndClick(this.browser, option);
                        foundItemList.add(optionTextValue.trim());
                    }
                    if (foundItemList.size() != itemsToBeSelected.size()) {
                        itemsToBeSelected.removeAll(foundItemList);
                        Assert.fail((String)("Failed to find item(s) '" + itemsToBeSelected + "' in Choices '" + this.uiObject.getDisplayName() + "'."));
                    }
                    return;
                }
                catch (Throwable th) {
                    if (i == numRetries) {
                        throw th;
                    }
                    this.browser.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to select item for element '" + this.uiObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void validateItemsPresent(ItemList<String> items, int numRetries) {
        try {
            for (int i = 0; i <= numRetries; ++i) {
                try {
                    WebElement selectElement = this.domObjValidator.findElement(0);
                    List options = selectElement.findElements(By.xpath((String)"./option"));
                    Assert.assertNotNull((Object)options, (String)("Failed to find items for Choices '" + this.uiObject.getDisplayName() + "'."));
                    Assert.assertTrue((options.size() > 0 ? 1 : 0) != 0, (String)("Failed to find items in Choices '" + this.uiObject.getDisplayName() + "'. Found 0 items."));
                    for (String item : items.getItems()) {
                        boolean found = false;
                        for (WebElement option : options) {
                            String optionTextValue = option.getText();
                            if (optionTextValue == null || !this.matchTextValue(optionTextValue.trim(), item, TextMatchMechanism.exactMatchWithExpectedValue)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        Assert.fail((String)("Failed to find item '" + item + "' in Choices '" + this.uiObject.getDisplayName() + "'."));
                    }
                    return;
                }
                catch (Throwable th) {
                    if (i == numRetries) {
                        throw th;
                    }
                    this.browser.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to validate item presence for element '" + this.uiObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void validateItemsNotPresent(ItemList<String> items, int numRetries) {
        try {
            for (int i = 0; i <= numRetries; ++i) {
                try {
                    WebElement selectElement = this.domObjValidator.findElement(0);
                    List options = selectElement.findElements(By.xpath((String)"./option"));
                    Assert.assertNotNull((Object)options, (String)("Failed to find items for Choices '" + this.uiObject.getDisplayName() + "'."));
                    Assert.assertTrue((options.size() > 0 ? 1 : 0) != 0, (String)("Failed to find items in Choices '" + this.uiObject.getDisplayName() + "'. Found 0 items."));
                    for (String item : items.getItems()) {
                        boolean found = false;
                        for (WebElement option : options) {
                            String optionTextValue = option.getText();
                            if (optionTextValue == null || !this.matchTextValue(optionTextValue.trim(), item, TextMatchMechanism.exactMatchWithExpectedValue)) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        Assert.fail((String)("Item '" + item + "' is present in Choices '" + this.uiObject.getDisplayName() + "'."));
                    }
                    return;
                }
                catch (Throwable th) {
                    if (i == numRetries) {
                        throw th;
                    }
                    this.browser.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to validate eitem absence for element '" + this.uiObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    public WebElement findElement(int numRetries) {
        return this.domObjValidator.findElement(numRetries);
    }

    public WebElement findElementNoException(int numRetries) {
        return this.domObjValidator.findElementNoException(numRetries);
    }

    @Override
    public List<WebElement> findElements(int numRetries) {
        return this.domObjValidator.findElements(numRetries);
    }
}

