/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.standard.imgobj.datagrid;

import java.util.List;
import org.openqa.selenium.Keys;
import org.sikuli.script.Button;
import org.sikuli.script.Location;
import org.sikuli.script.Match;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.commons.ImageSection;
import org.uitnet.testing.smartfwk.ui.core.commons.UIObjectType;
import org.uitnet.testing.smartfwk.ui.core.config.webbrowser.WebBrowser;
import org.uitnet.testing.smartfwk.ui.core.objects.ImageObject;
import org.uitnet.testing.smartfwk.ui.core.objects.NewTextLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.button.ButtonValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.scrollbar.Scrollbar;
import org.uitnet.testing.smartfwk.ui.core.objects.validator.mechanisms.TextMatchMechanism;
import org.uitnet.testing.smartfwk.ui.standard.imgobj.datagrid.HeaderColumnSI;

public class HeaderColumnValidatorSI
extends ButtonValidator {
    protected HeaderColumnSI headerColObj;

    public HeaderColumnValidatorSI(WebBrowser browser, HeaderColumnSI uiObject, Region region) {
        super(browser, uiObject, region);
        this.headerColObj = uiObject;
    }

    @Override
    public void validateName(String expectedName, TextMatchMechanism validationMechanism, int numRetries) {
        Match match = this.findElement(numRetries);
        this.validateTextValue(match.text(), expectedName, validationMechanism);
    }

    @Override
    @Deprecated
    public void validateDisabled(int numRetries) {
        Assert.fail((String)"validateDisabled() API is not supported by HeaderColumnSI.");
    }

    @Override
    @Deprecated
    public void validateEnabled(int numRetries) {
        Assert.fail((String)"validateEnabled() API is not supported by HeaderColumnSI.");
    }

    @Override
    public boolean isPresent(int numRetries) {
        Match m = this.findElementNoException(numRetries);
        return m != null;
    }

    @Override
    public boolean isVisible(int numRetries) {
        return this.isPresent(numRetries);
    }

    @Override
    public void click(int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.click();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse click on HeaderColumn '" + this.headerColObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    public void click(ImageSection imageSection, int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            this.getImageSection(match, imageSection).click();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse click on HeaderColumn '" + this.headerColObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void doubleClick(int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.doubleClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse double click on HeaderColumn '" + this.headerColObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    public void doubleClick(ImageSection imageSection, int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            this.getImageSection(match, imageSection).doubleClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse double click on HeaderColumn '" + this.headerColObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void rightClick(int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.rightClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse right click on HeaderColumn '" + this.headerColObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    public void rightClick(ImageSection imageSection, int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            this.getImageSection(match, imageSection).rightClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse right click on HeaderColumn '" + this.headerColObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void clickAndHold(int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.mouseDown(Button.LEFT);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse clickAndHold on HeaderColumn '" + this.headerColObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void release(int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.mouseDown(Button.LEFT);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse clickAndHold on HeaderColumn '" + this.headerColObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void performKeyDown(Keys keys, int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.click();
            match.keyDown(this.seleniumToSikuliKeyConverter(keys));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform keyDown on HeaderColumn '" + this.headerColObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void performKeyUp(Keys keys, int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.click();
            match.keyUp(this.seleniumToSikuliKeyConverter(keys));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform keyUp ('" + this.seleniumToSikuliKeyConverter(keys) + "') on HeaderColumn '" + this.headerColObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void performKeyPressed(Keys keys, int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.click();
            match.keyDown(this.seleniumToSikuliKeyConverter(keys));
            match.keyUp(this.seleniumToSikuliKeyConverter(keys));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform keyPressed ('" + this.seleniumToSikuliKeyConverter(keys) + "') on HeaderColumn '" + this.headerColObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    @Deprecated
    public void typeText(String text, NewTextLocation location, int numRetries) {
        Assert.fail((String)"typeText() API is not supported for HeaderColumn element.");
    }

    @Override
    public HeaderColumnValidatorSI scrollElementOnViewport(Scrollbar scrollbar) {
        return this;
    }

    public Match findElement(int numRetries) {
        Match match = null;
        for (int i = 0; i <= numRetries; ++i) {
            try {
                Region region = this.headerColObj.getColumnImageLocation().getRegionOfImageObject(this.browser, this.headerColObj.getColumnImage());
                Assert.assertNotNull((Object)region, (String)("Failed to find HeaderColumn '" + this.headerColObj.getDisplayName() + "'."));
                match = new Match(region, 1.0);
                break;
            }
            catch (Throwable th) {
                if (i == numRetries) {
                    Assert.fail((String)("Unable to find HeaderColumn '" + this.headerColObj.getDisplayName() + "'. Reason timeout(waited for " + numRetries * 2 + " seconds)."), (Throwable)th);
                    break;
                }
                this.browser.waitForSeconds(2);
                continue;
            }
        }
        return match;
    }

    public Match findElementNoException(int numRetries) {
        Match match = null;
        try {
            match = this.findElement(numRetries);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return match;
    }

    @Override
    public List<Match> findElements(int numRetries) {
        Region r = this.headerColObj.getColumnImageLocation().getRegion(this.browser);
        return new ImageObject(UIObjectType.headerColumn, this.headerColObj.getDisplayName(), this.headerColObj.getColumnImage()).getValidator(this.browser, r).findElements(numRetries);
    }

    public void dragAndDrop(ImageObject target, Region targetRegion, int numRetries) {
        try {
            Match sourceElem = this.findElement(numRetries);
            Match targetElem = target.getValidator(this.browser, targetRegion).findElement(numRetries);
            Assert.assertNotNull((Object)sourceElem, (String)("Failed to find HeaderColumn '" + this.headerColObj.getDisplayName() + "'."));
            Assert.assertNotNull((Object)targetElem, (String)("Failed to find element '" + target.getDisplayName() + "'."));
            sourceElem.drag((Object)targetElem);
            sourceElem.dropAt((Object)targetElem);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform dragAndDrop from source '" + this.headerColObj.getDisplayName() + "' to target '" + target.getDisplayName() + "'."), (Throwable)th);
        }
    }

    protected Location getImageSection(Match imageMatch, ImageSection imageSection) {
        switch (imageSection) {
            case topLeft: {
                return imageMatch.getTopLeft();
            }
            case topRight: {
                return imageMatch.getTopRight();
            }
            case bottomLeft: {
                return imageMatch.getBottomLeft();
            }
            case bottomRight: {
                return imageMatch.getBottomRight();
            }
            case center: {
                return imageMatch.getCenter();
            }
        }
        return null;
    }
}

