/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.objects;

import com.google.common.base.Function;
import java.util.List;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.interactions.MoveTargetOutOfBoundsException;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.config.webbrowser.WebBrowser;
import org.uitnet.testing.smartfwk.ui.core.objects.DOMObject;
import org.uitnet.testing.smartfwk.ui.core.objects.NewTextLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.UIObjectValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.scrollbar.Scrollbar;
import org.uitnet.testing.smartfwk.ui.core.utils.PageScrollUtil;

public class DOMObjectValidator
extends UIObjectValidator {
    private DOMObject domObject;

    public DOMObjectValidator(WebBrowser browser, DOMObject domObject, Region region) {
        super(browser, domObject, region);
        this.domObject = domObject;
    }

    @Override
    public DOMObject getUIObject() {
        return this.domObject;
    }

    public String getAttributeValue(String attributeName, int numRetries) {
        try {
            WebElement webElem = this.findElement(numRetries);
            return webElem.getAttribute(attributeName);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to get attribute (name='" + attributeName + "') value for element '" + this.domObject.getDisplayName() + "'."), (Throwable)th);
            return null;
        }
    }

    public String getAttributeValueWhenElementVisible(String attributeName, int numRetries) {
        try {
            for (int i = 0; i <= numRetries; ++i) {
                block6: {
                    try {
                        if (this.isVisible(0)) {
                            return this.getAttributeValue(attributeName, 0);
                        }
                        Assert.fail((String)"Element is not visible.");
                    }
                    catch (Throwable th) {
                        if (i != numRetries) break block6;
                        throw th;
                    }
                }
                this.browser.waitForSeconds(2);
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to get attribute '" + attributeName + "' value from visible element '" + this.domObject.getDisplayName() + "'."), (Throwable)th);
        }
        return null;
    }

    public String getAttributeValueWhenAttributeValueNonEmpty(String attributeName, int numRetries) {
        try {
            for (int i = 0; i <= numRetries; ++i) {
                block6: {
                    try {
                        String value = this.getAttributeValue(attributeName, 0);
                        if (value != null && !"".equals(value.trim())) {
                            return value;
                        }
                        Assert.fail((String)"Attribute value is empty.");
                    }
                    catch (Throwable th) {
                        if (i != numRetries) break block6;
                        throw th;
                    }
                }
                this.browser.waitForSeconds(2);
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to get non-empty attribute '" + attributeName + "' value from element '" + this.domObject.getDisplayName() + "'."), (Throwable)th);
        }
        return null;
    }

    public WebElement findElement(int numRetries) {
        WebElement webElem = null;
        for (int i = 0; i <= numRetries; ++i) {
            try {
                webElem = this.browser.getSeleniumWebDriver().findElement(this.domObject.getLocatorAsBy());
                Assert.assertNotNull((Object)webElem, (String)("Unable to find element '" + this.domObject.getDisplayName() + "'."));
                PageScrollUtil.scrollElemToViewport(this.browser, webElem);
                break;
            }
            catch (Throwable th) {
                if (i == numRetries) {
                    Assert.fail((String)("Unable to find element '" + this.domObject.getDisplayName() + "'. Reason timeout(waited for " + numRetries * 2 + " seconds)."), (Throwable)th);
                    break;
                }
                this.browser.waitForSeconds(2);
                continue;
            }
        }
        return webElem;
    }

    public void waitForPageLoad() {
        WebDriverWait wait = new WebDriverWait(this.browser.getSeleniumWebDriver(), 30L);
        wait.until((java.util.function.Function)new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                String readyState = String.valueOf(((JavascriptExecutor)DOMObjectValidator.this.browser.getSeleniumWebDriver()).executeScript("return document.readyState", new Object[0]));
                return "complete".equals(readyState);
            }
        });
    }

    public WebElement findElementNoException(int numRetries) {
        WebElement webElem = null;
        for (int i = 0; i <= numRetries; ++i) {
            try {
                webElem = this.browser.getSeleniumWebDriver().findElement(this.domObject.getLocatorAsBy());
                if (webElem != null) break;
                Assert.fail();
            }
            catch (Throwable th) {
                webElem = null;
                if (i == numRetries) break;
            }
            this.browser.waitForSeconds(2);
        }
        return webElem;
    }

    @Override
    public List<WebElement> findElements(int numRetries) {
        List webElems = null;
        for (int i = 0; i <= numRetries; ++i) {
            try {
                webElems = this.browser.getSeleniumWebDriver().findElements(this.domObject.getLocatorAsBy());
                Assert.assertNotNull((Object)webElems, (String)("Unable to find elements for '" + this.domObject.getDisplayName() + "'."));
                Assert.assertTrue((webElems.size() > 0 ? 1 : 0) != 0, (String)("Unable to find elements for '" + this.domObject.getDisplayName() + "' locator."));
                break;
            }
            catch (Throwable th) {
                if (i == numRetries) {
                    Assert.fail((String)("Unable to find elements for '" + this.uiObject.getDisplayName() + "' locator. Reason timeout(waited for " + numRetries * 2 + " seconds)."), (Throwable)th);
                    break;
                }
                this.browser.waitForSeconds(2);
                continue;
            }
        }
        return webElems;
    }

    @Override
    public DOMObjectValidator scrollElementOnViewport(Scrollbar scrollbar) {
        if (scrollbar == null) {
            return this;
        }
        scrollbar.scrollElementToViewport(this.browser, this.getUIObject());
        return this;
    }

    @Override
    public boolean isPresent(int numRetries) {
        boolean elemPresent = false;
        WebElement webElem = null;
        for (int i = 0; i <= numRetries; ++i) {
            try {
                webElem = this.browser.getSeleniumWebDriver().findElement(this.domObject.getLocatorAsBy());
                if (webElem != null) {
                    elemPresent = true;
                    break;
                }
                Assert.fail();
            }
            catch (Throwable th) {
                if (i == numRetries) break;
            }
            this.browser.waitForSeconds(2);
        }
        return elemPresent;
    }

    @Override
    public boolean isVisible(int numRetries) {
        boolean elemVisible = false;
        WebElement webElem = null;
        for (int i = 0; i <= numRetries; ++i) {
            try {
                webElem = this.browser.getSeleniumWebDriver().findElement(this.domObject.getLocatorAsBy());
                if (webElem != null && !"hidden".equals(webElem.getCssValue("visibility")) && webElem.getAttribute("hidden") == null) {
                    elemVisible = true;
                    break;
                }
                Assert.fail();
            }
            catch (Throwable th) {
                if (i == numRetries) break;
            }
            this.browser.waitForSeconds(2);
        }
        return elemVisible;
    }

    public boolean isReadonly(int numRetries) {
        boolean elemReadonly = false;
        WebElement webElem = null;
        for (int i = 0; i <= numRetries; ++i) {
            try {
                webElem = this.browser.getSeleniumWebDriver().findElement(this.domObject.getLocatorAsBy());
                if (webElem != null && webElem.getAttribute("readonly") != null) {
                    elemReadonly = true;
                    break;
                }
                Assert.fail();
            }
            catch (Throwable th) {
                if (i == numRetries) break;
            }
            this.browser.waitForSeconds(2);
        }
        return elemReadonly;
    }

    public boolean isDisabled(int numRetries) {
        boolean elemDisabled = false;
        WebElement webElem = null;
        for (int i = 0; i <= numRetries; ++i) {
            try {
                webElem = this.browser.getSeleniumWebDriver().findElement(this.domObject.getLocatorAsBy());
                if (webElem != null && !webElem.isEnabled()) {
                    elemDisabled = true;
                    break;
                }
                Assert.fail();
            }
            catch (Throwable th) {
                if (i == numRetries) break;
            }
            this.browser.waitForSeconds(2);
        }
        return elemDisabled;
    }

    public boolean isSelected(int numRetries) {
        boolean elemSelected = false;
        WebElement webElem = null;
        for (int i = 0; i <= numRetries; ++i) {
            try {
                webElem = this.browser.getSeleniumWebDriver().findElement(this.domObject.getLocatorAsBy());
                if (webElem != null && webElem.isSelected()) {
                    elemSelected = true;
                    break;
                }
                Assert.fail();
            }
            catch (Throwable th) {
                if (i == numRetries) break;
            }
            this.browser.waitForSeconds(2);
        }
        return elemSelected;
    }

    public String getText(int numRetries) {
        try {
            WebElement webElem = this.findElement(numRetries);
            return webElem.getText();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to get text from element '" + this.domObject.getDisplayName() + "'."), (Throwable)th);
            return null;
        }
    }

    public String getTextWhenElementVisible(int numRetries) {
        try {
            for (int i = 0; i <= numRetries; ++i) {
                block6: {
                    try {
                        if (this.isVisible(0)) {
                            return this.getText(0);
                        }
                        Assert.fail((String)"Text is not visible.");
                    }
                    catch (Throwable th) {
                        if (i != numRetries) break block6;
                        throw th;
                    }
                }
                this.browser.waitForSeconds(2);
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to get text from visible element '" + this.domObject.getDisplayName() + "'."), (Throwable)th);
        }
        return null;
    }

    public String getTextWhenElementValueNonEmpty(int numRetries) {
        try {
            for (int i = 0; i <= numRetries; ++i) {
                block7: {
                    try {
                        if (this.isVisible(0)) {
                            String value = this.getText(0);
                            if (value != null && !"".equals(value.trim())) {
                                return value;
                            }
                            Assert.fail((String)"Text is empty.");
                        }
                        Assert.fail((String)"Text is not visible.");
                    }
                    catch (Throwable th) {
                        if (i != numRetries) break block7;
                        throw th;
                    }
                }
                this.browser.waitForSeconds(2);
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to get non-empty text from visible element '" + this.domObject.getDisplayName() + "'."), (Throwable)th);
        }
        return null;
    }

    public void validatePresentWithNonEmptyText(int numRetries) {
        try {
            for (int i = 0; i <= numRetries; ++i) {
                block7: {
                    try {
                        if (this.isVisible(0)) {
                            String value = this.getText(0);
                            if (value != null && !"".equals(value.trim())) {
                                return;
                            }
                            Assert.fail((String)"Text is empty.");
                        }
                        Assert.fail((String)"Text is not visible.");
                    }
                    catch (Throwable th) {
                        if (i != numRetries) break block7;
                        throw th;
                    }
                }
                this.browser.waitForSeconds(2);
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Element '" + this.domObject.getDisplayName() + "' is not visible with non-empty text."), (Throwable)th);
        }
    }

    public void copyTextToClipboard(int numRetries) {
        try {
            for (int i = 0; i < 5; ++i) {
                try {
                    WebElement webElem = this.findElement(numRetries);
                    PageScrollUtil.scrollToViewportAndClick(this.browser, webElem);
                    Actions webActions = new Actions(this.browser.getSeleniumWebDriver());
                    webActions.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"})}).sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "c"})});
                    break;
                }
                catch (ElementNotVisibleException | MoveTargetOutOfBoundsException ex) {
                    this.browser.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to copy contents into clipboard. Element '" + this.domObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    public void pasteTextFromClipboard(int numRetries) {
        try {
            for (int i = 0; i < 5; ++i) {
                try {
                    WebElement webElem = this.findElement(numRetries);
                    PageScrollUtil.scrollToViewportAndClick(this.browser, webElem);
                    Actions webActions = new Actions(this.browser.getSeleniumWebDriver());
                    webActions.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"})}).sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "v"})}).build().perform();
                    break;
                }
                catch (ElementNotVisibleException | MoveTargetOutOfBoundsException ex) {
                    this.browser.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to paste clipboard contents into field '" + this.domObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void click(int numRetries) {
        try {
            for (int i = 0; i < 5; ++i) {
                try {
                    WebElement webElem = this.findElement(numRetries);
                    PageScrollUtil.scrollToViewportAndClick(this.browser, webElem);
                    break;
                }
                catch (ElementNotVisibleException | MoveTargetOutOfBoundsException ex) {
                    this.browser.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse click on element '" + this.domObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void doubleClick(int numRetries) {
        try {
            for (int i = 0; i < 5; ++i) {
                try {
                    WebElement webElem = this.findElement(numRetries);
                    PageScrollUtil.scrollToViewportAndDoubleClick(this.browser, webElem);
                    break;
                }
                catch (ElementNotVisibleException | MoveTargetOutOfBoundsException ex) {
                    this.browser.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse double click on element '" + this.domObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void rightClick(int numRetries) {
        try {
            WebElement webElem = this.findElement(numRetries);
            Point location = webElem.getLocation();
            Dimension size = webElem.getSize();
            this.browser.getSikuliScreen().rightClick((Object)new Region(location.getX(), location.getY(), size.getWidth(), size.getHeight()));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse right click on element '" + this.domObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void clickAndHold(int numRetries) {
        for (int i = 0; i < 5; ++i) {
            try {
                WebElement webElem = this.findElement(numRetries);
                PageScrollUtil.scrollToViewportAndClickAndHold(this.browser, webElem);
                break;
            }
            catch (ElementNotVisibleException | MoveTargetOutOfBoundsException ex) {
                this.browser.waitForSeconds(2);
                continue;
            }
        }
    }

    @Override
    public void release(int numRetries) {
        for (int i = 0; i < 5; ++i) {
            try {
                WebElement webElem = this.findElement(numRetries);
                PageScrollUtil.scrollToViewportAndRelease(this.browser, webElem);
                break;
            }
            catch (ElementNotVisibleException | MoveTargetOutOfBoundsException ex) {
                this.browser.waitForSeconds(2);
                continue;
            }
        }
    }

    public void dragAndDrop(DOMObject target, int numRetries) {
        try {
            for (int i = 0; i < 5; ++i) {
                try {
                    WebElement sourceElem = this.findElement(numRetries);
                    WebElement targetElem = target.getValidator(this.browser, this.region).findElement(numRetries);
                    PageScrollUtil.scrollToViewportAndDragAndDrop(this.browser, sourceElem, targetElem);
                    break;
                }
                catch (ElementNotVisibleException | MoveTargetOutOfBoundsException ex) {
                    this.browser.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform dragAndDrop from source '" + this.domObject.getDisplayName() + "' to target '" + target.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void performKeyDown(Keys keys, int numRetries) {
        for (int i = 0; i < 5; ++i) {
            try {
                WebElement webElem = this.findElement(numRetries);
                Actions actions = new Actions(this.browser.getSeleniumWebDriver());
                actions.keyDown(webElem, (CharSequence)keys).build().perform();
                break;
            }
            catch (ElementNotVisibleException | MoveTargetOutOfBoundsException ex) {
                this.browser.waitForSeconds(2);
                continue;
            }
        }
    }

    @Override
    public void performKeyUp(Keys keys, int numRetries) {
        for (int i = 0; i < 5; ++i) {
            try {
                WebElement webElem = this.findElement(numRetries);
                Actions actions = new Actions(this.browser.getSeleniumWebDriver());
                actions.keyUp(webElem, (CharSequence)keys).build().perform();
                break;
            }
            catch (ElementNotVisibleException | MoveTargetOutOfBoundsException ex) {
                this.browser.waitForSeconds(2);
                continue;
            }
        }
    }

    @Override
    public void performKeyPressed(Keys keys, int numRetries) {
        for (int i = 0; i < 5; ++i) {
            try {
                WebElement webElem = this.findElement(numRetries);
                Actions actions = new Actions(this.browser.getSeleniumWebDriver());
                actions.keyDown(webElem, (CharSequence)keys).keyUp(webElem, (CharSequence)keys).build().perform();
                break;
            }
            catch (ElementNotVisibleException | MoveTargetOutOfBoundsException ex) {
                this.browser.waitForSeconds(2);
                continue;
            }
        }
    }

    @Override
    public void typeText(String text, NewTextLocation location, int numRetries) {
        for (int i = 0; i < 5; ++i) {
            try {
                WebElement webElem = this.findElement(numRetries);
                switch (location) {
                    case start: {
                        String newtext = text;
                        Actions actions = new Actions(this.browser.getSeleniumWebDriver());
                        webElem.sendKeys(new CharSequence[]{Keys.HOME});
                        actions.sendKeys(webElem, new CharSequence[]{newtext}).build().perform();
                        break;
                    }
                    case end: {
                        String newtext = text;
                        Actions actions = new Actions(this.browser.getSeleniumWebDriver());
                        webElem.sendKeys(new CharSequence[]{Keys.END});
                        actions.sendKeys(webElem, new CharSequence[]{newtext}).build().perform();
                        break;
                    }
                    case replace: {
                        webElem.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"})});
                        webElem.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
                        Actions actions = new Actions(this.browser.getSeleniumWebDriver());
                        actions.sendKeys(webElem, new CharSequence[]{text}).build().perform();
                    }
                }
                break;
            }
            catch (ElementNotVisibleException | MoveTargetOutOfBoundsException ex) {
                this.browser.waitForSeconds(2);
                continue;
            }
        }
    }
}

