/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.objects.webpage;

import java.util.List;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.testng.Assert;
import org.testng.Reporter;
import org.uitnet.testing.smartfwk.ui.core.commons.UIObjectType;
import org.uitnet.testing.smartfwk.ui.core.config.webbrowser.WebBrowser;
import org.uitnet.testing.smartfwk.ui.core.events.InputEvent;
import org.uitnet.testing.smartfwk.ui.core.objects.NewTextLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.UIObject;
import org.uitnet.testing.smartfwk.ui.core.objects.UIObjectValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.scrollbar.Scrollbar;
import org.uitnet.testing.smartfwk.ui.core.objects.tab.Tab;
import org.uitnet.testing.smartfwk.ui.core.objects.webpage.PathItem;
import org.uitnet.testing.smartfwk.ui.core.objects.webpage.WebPage;
import org.uitnet.testing.smartfwk.ui.core.objects.webpage.WebPageStatus;

public class WebPageValidator
extends UIObjectValidator {
    private WebPage webPage;

    public WebPageValidator(WebBrowser browser, WebPage element) {
        super(browser, element, null);
        this.webPage = element;
    }

    @Override
    public WebPage getUIObject() {
        return this.webPage;
    }

    public void setComponent(WebPage component) {
        this.webPage = component;
    }

    public void validateWebPagePresent(int numRetries) {
        if (!this.isPresent(numRetries)) {
            Assert.fail((String)("Web page (" + this.webPage.getTitle().getDisplayName() + ") is not recognized as per the provided recognition parameters."));
        }
    }

    protected boolean checkWebPagePresence() {
        boolean webPagePresent = this.isWebPageInputParamsValid();
        try {
            for (PathItem pathItem : this.webPage.getLaunchPath().getPath()) {
                UIObject item = pathItem.getItem();
                Assert.assertNotNull((Object)item, (String)("Found null item in WebPage(" + this.webPage.getTitle().getDisplayName() + ")->launchPath->pathItem"));
                if (!(item instanceof Tab)) continue;
                ((Tab)item).getValidator(this.browser, null).validateSelected(0);
            }
            for (UIObject item1 : this.webPage.getPageRecognitionItems().getItems()) {
                item1.getValidator(this.browser, null).validatePresent(5);
            }
        }
        catch (Throwable ex) {
            webPagePresent = false;
            Reporter.log((String)("Error during checking of web page presence. ErrorMessage: " + ex.getMessage()));
        }
        return webPagePresent;
    }

    public void openWebPage() {
        if (!this.checkWebPagePresence()) {
            Reporter.log((String)("Going to open web page - " + this.webPage.getTitle().getDisplayName()));
            for (PathItem pathItem : this.webPage.getLaunchPath().getPath()) {
                UIObject item = pathItem.getItem();
                InputEvent itemEvent = pathItem.getEvent();
                Assert.assertNotNull((Object)item, (String)("Found null item in WebPage(" + this.webPage.getTitle().getDisplayName() + ")->launchPath->pathItem"));
                Assert.assertNotNull((Object)itemEvent, (String)("Found null input event in WebPage(" + this.webPage.getTitle().getDisplayName() + ")->launchPath->pathItem"));
                if (item.getType() == UIObjectType.tab) {
                    ((Tab)item).getValidator(this.browser, null).selectTab(0);
                } else {
                    item.getValidator(this.browser, null).performAction(itemEvent, 0);
                }
                this.browser.waitForSeconds(1);
            }
            if (this.checkWebPagePresence()) {
                Reporter.log((String)("Web page (" + this.webPage.getTitle().getDisplayName() + ") opened successfully."));
                this.webPage.setStatus(WebPageStatus.Started);
            } else {
                Reporter.log((String)("ERROR: Failed to open web page (" + this.webPage.getTitle().getDisplayName() + ")."));
            }
        } else {
            this.webPage.setStatus(WebPageStatus.Started);
        }
    }

    private boolean isWebPageInputParamsValid() {
        boolean valid = true;
        Assert.assertNotNull((Object)this.webPage.getTitle(), (String)"Please specify the web page title.");
        Assert.assertNotNull((Object)this.webPage.getTitle().getDisplayName(), (String)"Please specify the display name in web page title.");
        if (this.webPage.getLaunchPath() != null || this.webPage.getPageRecognitionItems() != null) {
            if (this.webPage.getLaunchPath() == null || this.webPage.getLaunchPath().getPath().size() < 1) {
                valid = false;
                Assert.fail((String)"Please specify the web page launch path.");
            } else if (this.webPage.getPageRecognitionItems() == null || this.webPage.getPageRecognitionItems().getItems().size() < 1) {
                valid = false;
                Assert.fail((String)"Please specify the web page recognition items.");
            }
        }
        return valid;
    }

    @Override
    public boolean isPresent(int numRetries) {
        boolean present = false;
        present = this.checkWebPagePresence();
        return present;
    }

    @Override
    public boolean isVisible(int numRetries) {
        return this.isPresent(numRetries);
    }

    @Override
    public void click(int numRetries) {
        Assert.fail((String)"Web page click not supported.");
    }

    @Override
    public void doubleClick(int numRetries) {
        Assert.fail((String)"Web page double click not supported.");
    }

    @Override
    public void rightClick(int numRetries) {
        Assert.fail((String)"Web page right click not supported.");
    }

    @Override
    public WebPageValidator scrollElementOnViewport(Scrollbar scrollbar) {
        Assert.fail((String)"Web page scrollElementOnViewport not supported.");
        return this;
    }

    @Override
    public void clickAndHold(int numRetries) {
        Assert.fail((String)"Web page clickAndHold not supported.");
    }

    @Override
    public void release(int numRetries) {
        Assert.fail((String)"Web page release not supported.");
    }

    @Override
    public void performKeyDown(Keys keys, int numRetries) {
        Assert.fail((String)"Web page performKeyDown not supported.");
    }

    @Override
    public void performKeyUp(Keys keys, int numRetries) {
        Assert.fail((String)"Web page performKeyUp not supported.");
    }

    @Override
    public void performKeyPressed(Keys keys, int numRetries) {
        Assert.fail((String)"Web page performKeyPressed not supported.");
    }

    @Override
    public void typeText(String text, NewTextLocation location, int numRetries) {
        Assert.fail((String)"Web page typeText not supported.");
    }

    public WebElement findElement(int numRetries) {
        Assert.fail((String)"findElement operation is not applicable.");
        return null;
    }

    public WebElement findElementNoException(int numRetries) {
        Assert.fail((String)"findElementNoException operation is not applicable.");
        return null;
    }

    @Override
    public List<WebElement> findElements(int numRetries) {
        Assert.fail((String)"findElements operation is not applicable.");
        return null;
    }
}

