/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.api.core.validator.json;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.TypeRef;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.api.core.reader.JsonDocumentReader;

public class JsonDocumentValidator {
    protected JsonDocumentReader jsonDocReader;

    public JsonDocumentValidator(String jsonAsString) {
        this.jsonDocReader = new JsonDocumentReader(jsonAsString);
    }

    public JsonDocumentValidator(File jsonFilePath) {
        this.jsonDocReader = new JsonDocumentReader(jsonFilePath);
    }

    public DocumentContext getDocumentContext() {
        return this.jsonDocReader.getDocumentContext();
    }

    public <T> List<T> readValuesAsList(String jsonPath) {
        return this.jsonDocReader.readValuesAsList(jsonPath);
    }

    public <T> Set<T> readValuesAsSet(String jsonPath) {
        return this.jsonDocReader.readValuesAsSet(jsonPath);
    }

    public <T> T readSingleValue(String jsonPath) {
        return this.jsonDocReader.readSingleValue(jsonPath);
    }

    public void validatePathValuesPresent(String elementName, String jsonPath) {
        List elems = (List)this.jsonDocReader.getDocumentContext().read(jsonPath, new Predicate[0]);
        Assert.assertTrue((elems.size() > 0 ? 1 : 0) != 0, (String)("Element '" + elementName + "' does not exist on JSON Path '" + jsonPath + "'."));
    }

    public <T> void validateValuesPresent(String elementName, String jsonPath, T[] values) {
        TypeRef typeRef = new TypeRef<Set<T>>(){};
        Set elems = (Set)this.jsonDocReader.getDocumentContext().read(jsonPath, typeRef);
        Assert.assertFalse((elems.size() == 0 ? 1 : 0) != 0, (String)("No record found for Element '" + elementName + "' on JSON path '" + jsonPath + "'. Expects records with values: " + Arrays.asList(values) + "."));
        HashSet<T> valuesAsSet = new HashSet<T>(Arrays.asList(values));
        valuesAsSet.removeAll(elems);
        Assert.assertTrue((valuesAsSet.size() == 0 ? 1 : 0) != 0, (String)("Following values " + valuesAsSet + " do not exist for Element '" + elementName + "' on JSON Path '" + jsonPath + "'. JSON element values: " + elems));
    }

    public <T> void validateExactMatchForValues(String elementName, String jsonPath, T[] values) {
        TypeRef typeRef = new TypeRef<Set<T>>(){};
        Set elems = (Set)this.jsonDocReader.getDocumentContext().read(jsonPath, typeRef);
        Assert.assertFalse((elems.size() == 0 ? 1 : 0) != 0, (String)("No record found for Element '" + elementName + "' on JSON path '" + jsonPath + "'. Expects records with values: " + Arrays.asList(values) + "."));
        HashSet<T> valuesAsSet1 = new HashSet<T>(Arrays.asList(values));
        HashSet<T> valuesAsSet2 = new HashSet<T>(Arrays.asList(values));
        valuesAsSet1.removeAll(elems);
        elems.removeAll(valuesAsSet2);
        Assert.assertTrue((valuesAsSet1.size() == 0 ? 1 : 0) != 0, (String)("Values " + valuesAsSet1 + " are not present for Element '" + elementName + "' on JSON Path '" + jsonPath + "'. Expecting JSON path values: " + valuesAsSet2 + "."));
        Assert.assertTrue((elems.size() == 0 ? 1 : 0) != 0, (String)("Values " + elems + " are extra for Element '" + elementName + "' on JSON Path '" + jsonPath + "'. Expecting JSON path values: " + valuesAsSet2 + "."));
    }

    public <T> void validateSingleValueMatch(String elementName, String jsonPath, Class<T> valueClazz, T value) {
        Object elemValue = this.jsonDocReader.getDocumentContext().read(jsonPath, valueClazz, new Predicate[0]);
        Assert.assertEquals((Object)elemValue, value, (String)("Element '" + elementName + "' value does not match at JSON path '" + jsonPath + "'."));
    }

    public static void main(String[] args) {
        String jsonString = JsonDocumentValidator.sampleJson();
        JsonDocumentValidator validator = new JsonDocumentValidator(jsonString);
        validator.validatePathValuesPresent("Price Range", "$..price_range");
        validator.validateValuesPresent("Price", "$.book[*].price", new Double[]{49.99, 29.99, 8.99});
        validator.validateExactMatchForValues("Price", "$.book[*].price", new Double[]{49.99, 29.99, 8.99, 6.0});
        validator.validateSingleValueMatch("First Book Author", "$.book[0].author", String.class, "Ben Smith");
        validator.validateSingleValueMatch("First Book Price", "$.book[0].price", Double.class, 49.99);
        Double price = (Double)validator.readSingleValue("$.book[0].price");
        System.out.println("Double price: " + price);
    }

    private static String sampleJson() {
        String json = "{\r\n    \"book\": \r\n    [\r\n        {\r\n            \"title\": \"Beginning JSON\",\r\n            \"author\": \"Ben Smith\",\r\n            \"price\": 49.99\r\n        },\r\n\r\n        {\r\n            \"title\": \"JSON at Work\",\r\n            \"author\": \"Tom Marrs\",\r\n            \"price\": 29.99\r\n        },\r\n\r\n        {\r\n            \"title\": \"Learn JSON in a DAY\",\r\n            \"author\": \"Acodemy\",\r\n            \"price\": 8.99\r\n        },\r\n\r\n        {\r\n            \"title\": \"JSON: Questions and Answers\",\r\n            \"author\": \"George Duckett\",\r\n            \"price\": 6.00\r\n        }\r\n    ],\r\n\r\n    \"price_range\": \r\n    {\r\n        \"cheap\": 10.00,\r\n        \"medium\": 20.00\r\n    }\r\n}";
        return json;
    }
}

