/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.actions;

import java.util.ArrayList;
import java.util.List;
import org.uitnet.testing.smartfwk.ui.core.actions.InputAction;
import org.uitnet.testing.smartfwk.ui.core.actions.InputActionHandler;
import org.uitnet.testing.smartfwk.ui.core.config.webbrowser.WebBrowser;
import org.uitnet.testing.smartfwk.ui.core.objects.UIObject;
import org.uitnet.testing.smartfwk.ui.core.objects.webpage.WebPage;
import org.uitnet.testing.smartfwk.ui.standard.imgobj.WebPageTitleSI;

public class InputActions {
    private String name;
    private List<InputAction> actions;
    private WebPage webPage;
    private List<UIObject> pageRecognitionItems;

    public InputActions(String name, WebPage webPage) {
        this.name = name;
        this.actions = new ArrayList<InputAction>(10);
        this.webPage = webPage;
        this.pageRecognitionItems = new ArrayList<UIObject>(2);
    }

    public String getName() {
        return this.name;
    }

    public InputActions append(InputAction action) {
        this.actions.add(action);
        return this;
    }

    public List<InputAction> getActions() {
        return this.actions;
    }

    public InputActionHandler getActionHandler(WebBrowser browser) {
        return new InputActionHandler(browser, this);
    }

    public WebPage getWebPage() {
        return this.webPage;
    }

    public void setWebPage(WebPage webPage) {
        this.webPage = webPage;
    }

    public InputActions appendPageRecognitionItem(UIObject item) {
        this.pageRecognitionItems.add(item);
        return this;
    }

    public List<UIObject> getPageRecognitionItems() {
        return this.pageRecognitionItems;
    }

    public String getReadablePath() {
        String readablePath = "";
        for (InputAction action : this.actions) {
            if ("".equals(readablePath)) {
                readablePath = action.getItem().getDisplayName() + "(" + action.getEvent().getName() + ")";
                continue;
            }
            readablePath = readablePath + " -> " + action.getItem().getDisplayName() + "(" + action.getEvent().getName() + ")";
        }
        return readablePath;
    }

    public WebPage getExpectedWebPage() {
        return new WebPage(new WebPageTitleSI(this.webPage.getTitle().getDisplayName() + ":> " + this.getReadablePath(), null), null, null);
    }
}

