/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.config;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.UnexpectedAlertBehaviour;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.config.webbrowser.WebBrowserType;
import org.uitnet.testing.smartfwk.ui.core.utils.StringUtil;

public class SeleniumDriverConfig {
    private WebBrowserType browserType = null;
    private String driverSystemPropertyName;
    private String driverBinaryFilePath;
    private boolean headless = false;
    private PageLoadStrategy pageLoadStrategy = PageLoadStrategy.NORMAL;
    private UnexpectedAlertBehaviour unexpectedAlertBehaviour = UnexpectedAlertBehaviour.DISMISS;
    private Level logLevel = Level.SEVERE;
    private List<String> arguments = new ArrayList<String>();
    private Map<String, Object> driverCapabilities = new HashMap<String, Object>(3);
    private Map<String, Object> experimentalOptions = new HashMap<String, Object>(3);
    private List<File> browserExtensionFiles = new ArrayList<File>();
    private boolean deleteExtensionsCacheIfItExists = true;
    private boolean alwaysLoadNoFocusLib = false;
    private Map<String, Object> browserPreferences = new HashMap<String, Object>(3);
    private boolean acceptInsecureCertificates = false;
    private boolean acceptUntrustedCertificates = false;
    private boolean assumeUntrustedCertificateIssuer = false;
    private String profilePath;
    private Integer scriptTimeoutInSecs = 60;
    private Integer pageLoadTimeoutInSecs = 60;

    public SeleniumDriverConfig(String seleniumConfigDir, Properties properties) {
        this.init(seleniumConfigDir, properties);
    }

    private void init(String seleniumConfigDir, Properties properties) {
        String args;
        this.browserType = WebBrowserType.getTypeByName(this.getProperty(properties, "BROWSER_TYPE"));
        this.driverSystemPropertyName = this.getProperty(properties, "DRIVER_SYSTEM_PROPERTY_NAME");
        this.driverBinaryFilePath = this.getProperty(properties, "BROWSER_DRIVER_BINARY_FILE_PATH");
        if (this.driverBinaryFilePath == null) {
            this.driverBinaryFilePath = this.getProperty(properties, "BROWSER_DRIVER_FILENAME");
            if (this.driverBinaryFilePath != null && !"".equals(this.driverBinaryFilePath.trim())) {
                this.driverBinaryFilePath = seleniumConfigDir + File.separator + "web-drivers" + File.separator + this.browserType.name() + File.separator + this.driverBinaryFilePath.trim();
            }
        }
        this.headless = Boolean.parseBoolean(this.getProperty(properties, "HEADLESS"));
        this.pageLoadStrategy = PageLoadStrategy.fromString((String)this.getProperty(properties, "PAGE_LOAD_STRATEGY"));
        this.unexpectedAlertBehaviour = UnexpectedAlertBehaviour.fromString((String)this.getProperty(properties, "UNEXPECTED_ALERT_BEHAVIOUR"));
        if (this.getProperty(properties, "LOG_LEVEL") != null) {
            this.logLevel = Level.parse(this.getProperty(properties, "LOG_LEVEL"));
        }
        if (!StringUtil.isEmptyAfterTrim(args = this.getProperty(properties, "DRIVER_ARGUMENTS"))) {
            String[] argArr;
            for (String a : argArr = args.split(" ")) {
                if (StringUtil.isEmptyAfterTrim(a)) continue;
                this.arguments.add(a.trim());
            }
        }
        for (Object key : properties.keySet()) {
            String strKey = (String)key;
            String value = properties.getProperty(strKey);
            if (strKey.startsWith("DriverCapability.")) {
                this.driverCapabilities.put(strKey.substring("DriverCapability.".length()), this.parseTypedValue(strKey, value));
            }
            if (strKey.startsWith("ExperimentalOption.")) {
                this.experimentalOptions.put(strKey.substring("ExperimentalOption.".length()), this.parseTypedValue(strKey, value));
            }
            if (strKey.startsWith("BrowserExtension.")) {
                this.browserExtensionFiles.add(new File(seleniumConfigDir + File.separator + "web-drivers" + File.separator + this.browserType.name() + File.separator + "extensions" + File.separator + value));
            }
            if (!strKey.startsWith("BrowserPreference.")) continue;
            this.experimentalOptions.put(strKey.substring("BrowserPreference.".length()), this.parseTypedValue(strKey, value));
        }
        this.deleteExtensionsCacheIfItExists = Boolean.parseBoolean(this.getProperty(properties, "DELETE_EXTENSIONS_CACHE_IF_IT_EXISTS"));
        this.alwaysLoadNoFocusLib = Boolean.parseBoolean(this.getProperty(properties, "ALWAYS_LOAD_NO_FOCUS_LIB"));
        this.acceptInsecureCertificates = Boolean.parseBoolean(this.getProperty(properties, "ACCEPT_INSECURE_CERTIFICATES"));
        this.acceptUntrustedCertificates = Boolean.parseBoolean(this.getProperty(properties, "ACCEPT_UNTRUSTED_CERTIFICATES"));
        this.assumeUntrustedCertificateIssuer = Boolean.parseBoolean(this.getProperty(properties, "ASSUME_UNTRUSTED_CERTIFICATE_ISSUER"));
        this.profilePath = seleniumConfigDir + File.separator + "web-drivers" + File.separator + this.browserType.name() + File.separator + "profile";
        this.scriptTimeoutInSecs = Integer.parseInt(this.getProperty(properties, "SCRIPT_TIMEOUT_IN_SECONDS"));
        this.pageLoadTimeoutInSecs = Integer.parseInt(this.getProperty(properties, "PAGE_LOAD_TIMEOUT_IN_SECONDS"));
    }

    private Object parseTypedValue(String key, String typedValue) {
        String[] typeAndValue = typedValue.split(":");
        Assert.assertNotEquals((Object)typeAndValue, (Object)2, (String)("Value defined in '" + this.browserType.name() + "' browser DriverConfig.properties is incorrect for key '" + key + "'. Correct format is: <dataType>:<value>"));
        switch (typeAndValue[0]) {
            case "boolean": {
                return Boolean.parseBoolean(typeAndValue[1]);
            }
            case "string": {
                return typeAndValue[1];
            }
            case "integer": {
                return Integer.parseInt(typeAndValue[1]);
            }
            case "float": {
                return Float.valueOf(Float.parseFloat(typeAndValue[1]));
            }
            case "double": {
                return Double.parseDouble(typeAndValue[1]);
            }
        }
        Assert.fail((String)("Value datatype defined in '" + this.browserType.name() + "' browser DriverConfig.properties is incorrect for key '" + key + "'. Supported data types are: boolean, string, integer, float, double"));
        return null;
    }

    private String getProperty(Properties properties, String propName) {
        return StringUtil.trim(properties.getProperty(propName));
    }

    public WebBrowserType getBrowserType() {
        return this.browserType;
    }

    public void setBrowserType(WebBrowserType browserType) {
        this.browserType = browserType;
    }

    public String getDriverSystemPropertyName() {
        return this.driverSystemPropertyName;
    }

    public void setDriverSystemPropertyName(String driverSystemPropertyName) {
        this.driverSystemPropertyName = driverSystemPropertyName;
    }

    public String getDriverBinaryFilePath() {
        return this.driverBinaryFilePath;
    }

    public void setDriverBinaryFilePath(String driverBinaryFilePath) {
        this.driverBinaryFilePath = driverBinaryFilePath;
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public void setHeadless(boolean headless) {
        this.headless = headless;
    }

    public PageLoadStrategy getPageLoadStrategy() {
        return this.pageLoadStrategy;
    }

    public void setPageLoadStrategy(PageLoadStrategy pageLoadStrategy) {
        this.pageLoadStrategy = pageLoadStrategy;
    }

    public UnexpectedAlertBehaviour getUnexpectedAlertBehaviour() {
        return this.unexpectedAlertBehaviour;
    }

    public void setUnexpectedAlertBehaviour(UnexpectedAlertBehaviour unexpectedAlertBehaviour) {
        this.unexpectedAlertBehaviour = unexpectedAlertBehaviour;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(Level logLevel) {
        this.logLevel = logLevel;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    public Map<String, Object> getDriverCapabilities() {
        return this.driverCapabilities;
    }

    public void setDriverCapabilities(Map<String, Object> driverCapabilities) {
        this.driverCapabilities = driverCapabilities;
    }

    public Map<String, Object> getExperimentalOptions() {
        return this.experimentalOptions;
    }

    public void setExperimentalOptions(Map<String, Object> experimentalOptions) {
        this.experimentalOptions = experimentalOptions;
    }

    public List<File> getBrowserExtensionFiles() {
        return this.browserExtensionFiles;
    }

    public void setBrowserExtensionFiles(List<File> browserExtensionFiles) {
        this.browserExtensionFiles = browserExtensionFiles;
    }

    public boolean isDeleteExtensionsCacheIfItExists() {
        return this.deleteExtensionsCacheIfItExists;
    }

    public void setDeleteExtensionsCacheIfItExists(boolean deleteExtensionsCacheIfItExists) {
        this.deleteExtensionsCacheIfItExists = deleteExtensionsCacheIfItExists;
    }

    public boolean isAlwaysLoadNoFocusLib() {
        return this.alwaysLoadNoFocusLib;
    }

    public void setAlwaysLoadNoFocusLib(boolean alwaysLoadNoFocusLib) {
        this.alwaysLoadNoFocusLib = alwaysLoadNoFocusLib;
    }

    public Map<String, Object> getBrowserPreferences() {
        return this.browserPreferences;
    }

    public void setBrowserPreferences(Map<String, Object> browserPreferences) {
        this.browserPreferences = browserPreferences;
    }

    public boolean isAcceptInsecureCertificates() {
        return this.acceptInsecureCertificates;
    }

    public void setAcceptInsecureCertificates(boolean acceptInsecureCertificates) {
        this.acceptInsecureCertificates = acceptInsecureCertificates;
    }

    public boolean isAcceptUntrustedCertificates() {
        return this.acceptUntrustedCertificates;
    }

    public void setAcceptUntrustedCertificates(boolean acceptUntrustedCertificates) {
        this.acceptUntrustedCertificates = acceptUntrustedCertificates;
    }

    public boolean isAssumeUntrustedCertificateIssuer() {
        return this.assumeUntrustedCertificateIssuer;
    }

    public void setAssumeUntrustedCertificateIssuer(boolean assumeUntrustedCertificateIssuer) {
        this.assumeUntrustedCertificateIssuer = assumeUntrustedCertificateIssuer;
    }

    public String getProfilePath() {
        return this.profilePath;
    }

    public void setProfilePath(String profilePath) {
        this.profilePath = profilePath;
    }

    public Integer getScriptTimeoutInSecs() {
        return this.scriptTimeoutInSecs;
    }

    public void setScriptTimeoutInSecs(Integer scriptTimeoutInSecs) {
        this.scriptTimeoutInSecs = scriptTimeoutInSecs;
    }

    public Integer getPageLoadTimeoutInSecs() {
        return this.pageLoadTimeoutInSecs;
    }

    public void setPageLoadTimeoutInSecs(Integer pageLoadTimeoutInSecs) {
        this.pageLoadTimeoutInSecs = pageLoadTimeoutInSecs;
    }
}

