/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.config;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.testng.Assert;

public class SikuliSettings {
    private String sikuliSettingsFilePath;
    private String ocrDataPath;
    private Properties props;

    public SikuliSettings(String sikuliSettingsFilePath, Properties props) {
        this.sikuliSettingsFilePath = sikuliSettingsFilePath;
        this.props = props;
        this.ocrDataPath = sikuliSettingsFilePath + File.separator + "tessdata";
    }

    public String getOcrDataPath() {
        return this.ocrDataPath;
    }

    public String getPropertyValue(String propName) {
        if (!propName.startsWith("_") && !propName.startsWith("Settings.")) {
            Assert.fail((String)"Property name should start with prefix underscore ( _ ) or Settings.");
        }
        if (!this.props.containsKey(propName)) {
            Assert.fail((String)("Please specify the property '" + propName + "' in '" + this.sikuliSettingsFilePath + "' file."));
        }
        return this.props.getProperty(propName);
    }

    public Map<String, String> getAllSettings() {
        LinkedHashMap<String, String> keyValuePairs = new LinkedHashMap<String, String>();
        for (Object key : this.props.keySet()) {
            String strKey = (String)key;
            if (!strKey.startsWith("Settings.")) continue;
            keyValuePairs.put(strKey.substring("Settings.".length()), this.props.getProperty(strKey));
        }
        return keyValuePairs;
    }
}

