/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.config.webbrowser;

import java.io.File;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeDriverService;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxDriverLogLevel;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerDriverService;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.opera.OperaDriver;
import org.openqa.selenium.opera.OperaDriverService;
import org.openqa.selenium.opera.OperaOptions;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.safari.SafariDriverService;
import org.openqa.selenium.safari.SafariOptions;
import org.sikuli.basics.Settings;
import org.sikuli.script.OCR;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.config.AppConfig;
import org.uitnet.testing.smartfwk.ui.core.config.ProxyConfiguration;
import org.uitnet.testing.smartfwk.ui.core.config.SeleniumDriverConfig;
import org.uitnet.testing.smartfwk.ui.core.config.TestConfigManager;
import org.uitnet.testing.smartfwk.ui.core.config.webbrowser.WebBrowser;
import org.uitnet.testing.smartfwk.ui.core.config.webbrowser.WebBrowserType;

public class WebBrowserFactory {
    private static WebBrowserFactory instance = null;
    private Map<String, WebBrowser> appBrowserMap;
    private TestConfigManager testConfigMgr = TestConfigManager.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WebBrowserFactory getInstance() {
        if (instance != null) return instance;
        Class<WebBrowserFactory> clazz = WebBrowserFactory.class;
        synchronized (WebBrowserFactory.class) {
            if (instance != null) return instance;
            instance = new WebBrowserFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private WebBrowserFactory() {
        this.appBrowserMap = new HashMap<String, WebBrowser>(3);
        this.initializeSikuli();
    }

    protected void initializeSikuli() {
        try {
            Map<String, String> settings = this.testConfigMgr.getSikuliSettings().getAllSettings();
            for (String name : settings.keySet()) {
                String value = settings.get(name);
                Field f = Settings.class.getDeclaredField(name);
                if (f.isAccessible()) {
                    f.set(null, this.createObjectFromTypedValue(name, value));
                    continue;
                }
                f.setAccessible(true);
                f.set(null, this.createObjectFromTypedValue(name, value));
                f.setAccessible(false);
            }
            System.out.println("Sikuli OCRDataPath set to: " + this.testConfigMgr.getSikuliSettings().getOcrDataPath());
            OCR.Options ocrOptions = OCR.globalOptions();
            ocrOptions.dataPath(this.testConfigMgr.getSikuliSettings().getOcrDataPath());
        }
        catch (Throwable th) {
            Assert.fail((String)"Failed to initialize the sikuli driver.", (Throwable)th);
        }
    }

    protected Object createObjectFromTypedValue(String propertyName, String typedValue) {
        String[] typeValueArr = typedValue.split(":");
        Assert.assertTrue((typeValueArr.length > 1 ? 1 : 0) != 0, (String)("typedValue format is wrong for property '" + propertyName + "'. It should be <data-type>:<value>"));
        switch (typeValueArr[0]) {
            case "integer": {
                return Integer.parseInt(typeValueArr[1]);
            }
            case "string": {
                return typeValueArr[1];
            }
            case "float": {
                return Float.valueOf(Float.parseFloat(typeValueArr[1]));
            }
            case "double": {
                return Double.parseDouble(typeValueArr[1]);
            }
            case "boolean": {
                return Boolean.parseBoolean(typeValueArr[1]);
            }
        }
        Assert.fail((String)("'" + typeValueArr[0] + "' datatype is not supported for '" + propertyName + "' property."));
        return null;
    }

    public synchronized WebBrowser getAppWebBrowser(String appName, String browserId) {
        AppConfig appConfig = this.testConfigMgr.getAppConfig(appName);
        WebBrowserType browserType = appConfig.getAppWebBrowser();
        String loginURL = appConfig.getAppLaunchUrl();
        WebBrowser browser = this.appBrowserMap.get(appName + ":" + browserId);
        try {
            SeleniumDriverConfig webDriverCfg = this.testConfigMgr.getSeleniumDriverConfig(browserType);
            switch (browserType) {
                case firefox: {
                    if (browser == null) {
                        System.setProperty(webDriverCfg.getDriverSystemPropertyName(), webDriverCfg.getDriverBinaryFilePath());
                        FirefoxProfile firefoxProfile = new FirefoxProfile(new File(webDriverCfg.getProfilePath()));
                        if (appConfig.isEnableWebBrowserExtension()) {
                            for (File file : webDriverCfg.getBrowserExtensionFiles()) {
                                firefoxProfile.addExtension(file);
                            }
                        }
                        if (webDriverCfg.isDeleteExtensionsCacheIfItExists()) {
                            firefoxProfile.deleteExtensionsCacheIfItExists(new File(webDriverCfg.getProfilePath()));
                        }
                        firefoxProfile.setAlwaysLoadNoFocusLib(webDriverCfg.isAlwaysLoadNoFocusLib());
                        firefoxProfile.setAcceptUntrustedCertificates(webDriverCfg.isAcceptUntrustedCertificates());
                        firefoxProfile.setAssumeUntrustedCertificateIssuer(webDriverCfg.isAssumeUntrustedCertificateIssuer());
                        FirefoxOptions options = new FirefoxOptions().setProfile(firefoxProfile).setBinary(new FirefoxBinary());
                        options.setHeadless(webDriverCfg.isHeadless());
                        options.setPageLoadStrategy(webDriverCfg.getPageLoadStrategy());
                        options.setUnhandledPromptBehaviour(webDriverCfg.getUnexpectedAlertBehaviour());
                        options.setLogLevel(FirefoxDriverLogLevel.fromLevel((Level)webDriverCfg.getLogLevel()));
                        options.addArguments(webDriverCfg.getArguments());
                        for (Map.Entry<String, Object> entry : webDriverCfg.getDriverCapabilities().entrySet()) {
                            options.setCapability(entry.getKey(), entry.getValue());
                        }
                        for (Map.Entry<String, Object> entry : webDriverCfg.getBrowserPreferences().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                options.addPreference(entry.getKey(), (Object)((String)entry.getValue()));
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                options.addPreference(entry.getKey(), (Object)((Boolean)entry.getValue()));
                                continue;
                            }
                            if (!(entry.getValue() instanceof Integer)) continue;
                            options.addPreference(entry.getKey(), (Object)((Integer)entry.getValue()));
                        }
                        options.setAcceptInsecureCerts(webDriverCfg.isAcceptInsecureCertificates());
                        Proxy proxy = this.getProxyInfo(appConfig);
                        if (proxy != null) {
                            options.setCapability("proxy", (Object)proxy);
                        }
                        FirefoxDriver wdriver = new FirefoxDriver(options);
                        wdriver.setLogLevel(webDriverCfg.getLogLevel());
                        browser = new WebBrowser(browserId, appName, appConfig, this.testConfigMgr, this, (WebDriver)wdriver, browserType);
                        browser.getSeleniumWebDriver().manage().timeouts().setScriptTimeout(Duration.ofSeconds(webDriverCfg.getScriptTimeoutInSecs().intValue()));
                        browser.getSeleniumWebDriver().manage().timeouts().pageLoadTimeout(Duration.ofSeconds(webDriverCfg.getPageLoadTimeoutInSecs().intValue()));
                        browser.getSeleniumWebDriver().manage().window().setSize(new Dimension(new Double(appConfig.getBrowserWindowSize().getWidth()).intValue(), new Double(appConfig.getBrowserWindowSize().getHeight()).intValue()));
                        browser.getSeleniumWebDriver().manage().window().setPosition(new Point(0, 0));
                        browser.getSeleniumWebDriver().navigate().to(loginURL);
                        this.appBrowserMap.put(appName + ":" + browserId, browser);
                        break;
                    }
                    browser.setNewInstance(false);
                    break;
                }
                case chrome: {
                    if (browser == null) {
                        System.setProperty(webDriverCfg.getDriverSystemPropertyName(), webDriverCfg.getDriverBinaryFilePath());
                        ChromeOptions options = new ChromeOptions();
                        options.setHeadless(webDriverCfg.isHeadless());
                        options.setPageLoadStrategy(webDriverCfg.getPageLoadStrategy());
                        options.setUnhandledPromptBehaviour(webDriverCfg.getUnexpectedAlertBehaviour());
                        options.addArguments(webDriverCfg.getArguments());
                        if (appConfig.isEnableWebBrowserExtension()) {
                            options.addExtensions(webDriverCfg.getBrowserExtensionFiles());
                        }
                        for (Map.Entry<String, Object> entry : webDriverCfg.getDriverCapabilities().entrySet()) {
                            options.setCapability(entry.getKey(), entry.getValue());
                        }
                        for (Map.Entry<String, Object> entry : webDriverCfg.getExperimentalOptions().entrySet()) {
                            options.setExperimentalOption(entry.getKey(), entry.getValue());
                        }
                        options.setAcceptInsecureCerts(webDriverCfg.isAcceptInsecureCertificates());
                        Proxy proxy = this.getProxyInfo(appConfig);
                        if (proxy != null) {
                            options.setCapability("proxy", (Object)proxy);
                        }
                        ChromeDriver chromeDriver = new ChromeDriver(options);
                        chromeDriver.setLogLevel(webDriverCfg.getLogLevel());
                        browser = new WebBrowser(browserId, appName, appConfig, this.testConfigMgr, this, (WebDriver)chromeDriver, browserType);
                        browser.getSeleniumWebDriver().manage().timeouts().setScriptTimeout(Duration.ofSeconds(webDriverCfg.getScriptTimeoutInSecs().intValue()));
                        browser.getSeleniumWebDriver().manage().timeouts().pageLoadTimeout(Duration.ofSeconds(webDriverCfg.getPageLoadTimeoutInSecs().intValue()));
                        browser.getSeleniumWebDriver().manage().window().setSize(new Dimension(new Double(appConfig.getBrowserWindowSize().getWidth()).intValue(), new Double(appConfig.getBrowserWindowSize().getHeight()).intValue()));
                        browser.getSeleniumWebDriver().manage().window().setPosition(new Point(0, 0));
                        browser.getSeleniumWebDriver().navigate().to(loginURL);
                        this.appBrowserMap.put(appName + ":" + browserId, browser);
                        break;
                    }
                    browser.setNewInstance(false);
                    break;
                }
                case safari: {
                    if (browser == null) {
                        System.setProperty("webdriver.safari.driver", webDriverCfg.getDriverBinaryFilePath());
                        SafariDriverService service = SafariDriverService.createDefaultService();
                        SafariOptions options = new SafariOptions();
                        options.setPageLoadStrategy(webDriverCfg.getPageLoadStrategy());
                        options.setUnhandledPromptBehaviour(webDriverCfg.getUnexpectedAlertBehaviour());
                        options.setAcceptInsecureCerts(webDriverCfg.isAcceptInsecureCertificates());
                        for (Map.Entry<String, Object> entry : webDriverCfg.getDriverCapabilities().entrySet()) {
                            options.setCapability(entry.getKey(), entry.getValue());
                        }
                        Proxy proxy = this.getProxyInfo(appConfig);
                        if (proxy != null) {
                            options.setCapability("proxy", (Object)proxy);
                        }
                        SafariDriver wdriver = new SafariDriver(service, options);
                        wdriver.setLogLevel(webDriverCfg.getLogLevel());
                        browser = new WebBrowser(browserId, appName, appConfig, this.testConfigMgr, this, (WebDriver)wdriver, browserType);
                        browser.getSeleniumWebDriver().manage().timeouts().setScriptTimeout(Duration.ofSeconds(webDriverCfg.getScriptTimeoutInSecs().intValue()));
                        browser.getSeleniumWebDriver().manage().timeouts().pageLoadTimeout(Duration.ofSeconds(webDriverCfg.getPageLoadTimeoutInSecs().intValue()));
                        browser.getSeleniumWebDriver().manage().window().setSize(new Dimension(new Double(appConfig.getBrowserWindowSize().getWidth()).intValue(), new Double(appConfig.getBrowserWindowSize().getHeight()).intValue()));
                        browser.getSeleniumWebDriver().manage().window().setPosition(new Point(0, 0));
                        browser.getSeleniumWebDriver().navigate().to(loginURL);
                        this.appBrowserMap.put(appName + ":" + browserId, browser);
                        break;
                    }
                    browser.setNewInstance(false);
                    break;
                }
                case edge: {
                    if (browser == null) {
                        System.setProperty(webDriverCfg.getDriverSystemPropertyName(), webDriverCfg.getDriverBinaryFilePath());
                        System.setProperty("webdriver.edge.verboseLogging", String.valueOf("OFF".equals(webDriverCfg.getLogLevel())));
                        EdgeDriverService service = EdgeDriverService.createDefaultService();
                        EdgeOptions options = new EdgeOptions();
                        options.setHeadless(webDriverCfg.isHeadless());
                        options.setPageLoadStrategy(webDriverCfg.getPageLoadStrategy());
                        options.setUnhandledPromptBehaviour(webDriverCfg.getUnexpectedAlertBehaviour());
                        options.addArguments(webDriverCfg.getArguments());
                        options.setAcceptInsecureCerts(webDriverCfg.isAcceptInsecureCertificates());
                        if (appConfig.isEnableWebBrowserExtension()) {
                            options.addExtensions(webDriverCfg.getBrowserExtensionFiles());
                        }
                        for (Map.Entry<String, Object> entry : webDriverCfg.getDriverCapabilities().entrySet()) {
                            options.setCapability(entry.getKey(), entry.getValue());
                        }
                        for (Map.Entry<String, Object> entry : webDriverCfg.getExperimentalOptions().entrySet()) {
                            options.setExperimentalOption(entry.getKey(), entry.getValue());
                        }
                        Proxy proxy = this.getProxyInfo(appConfig);
                        if (proxy != null) {
                            options.setCapability("proxy", (Object)proxy);
                        }
                        EdgeDriver wdriver = new EdgeDriver(service, options);
                        wdriver.setLogLevel(webDriverCfg.getLogLevel());
                        browser = new WebBrowser(browserId, appName, appConfig, this.testConfigMgr, this, (WebDriver)wdriver, browserType);
                        browser.getSeleniumWebDriver().manage().timeouts().setScriptTimeout(Duration.ofSeconds(webDriverCfg.getScriptTimeoutInSecs().intValue()));
                        browser.getSeleniumWebDriver().manage().timeouts().pageLoadTimeout(Duration.ofSeconds(webDriverCfg.getPageLoadTimeoutInSecs().intValue()));
                        browser.getSeleniumWebDriver().manage().window().setSize(new Dimension(new Double(appConfig.getBrowserWindowSize().getWidth()).intValue(), new Double(appConfig.getBrowserWindowSize().getHeight()).intValue()));
                        browser.getSeleniumWebDriver().manage().window().setPosition(new Point(0, 0));
                        browser.getSeleniumWebDriver().navigate().to(loginURL);
                        this.appBrowserMap.put(appName + ":" + browserId, browser);
                        break;
                    }
                    browser.setNewInstance(false);
                    break;
                }
                case opera: {
                    if (browser == null) {
                        System.setProperty(webDriverCfg.getDriverSystemPropertyName(), webDriverCfg.getDriverBinaryFilePath());
                        System.setProperty("webdriver.opera.verboseLogging", String.valueOf("OFF".equals(webDriverCfg.getLogLevel())));
                        OperaDriverService service = OperaDriverService.createDefaultService();
                        OperaOptions options = new OperaOptions();
                        options.setPageLoadStrategy(webDriverCfg.getPageLoadStrategy());
                        options.setUnhandledPromptBehaviour(webDriverCfg.getUnexpectedAlertBehaviour());
                        options.addArguments(webDriverCfg.getArguments());
                        if (appConfig.isEnableWebBrowserExtension()) {
                            options.addExtensions(webDriverCfg.getBrowserExtensionFiles());
                        }
                        for (Map.Entry<String, Object> entry : webDriverCfg.getDriverCapabilities().entrySet()) {
                            options.setCapability(entry.getKey(), entry.getValue());
                        }
                        for (Map.Entry<String, Object> entry : webDriverCfg.getExperimentalOptions().entrySet()) {
                            options.setExperimentalOption(entry.getKey(), entry.getValue());
                        }
                        options.setAcceptInsecureCerts(webDriverCfg.isAcceptInsecureCertificates());
                        Proxy proxy = this.getProxyInfo(appConfig);
                        if (proxy != null) {
                            options.setCapability("proxy", (Object)proxy);
                        }
                        OperaDriver wdriver = new OperaDriver(service, options);
                        wdriver.setLogLevel(webDriverCfg.getLogLevel());
                        browser = new WebBrowser(browserId, appName, appConfig, this.testConfigMgr, this, (WebDriver)wdriver, browserType);
                        browser.getSeleniumWebDriver().manage().timeouts().setScriptTimeout(Duration.ofSeconds(webDriverCfg.getScriptTimeoutInSecs().intValue()));
                        browser.getSeleniumWebDriver().manage().timeouts().pageLoadTimeout(Duration.ofSeconds(webDriverCfg.getPageLoadTimeoutInSecs().intValue()));
                        browser.getSeleniumWebDriver().manage().window().setSize(new Dimension(new Double(appConfig.getBrowserWindowSize().getWidth()).intValue(), new Double(appConfig.getBrowserWindowSize().getHeight()).intValue()));
                        browser.getSeleniumWebDriver().manage().window().setPosition(new Point(0, 0));
                        browser.getSeleniumWebDriver().navigate().to(loginURL);
                        this.appBrowserMap.put(appName + ":" + browserId, browser);
                        break;
                    }
                    browser.setNewInstance(false);
                    break;
                }
                case internetExplorer: {
                    if (browser == null) {
                        System.setProperty(webDriverCfg.getDriverSystemPropertyName(), webDriverCfg.getDriverBinaryFilePath());
                        System.setProperty("webdriver.ie.driver.loglevel", "OFF".equals(webDriverCfg.getLogLevel()) ? "FATAL" : ("INFO".equals(webDriverCfg.getLogLevel()) ? "INFO" : "DEBUG"));
                        InternetExplorerDriverService service = InternetExplorerDriverService.createDefaultService();
                        InternetExplorerOptions options = new InternetExplorerOptions();
                        options.setPageLoadStrategy(webDriverCfg.getPageLoadStrategy());
                        options.ignoreZoomSettings();
                        options.setUnhandledPromptBehaviour(webDriverCfg.getUnexpectedAlertBehaviour());
                        options.setCapability("initialBrowserUrl", loginURL);
                        for (Map.Entry<String, Object> entry : webDriverCfg.getDriverCapabilities().entrySet()) {
                            options.setCapability(entry.getKey(), entry.getValue());
                        }
                        Proxy proxy = this.getProxyInfo(appConfig);
                        if (proxy != null) {
                            options.setCapability("proxy", (Object)proxy);
                        }
                        options.setAcceptInsecureCerts(webDriverCfg.isAcceptInsecureCertificates());
                        InternetExplorerDriver wdriver = new InternetExplorerDriver(service, options);
                        wdriver.setLogLevel(webDriverCfg.getLogLevel());
                        browser = new WebBrowser(browserId, appName, appConfig, this.testConfigMgr, this, (WebDriver)wdriver, browserType);
                        browser.getSeleniumWebDriver().manage().timeouts().setScriptTimeout(Duration.ofSeconds(webDriverCfg.getScriptTimeoutInSecs().intValue()));
                        browser.getSeleniumWebDriver().manage().timeouts().pageLoadTimeout(Duration.ofSeconds(webDriverCfg.getPageLoadTimeoutInSecs().intValue()));
                        browser.getSeleniumWebDriver().manage().window().setSize(new Dimension(new Double(appConfig.getBrowserWindowSize().getWidth()).intValue(), new Double(appConfig.getBrowserWindowSize().getHeight()).intValue()));
                        browser.getSeleniumWebDriver().manage().window().setPosition(new Point(0, 0));
                        browser.getSeleniumWebDriver().navigate().to(loginURL);
                        this.appBrowserMap.put(appName + ":" + browserId, browser);
                        break;
                    }
                    browser.setNewInstance(false);
                    break;
                }
                case remoteWebDriverProvider: {
                    if (browser == null) {
                        RemoteWebDriver webDriver = appConfig.getRemoteWebDriverProvider().createRemoteWebDriver();
                        browser = new WebBrowser(browserId, appName, appConfig, this.testConfigMgr, this, (WebDriver)webDriver, browserType);
                        browser.getSeleniumWebDriver().manage().window().setPosition(new Point(0, 0));
                        browser.getSeleniumWebDriver().manage().window().setSize(new Dimension(new Double(appConfig.getBrowserWindowSize().getWidth()).intValue(), new Double(appConfig.getBrowserWindowSize().getHeight()).intValue()));
                        browser.getSeleniumWebDriver().navigate().to(loginURL);
                        this.appBrowserMap.put(appName + ":" + browserId, browser);
                        break;
                    }
                    browser.setNewInstance(false);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Web browser '" + browserType.name() + "' is not supported.");
                }
            }
        }
        catch (Error | Exception ex) {
            Assert.fail((String)("Failed to initialize " + browserType.name() + " web browser. Going to exit... "), (Throwable)ex);
            System.exit(1);
        }
        return browser;
    }

    public void destroyAppWebBrowser(String appName, String browserId) {
        WebBrowser browser = this.appBrowserMap.get(appName + ":" + browserId);
        if (browser != null) {
            browser.getSeleniumWebDriver().quit();
            this.appBrowserMap.remove(appName + ":" + browserId);
        }
    }

    public void destroyAllWebBrowser(String appName) {
        LinkedList<String> remBrowsers = new LinkedList<String>();
        for (String browser : this.appBrowserMap.keySet()) {
            if (!browser.startsWith(appName)) continue;
            remBrowsers.add(browser);
        }
        for (String browser : remBrowsers) {
            this.appBrowserMap.get(browser).getSeleniumWebDriver().quit();
            this.appBrowserMap.remove(browser);
        }
    }

    public void destroyAllWebBrowser() {
        LinkedList<String> remBrowsers = new LinkedList<String>();
        for (String browser : this.appBrowserMap.keySet()) {
            remBrowsers.add(browser);
        }
        for (String browser : remBrowsers) {
            this.appBrowserMap.get(browser).getSeleniumWebDriver().quit();
            this.appBrowserMap.remove(browser);
        }
    }

    private Proxy getProxyInfo(AppConfig appConfig) {
        ProxyConfiguration proxyConfig = appConfig.getProxyConfig();
        Proxy proxy = new Proxy();
        switch (proxyConfig.getProxyConfigType()) {
            case NO_PROXY: {
                proxy = null;
                break;
            }
            case AUTO_DETECT: {
                proxy.setProxyType(Proxy.ProxyType.AUTODETECT);
                proxy.setAutodetect(true);
                break;
            }
            case USE_SYSTEM_PROXY: {
                proxy.setProxyType(Proxy.ProxyType.SYSTEM);
                break;
            }
            case MANUAL_PROXY: {
                proxy.setProxyType(Proxy.ProxyType.MANUAL);
                proxy.setHttpProxy(proxyConfig.getHttpProxyHostname() + ":" + proxyConfig.getHttpProxyPort());
                proxy.setSslProxy(proxyConfig.getSslProxyHostname() + ":" + proxyConfig.getSslProxyPort());
                proxy.setFtpProxy(proxyConfig.getFtpProxyHostname() + ":" + proxyConfig.getFtpProxyPort());
                proxy.setSocksProxy(proxyConfig.getSocksHostname() + ":" + proxyConfig.getSocksPort());
                proxy.setSocksUsername(proxyConfig.getSocksUsername());
                proxy.setSocksPassword(proxyConfig.getSocksPassword());
                proxy.setNoProxy(proxyConfig.getNoProxyFor());
            }
        }
        return proxy;
    }
}

