/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.file.reader;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.commons.Locations;
import org.uitnet.testing.smartfwk.ui.core.file.reader.support.Table;

public class ExcelFileReader {
    private ExcelFileReader() {
    }

    public static Table getSheetData(String filePath, String sheetName) {
        Assert.assertNotNull((Object)filePath, (String)"Excel file path cannot be empty.");
        Assert.assertNotNull((Object)sheetName, (String)("Sheet name in Excel file '" + filePath + "' cannot be empty."));
        filePath = Locations.getProjectRootDir() + File.separator + filePath;
        return ExcelFileReader.loadExcelSheet(filePath, sheetName);
    }

    private static Sheet getSheetByName(Workbook workbook, String sheetName) {
        int numSheets = workbook.getNumberOfSheets();
        for (int i = 0; i < numSheets; ++i) {
            if (!sheetName.equals(workbook.getSheetAt(i).getSheetName())) continue;
            return workbook.getSheetAt(i);
        }
        return null;
    }

    private static Table loadExcelSheet(String filePath, String sheetName) {
        Table table = new Table(sheetName);
        boolean isXlsExt = filePath.toLowerCase(Locale.ENGLISH).endsWith(".xls");
        try (FileInputStream file = new FileInputStream(new File(filePath));
             HSSFWorkbook workbook = isXlsExt ? new HSSFWorkbook() : new XSSFWorkbook((InputStream)file);){
            Sheet sheet = ExcelFileReader.getSheetByName((Workbook)workbook, sheetName);
            Assert.assertNotNull((Object)sheet, (String)("Sheet '" + sheetName + "' does not exist in excel file '" + filePath + "'."));
            int rowCounter = 0;
            for (Row row : sheet) {
                int columnCounter = 0;
                boolean isEmptyRow = false;
                ArrayList<String> cellValues = new ArrayList<String>();
                for (Cell cell : row) {
                    String cellValue;
                    switch (cell.getCellType()) {
                        case STRING: 
                        case BLANK: {
                            cellValue = "" + cell.getStringCellValue();
                            break;
                        }
                        case NUMERIC: {
                            cellValue = "" + cell.getNumericCellValue();
                            break;
                        }
                        case BOOLEAN: {
                            cellValue = "" + cell.getBooleanCellValue();
                            break;
                        }
                        case FORMULA: {
                            try {
                                cellValue = "" + cell.getStringCellValue();
                            }
                            catch (Exception e) {
                                try {
                                    cellValue = "" + cell.getNumericCellValue();
                                }
                                catch (Exception e2) {
                                    cellValue = "" + cell.getCellFormula();
                                }
                            }
                            break;
                        }
                        default: {
                            cellValue = "" + cell.getStringCellValue();
                        }
                    }
                    if (rowCounter == 0 && columnCounter == 0 && (cell.getColumnIndex() != columnCounter || "".equals(cellValue.trim()))) {
                        isEmptyRow = true;
                        break;
                    }
                    if (rowCounter == 0) {
                        ExcelFileReader.addValueInList(cellValues, cell.getColumnIndex(), cellValue.trim());
                    } else {
                        ExcelFileReader.addValueInList(cellValues, cell.getColumnIndex(), cellValue);
                    }
                    ++columnCounter;
                }
                if (isEmptyRow) continue;
                if (rowCounter == 0) {
                    List<String> dupCols = ExcelFileReader.findDuplicates(cellValues);
                    Assert.assertEquals((int)dupCols.size(), (int)0, (String)("Duplicate columns " + dupCols + " found in sheet '" + sheetName + "' of Excel file '" + filePath + "'. Please remove invalid one."));
                    int emptyColIndex = cellValues.indexOf("");
                    Assert.assertFalse((emptyColIndex >= 0 ? 1 : 0) != 0, (String)("Empty column name found at column number " + (emptyColIndex + 1) + " in sheet '" + sheetName + "' of Excel file '" + filePath + "'. Please remove empty column name or give a valid name."));
                    table.addColumnNames(cellValues);
                } else {
                    table.addRow(cellValues);
                }
                ++rowCounter;
            }
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to load data from excel file '" + filePath + "'."), (Throwable)ex);
        }
        return table;
    }

    private static List<String> findDuplicates(List<String> list) {
        return list.stream().distinct().filter(entry -> Collections.frequency(list, entry) > 1).collect(Collectors.toList());
    }

    private static void addValueInList(List<String> list, int cellIndex, String value) {
        if (list.size() == cellIndex) {
            list.add(value);
        } else {
            for (int i = list.size(); i < cellIndex; ++i) {
                list.add("");
            }
            list.add(value);
        }
    }
}

