/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.objects;

import java.lang.reflect.Constructor;
import org.openqa.selenium.By;
import org.sikuli.script.Region;
import org.uitnet.testing.smartfwk.ui.core.commons.LocatorType;
import org.uitnet.testing.smartfwk.ui.core.commons.UIObjectType;
import org.uitnet.testing.smartfwk.ui.core.config.webbrowser.WebBrowser;
import org.uitnet.testing.smartfwk.ui.core.objects.DOMObjectValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.UIObject;

public class DOMObject
extends UIObject {
    protected String xpath;

    public DOMObject(String displayName, String xpath) {
        super(LocatorType.DOM, UIObjectType.locator, displayName);
        this.xpath = xpath;
    }

    public DOMObject(UIObjectType elemType, String displayName, String xpath) {
        super(LocatorType.DOM, elemType, displayName);
        this.xpath = xpath;
    }

    public String getLocatorAsXPath() {
        return this.xpath;
    }

    public By getLocatorAsBy() {
        return By.xpath((String)this.xpath);
    }

    @Override
    public DOMObject updateLocatorParameterWithValue(String paramName, String value) {
        this.xpath = this.xpath.replaceAll(":" + paramName, value);
        return this;
    }

    @Override
    public DOMObjectValidator getValidator(WebBrowser browser, Region region) {
        return new DOMObjectValidator(browser, this, region);
    }

    @Override
    public DOMObject clone() {
        try {
            Class[] paramTypes = new Class[]{String.class, String.class};
            Constructor<?> ctor = this.getClass().getConstructor(paramTypes);
            Object[] paramValues = new Object[]{this.displayName, this.xpath};
            return (DOMObject)ctor.newInstance(paramValues);
        }
        catch (Exception ex) {
            new Throwable(ex);
            return null;
        }
    }
}

