/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.standard.domobj;

import java.util.List;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.config.webbrowser.WebBrowser;
import org.uitnet.testing.smartfwk.ui.core.objects.DOMObject;
import org.uitnet.testing.smartfwk.ui.core.objects.DOMObjectValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.NewTextLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.scrollbar.Scrollbar;
import org.uitnet.testing.smartfwk.ui.core.objects.textbox.TextBoxValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.validator.mechanisms.TextMatchMechanism;
import org.uitnet.testing.smartfwk.ui.standard.domobj.TextBoxSD;

public class TextBoxValidatorSD
extends TextBoxValidator {
    protected DOMObjectValidator domObjValidator;

    public TextBoxValidatorSD(WebBrowser browser, TextBoxSD uiObject, Region region) {
        super(browser, uiObject, region);
        this.domObjValidator = new DOMObjectValidator(browser, new DOMObject(uiObject.getDisplayName(), uiObject.getLocatorXPath()), region);
    }

    public DOMObjectValidator getDOMObjectValidator() {
        return this.domObjValidator;
    }

    @Override
    public boolean isDisabled(int numRetries) {
        return this.domObjValidator.isDisabled(numRetries);
    }

    @Override
    public void validateDisabled(int numRetries) {
        Assert.assertTrue((boolean)this.domObjValidator.isDisabled(numRetries), (String)("'" + this.uiObject.getDisplayName() + "' element is not disabled."));
    }

    @Override
    public void validateEnabled(int numRetries) {
        Assert.assertFalse((boolean)this.domObjValidator.isDisabled(numRetries), (String)("'" + this.uiObject.getDisplayName() + "' element is not enabled."));
    }

    @Override
    public boolean isReadonly(int numRetries) {
        return this.domObjValidator.isReadonly(numRetries);
    }

    @Override
    public void validateReadonly(int numRetries) {
        Assert.assertTrue((boolean)this.domObjValidator.isReadonly(numRetries), (String)("'" + this.uiObject.getDisplayName() + "' element is not readonly."));
    }

    @Override
    public void validateNotReadonly(int numRetries) {
        Assert.assertFalse((boolean)this.domObjValidator.isReadonly(numRetries), (String)("'" + this.uiObject.getDisplayName() + "' element is readonly."));
    }

    @Override
    public void typeText(String textToType, NewTextLocation location, int numRetries) {
        this.domObjValidator.typeText(textToType, location, numRetries);
    }

    @Override
    public void validateValue(String expectedValue, TextMatchMechanism validationMechanism, int numRetries) {
        try {
            for (int i = 0; i <= numRetries; ++i) {
                try {
                    WebElement webElem = this.domObjValidator.findElement(0);
                    String actualValue = webElem.getAttribute("value");
                    this.validateTextValue(actualValue, expectedValue, validationMechanism);
                    return;
                }
                catch (Throwable th) {
                    if (i == numRetries) {
                        throw th;
                    }
                    this.browser.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to validate expected value '" + expectedValue + "' for element '" + this.uiObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public boolean isPresent(int numRetries) {
        return this.domObjValidator.isPresent(numRetries);
    }

    @Override
    public boolean isVisible(int numRetries) {
        return this.domObjValidator.isVisible(numRetries);
    }

    @Override
    public void click(int numRetries) {
        this.domObjValidator.click(numRetries);
    }

    @Override
    public void doubleClick(int numRetries) {
        this.domObjValidator.doubleClick(numRetries);
    }

    @Override
    public void rightClick(int numRetries) {
        this.domObjValidator.rightClick(numRetries);
    }

    @Override
    public void clickAndHold(int numRetries) {
        this.domObjValidator.clickAndHold(numRetries);
    }

    @Override
    public void release(int numRetries) {
        this.domObjValidator.release(numRetries);
    }

    @Override
    public void performKeyDown(Keys keys, int numRetries) {
        this.domObjValidator.performKeyDown(keys, numRetries);
    }

    @Override
    public void performKeyUp(Keys keys, int numRetries) {
        this.domObjValidator.performKeyUp(keys, numRetries);
    }

    @Override
    public void performKeyPressed(Keys keys, int numRetries) {
        this.domObjValidator.performKeyPressed(keys, numRetries);
    }

    @Override
    public TextBoxValidatorSD scrollElementOnViewport(Scrollbar scrollbar) {
        this.domObjValidator.scrollElementOnViewport(scrollbar);
        return this;
    }

    @Override
    public String getValue(int numRetries) {
        WebElement webElem = this.domObjValidator.findElement(numRetries);
        return webElem.getAttribute("value");
    }

    public WebElement findElement(int numRetries) {
        return this.domObjValidator.findElement(numRetries);
    }

    public WebElement findElementNoException(int numRetries) {
        return this.domObjValidator.findElementNoException(numRetries);
    }

    @Override
    public List<WebElement> findElements(int numRetries) {
        return this.domObjValidator.findElements(numRetries);
    }
}

