/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.utils;

import io.appium.java_client.AppiumDriver;
import io.appium.java_client.PerformsTouchActions;
import io.appium.java_client.TouchAction;
import io.appium.java_client.touch.WaitOptions;
import io.appium.java_client.touch.offset.PointOption;
import java.time.Duration;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.config.ApplicationType;
import org.uitnet.testing.smartfwk.ui.core.config.PlatformType;

public class PageScrollUtil {
    public static void scrollToTopLeft(SmartAppDriver appDriver) {
        JavascriptExecutor jse = (JavascriptExecutor)appDriver.getWebDriver();
        jse.executeScript("window.scrollTo(0, 0);", new Object[0]);
    }

    public static void scrollToTopRight(SmartAppDriver appDriver) {
        JavascriptExecutor jse = (JavascriptExecutor)appDriver.getWebDriver();
        jse.executeScript("window.scrollTo(window.innerWidth, 0);", new Object[0]);
    }

    public static void scrollToBottomLeft(SmartAppDriver appDriver) {
        JavascriptExecutor jse = (JavascriptExecutor)appDriver.getWebDriver();
        jse.executeScript("window.scrollTo(0, window.innerHeight);", new Object[0]);
    }

    public static void scrollToBottomRight(SmartAppDriver appDriver) {
        JavascriptExecutor jse = (JavascriptExecutor)appDriver.getWebDriver();
        jse.executeScript("window.scrollTo(window.innerWidth, window.innerHeight);", new Object[0]);
    }

    public static boolean isElementInViewport(SmartAppDriver appDriver, WebElement element) {
        int elemY1;
        Point winPos = appDriver.getWebDriver().manage().window().getPosition();
        Dimension winDim = appDriver.getWebDriver().manage().window().getSize();
        Point elemPos = element.getLocation();
        int winX1 = winPos.getX();
        int winY1 = winPos.getY();
        int winX2 = winX1 + winDim.getWidth();
        int winY2 = winY1 + winDim.getHeight();
        int elemX1 = elemPos.getX() >= 0 ? elemPos.getX() + 20 : elemPos.getX();
        int n = elemY1 = elemPos.getY() >= 0 ? elemPos.getY() + 20 : elemPos.getY();
        return elemX1 >= winX1 && elemX1 <= winX2 || elemY1 >= winY1 && elemY1 <= winY2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void scrollElemToViewport(SmartAppDriver appDriver, WebElement element) {
        if (element == null) {
            return;
        }
        try {
            if (PageScrollUtil.isElementInViewport(appDriver, element)) {
                return;
            }
            JavascriptExecutor jse = (JavascriptExecutor)appDriver.getWebDriver();
            if (appDriver.getAppType() == ApplicationType.web_app) {
                Rectangle rect = element.getRect();
                int elemX1 = rect.getX() >= 0 ? rect.getX() + 20 : rect.getX();
                int elemY1 = rect.getY() >= 0 ? rect.getY() + 20 : rect.getY();
                jse.executeScript("window.scrollTo(" + elemX1 + ", " + elemY1 + ");", new Object[0]);
                return;
            }
            if (appDriver.getTestPlatformType() != PlatformType.android_mobile && appDriver.getTestPlatformType() != PlatformType.ios_mobile) return;
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
    }

    public static void swipe(SmartAppDriver appDriver, int xStart, int yStart, int xStop, int yStop) {
        try {
            if (appDriver.getTestPlatformType() == PlatformType.android_mobile || appDriver.getTestPlatformType() == PlatformType.ios_mobile) {
                new TouchAction((PerformsTouchActions)((AppiumDriver)appDriver.getWebDriver())).press(PointOption.point((int)xStart, (int)yStart)).waitAction(WaitOptions.waitOptions((Duration)Duration.ofMillis(1000L))).moveTo(PointOption.point((int)xStop, (int)yStop)).release().perform();
            } else {
                Assert.fail((String)("This method is not applicable for platform '" + (Object)((Object)appDriver.getTestPlatformType()) + "'."));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void swipePageUp(SmartAppDriver appDriver) {
        try {
            Point winPos = appDriver.getWebDriver().manage().window().getPosition();
            Dimension winDim = appDriver.getWebDriver().manage().window().getSize();
            if (appDriver.getTestPlatformType() == PlatformType.android_mobile || appDriver.getTestPlatformType() == PlatformType.ios_mobile) {
                new TouchAction((PerformsTouchActions)((AppiumDriver)appDriver.getWebDriver())).press(PointOption.point((int)winPos.getX(), (int)(winDim.getHeight() - 10))).waitAction(WaitOptions.waitOptions((Duration)Duration.ofMillis(1000L))).moveTo(PointOption.point((int)winPos.getX(), (int)0)).release().perform();
            } else {
                Assert.fail((String)("This method is not applicable for platform '" + (Object)((Object)appDriver.getTestPlatformType()) + "'."));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void swipePageDown(SmartAppDriver appDriver) {
        try {
            Point winPos = appDriver.getWebDriver().manage().window().getPosition();
            Dimension winDim = appDriver.getWebDriver().manage().window().getSize();
            if (appDriver.getTestPlatformType() == PlatformType.android_mobile || appDriver.getTestPlatformType() == PlatformType.ios_mobile) {
                new TouchAction((PerformsTouchActions)((AppiumDriver)appDriver.getWebDriver())).press(PointOption.point((int)winPos.getX(), (int)0)).waitAction(WaitOptions.waitOptions((Duration)Duration.ofMillis(1000L))).moveTo(PointOption.point((int)winPos.getX(), (int)winDim.getHeight())).release().perform();
            } else {
                Assert.fail((String)("This method is not applicable for platform '" + (Object)((Object)appDriver.getTestPlatformType()) + "'."));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void swipePageRight(SmartAppDriver appDriver) {
        try {
            Point winPos = appDriver.getWebDriver().manage().window().getPosition();
            Dimension winDim = appDriver.getWebDriver().manage().window().getSize();
            if (appDriver.getTestPlatformType() == PlatformType.android_mobile || appDriver.getTestPlatformType() == PlatformType.ios_mobile) {
                new TouchAction((PerformsTouchActions)((AppiumDriver)appDriver.getWebDriver())).press(PointOption.point((int)0, (int)winPos.getY())).waitAction(WaitOptions.waitOptions((Duration)Duration.ofMillis(1000L))).moveTo(PointOption.point((int)winDim.getWidth(), (int)winPos.getY())).release().perform();
            } else {
                Assert.fail((String)("This method is not applicable for platform '" + (Object)((Object)appDriver.getTestPlatformType()) + "'."));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void swipePageLeft(SmartAppDriver appDriver) {
        try {
            Point winPos = appDriver.getWebDriver().manage().window().getPosition();
            Dimension winDim = appDriver.getWebDriver().manage().window().getSize();
            if (appDriver.getTestPlatformType() == PlatformType.android_mobile || appDriver.getTestPlatformType() == PlatformType.ios_mobile) {
                new TouchAction((PerformsTouchActions)((AppiumDriver)appDriver.getWebDriver())).press(PointOption.point((int)winDim.getWidth(), (int)winPos.getY())).waitAction(WaitOptions.waitOptions((Duration)Duration.ofMillis(1000L))).moveTo(PointOption.point((int)0, (int)winPos.getY())).release().perform();
            } else {
                Assert.fail((String)("This method is not applicable for platform '" + (Object)((Object)appDriver.getTestPlatformType()) + "'."));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void scrollToViewportAndClick(SmartAppDriver appDriver, WebElement element) {
        Actions action = new Actions(appDriver.getWebDriver());
        action.moveToElement(element).click().perform();
    }

    public static void scrollToViewportAndDoubleClick(SmartAppDriver appDriver, WebElement element) {
        Actions action = new Actions(appDriver.getWebDriver());
        action.moveToElement(element).doubleClick().perform();
    }

    public static void scrollToViewportAndClickAndHold(SmartAppDriver appDriver, WebElement element) {
        Actions action = new Actions(appDriver.getWebDriver());
        action.moveToElement(element).clickAndHold().perform();
    }

    public static void scrollToViewportAndRelease(SmartAppDriver appDriver, WebElement element) {
        Actions action = new Actions(appDriver.getWebDriver());
        action.moveToElement(element).release().perform();
    }

    public static void scrollToViewportAndDragAndDrop(SmartAppDriver appDriver, WebElement source, WebElement target) {
        Actions action = new Actions(appDriver.getWebDriver());
        action.moveToElement(source).dragAndDrop(source, target).perform();
    }
}

