/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.standard.domobj;

import java.util.HashMap;
import java.util.Map;
import org.sikuli.script.Region;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.commons.LocateBy;
import org.uitnet.testing.smartfwk.ui.core.commons.Locator;
import org.uitnet.testing.smartfwk.ui.core.commons.LocatorType;
import org.uitnet.testing.smartfwk.ui.core.config.AppConfig;
import org.uitnet.testing.smartfwk.ui.core.config.ApplicationType;
import org.uitnet.testing.smartfwk.ui.core.config.PlatformType;
import org.uitnet.testing.smartfwk.ui.core.config.WebBrowserType;
import org.uitnet.testing.smartfwk.ui.core.objects.UIObject;
import org.uitnet.testing.smartfwk.ui.core.objects.link.Hyperlink;
import org.uitnet.testing.smartfwk.ui.core.utils.LocatorUtil;
import org.uitnet.testing.smartfwk.ui.standard.domobj.HyperlinkValidatorSD;

public class HyperlinkSD
extends Hyperlink {
    protected Map<String, Locator> platFormLocators = new HashMap<String, Locator>();

    public HyperlinkSD(String displayName) {
        super(LocatorType.DOM, displayName);
    }

    public HyperlinkSD(String displayName, Map<String, Locator> platFormLocators) {
        super(LocatorType.DOM, displayName);
        this.platFormLocators = platFormLocators;
    }

    public HyperlinkSD(String displayName, String xpath) {
        super(LocatorType.DOM, displayName);
        this.platFormLocators.put("default-xpath", new Locator(LocateBy.Xpath, xpath));
    }

    public HyperlinkSD addPlatformLocatorForNativeApp(PlatformType platform, LocateBy locateBy, String locatorValue) {
        LocatorUtil.setPlatformLocatorForNativeApp(this.platFormLocators, platform, locateBy, locatorValue);
        return this;
    }

    public HyperlinkSD addPlatformLocatorForWebApp(PlatformType platform, WebBrowserType browserType, LocateBy locateBy, String locatorValue) {
        LocatorUtil.setPlatformLocatorForWebApp(this.platFormLocators, platform, browserType, locateBy, locatorValue);
        return this;
    }

    @Override
    public HyperlinkValidatorSD getValidator(SmartAppDriver appDriver, Region region) {
        return new HyperlinkValidatorSD(appDriver, this, region);
    }

    public Locator getLocator(PlatformType platform, ApplicationType appType, WebBrowserType browserType) {
        return LocatorUtil.findLocator(this.platFormLocators, platform, appType, browserType);
    }

    public Map<String, Locator> getPlatformLocators() {
        return this.platFormLocators;
    }

    @Override
    public UIObject clone() {
        return null;
    }

    @Override
    public HyperlinkSD updateLocatorParameterWithValue(AppConfig appConfig, String paramName, String paramValue) {
        String newDisplayName = this.displayName.replaceAll(":" + paramName, paramValue);
        HashMap<String, Locator> newPlatFormLocators = new HashMap<String, Locator>();
        for (Map.Entry<String, Locator> locator : this.platFormLocators.entrySet()) {
            newPlatFormLocators.put(locator.getKey(), new Locator(locator.getValue().getLocateBy(), locator.getValue().getValue().replaceAll(":" + paramName, paramValue)));
        }
        return new HyperlinkSD(newDisplayName, newPlatFormLocators);
    }
}

