/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.config.database.orm;

import java.io.File;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.query.NativeQuery;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.commons.Locations;

public class OrmDatabaseQueryHandler {
    private SessionFactory hibernateSessionFactory;

    public OrmDatabaseQueryHandler(String hibernateCfgFile) {
        Configuration hibernateCfg = new Configuration().configure(new File(Locations.getProjectRootDir() + File.separator + hibernateCfgFile));
        this.hibernateSessionFactory = hibernateCfg.buildSessionFactory();
    }

    public boolean removeTableRecord(String tableName, String whereCondition) {
        boolean removed = false;
        String query = "delete from " + tableName + " where " + whereCondition;
        removed = this.executeUpdateQuery(query);
        if (!removed) {
            Assert.fail((String)("Failed to remove record using query: " + query));
        }
        return removed;
    }

    public boolean removeTableRecordNoAssert(String tableName, String whereCondition) {
        boolean removed = false;
        String query = "delete from " + tableName + " where " + whereCondition;
        removed = this.executeUpdateQuery(query);
        return removed;
    }

    public boolean checkRecordExistInTable(String tableName, String whereCondition) {
        boolean exists = false;
        String query = "select * from " + tableName + " where " + whereCondition;
        List records = this.executeSearchQuery(query);
        if (records == null || records.size() > 0) {
            exists = true;
        }
        return exists;
    }

    public void validateRecordExistInTable(String recordName, String tableName, String whereCondition) {
        boolean exists = false;
        String query = "select * from " + tableName + " where " + whereCondition;
        List records = this.executeSearchQuery(query);
        if (records == null || records.size() > 0) {
            exists = true;
        }
        Assert.assertTrue((boolean)exists, (String)("'" + recordName + "' record does not exist in the database. Query: " + query));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeUpdateQuery(String query) {
        int updatedRecords = 0;
        Transaction txn = null;
        try (Session hibSession = null;){
            hibSession = this.hibernateSessionFactory.openSession();
            txn = hibSession.beginTransaction();
            NativeQuery sqlQuery = hibSession.createSQLQuery(query);
            updatedRecords = sqlQuery.executeUpdate();
            txn.commit();
            txn = null;
        }
        return updatedRecords > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List executeSearchQuery(String query) {
        List foundRecords = null;
        try (Session hibSession = null;){
            Thread.sleep(5000L);
            hibSession = this.hibernateSessionFactory.openSession();
            NativeQuery sqlQuery = hibSession.createSQLQuery(query);
            foundRecords = sqlQuery.list();
        }
        return foundRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> executeSearchQuery(String query, Class<T> entityClass) {
        List foundRecords = null;
        try (Session hibSession = null;){
            Thread.sleep(5000L);
            hibSession = this.hibernateSessionFactory.openSession();
            NativeQuery sqlQuery = hibSession.createSQLQuery(query);
            sqlQuery.addEntity(entityClass);
            foundRecords = sqlQuery.list();
        }
        return foundRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTableRowColumnValue(String tableName, String columnName, String whereCondition) {
        String columnValue = null;
        List foundRecords = null;
        String query = "select " + columnName + " from " + tableName + " where " + whereCondition;
        try (Session hibSession = null;){
            Thread.sleep(5000L);
            hibSession = this.hibernateSessionFactory.openSession();
            NativeQuery sqlQuery = hibSession.createSQLQuery(query);
            foundRecords = sqlQuery.list();
            if (foundRecords != null && foundRecords.size() > 0) {
                columnValue = String.valueOf(foundRecords.get(0));
            }
        }
        return columnValue;
    }

    public static void main(String[] args) {
        OrmDatabaseQueryHandler handler = new OrmDatabaseQueryHandler("profiles/database/hibernate.cfg.db.dev.xml");
        System.out.println(handler.getTableRowColumnValue("TEST_TABLE", "COLUMN_1", "<SQL-QUERY>"));
    }
}

