/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.utils;

import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.objects.validator.mechanisms.TextMatchMechanism;

public class DataMatchUtil {
    public static boolean matchTextValue(String actualValue, String expectedValue, TextMatchMechanism validationMechanism) {
        boolean matched = false;
        if (actualValue == null) {
            return false;
        }
        switch (validationMechanism) {
            case startsWithExpectedValue: {
                if (!actualValue.startsWith(expectedValue)) break;
                matched = true;
                break;
            }
            case containsExpectedValue: {
                if (!actualValue.contains(expectedValue)) break;
                matched = true;
                break;
            }
            case endsWithExpectedValue: {
                if (!actualValue.contains(expectedValue)) break;
                matched = true;
                break;
            }
            case exactMatchWithExpectedValue: {
                if (!actualValue.equals(expectedValue)) break;
                matched = true;
                break;
            }
            case matchWithRegularExpression: {
                if (!actualValue.matches(expectedValue)) break;
                matched = true;
                break;
            }
            case exactMatchWithExpectedValueWithRemovedWhiteSpace: {
                if (!actualValue.replaceAll(" ", "").equals(expectedValue.replaceAll(" ", ""))) break;
                matched = true;
            }
        }
        return matched;
    }

    public static void validateTextValue(String actualValue, String expectedValue, TextMatchMechanism validationMechanism) {
        switch (validationMechanism) {
            case startsWithExpectedValue: {
                if (DataMatchUtil.matchTextValue(actualValue, expectedValue, validationMechanism)) break;
                Assert.fail((String)("Actual value '" + actualValue + "' does not starts with expected value '" + expectedValue + "'."));
                break;
            }
            case containsExpectedValue: {
                if (DataMatchUtil.matchTextValue(actualValue, expectedValue, validationMechanism)) break;
                Assert.fail((String)("Actual value '" + actualValue + "' does not contain expected value '" + expectedValue + "'."));
                break;
            }
            case endsWithExpectedValue: {
                if (DataMatchUtil.matchTextValue(actualValue, expectedValue, validationMechanism)) break;
                Assert.fail((String)("Actual value '" + actualValue + "' does not ends with expected value '" + expectedValue + "'."));
                break;
            }
            case exactMatchWithExpectedValue: {
                if (DataMatchUtil.matchTextValue(actualValue, expectedValue, validationMechanism)) break;
                Assert.fail((String)("Actual value '" + actualValue + "' does not equal to expected value '" + expectedValue + "'."));
                break;
            }
            case matchWithRegularExpression: {
                if (DataMatchUtil.matchTextValue(actualValue, expectedValue, validationMechanism)) break;
                Assert.fail((String)("Actual value '" + actualValue + "' does not equal to expected regular expression value '" + expectedValue + "'."));
                break;
            }
            case exactMatchWithExpectedValueWithRemovedWhiteSpace: {
                if (DataMatchUtil.matchTextValue(actualValue, expectedValue, validationMechanism)) break;
                Assert.fail((String)("Actual value '" + actualValue + "' does not equal to expected value '" + expectedValue + "'."));
            }
        }
    }
}

