/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.utils;

import java.util.Locale;
import org.openqa.selenium.WebElement;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.config.ApplicationType;
import org.uitnet.testing.smartfwk.ui.core.objects.DOMObject;
import org.uitnet.testing.smartfwk.ui.core.utils.LocatorUtil;

public class WebAttrMapUtil {
    private WebAttrMapUtil() {
    }

    public static boolean isElementDisabled(SmartAppDriver appDriver, DOMObject domObject) {
        boolean disabled;
        block10: {
            disabled = false;
            WebElement webElem = LocatorUtil.findWebElement(appDriver.getWebDriver(), domObject.getLocator(appDriver.getAppConfig().getTestPlatformType(), appDriver.getAppConfig().getAppType(), appDriver.getAppConfig().getAppWebBrowser()));
            if (appDriver.getAppType() == ApplicationType.native_app) {
                try {
                    if (webElem != null && !webElem.isEnabled()) {
                        disabled = true;
                    }
                }
                catch (Error | Exception ex) {
                    String checkElemEnabledAttr = appDriver.getAppConfig().getAppDriverConfig().getWebAttrMap().get("CHECK_ELEMENT_ENABLED_ATTR");
                    String attrValue = null;
                    if (checkElemEnabledAttr != null && !"".equals(checkElemEnabledAttr)) {
                        attrValue = webElem.getAttribute(checkElemEnabledAttr);
                        if (attrValue != null && !"true".equals(attrValue.toLowerCase(Locale.ENGLISH))) {
                            disabled = true;
                        }
                        break block10;
                    }
                    String checkElemDisabledAttr = appDriver.getAppConfig().getAppDriverConfig().getWebAttrMap().get("CHECK_ELEMENT_DISABLED_ATTR");
                    if (checkElemDisabledAttr != null && "".equals(checkElemDisabledAttr)) {
                        attrValue = webElem.getAttribute(checkElemDisabledAttr);
                        if (attrValue != null && "true".equals(attrValue.toLowerCase(Locale.ENGLISH))) {
                            disabled = true;
                        }
                        break block10;
                    }
                    Assert.fail((String)("Please specify the value for property 'CHECK_ELEMENT_DISABLED_ATTR' or property 'CHECK_ELEMENT_ENABLED_ATTR' in AppDriver.properties file for Application '" + appDriver.getAppName() + "'."));
                }
            } else if (webElem != null && !webElem.isEnabled()) {
                disabled = true;
            }
        }
        return disabled;
    }

    public static boolean isElementReadonly(SmartAppDriver appDriver, DOMObject domObject) {
        boolean readonly = false;
        WebElement webElem = LocatorUtil.findWebElement(appDriver.getWebDriver(), domObject.getLocator(appDriver.getAppConfig().getTestPlatformType(), appDriver.getAppConfig().getAppType(), appDriver.getAppConfig().getAppWebBrowser()));
        if (appDriver.getAppType() == ApplicationType.native_app) {
            String checkElemReadonlyAttr = appDriver.getAppConfig().getAppDriverConfig().getWebAttrMap().get("CHECK_TEXTBOX_STATE_AS_READONLY_ATTR");
            String attrValue = null;
            if (checkElemReadonlyAttr != null && !"".equals(checkElemReadonlyAttr)) {
                attrValue = webElem.getAttribute(checkElemReadonlyAttr);
                if (attrValue != null && !"true".equals(attrValue.toLowerCase(Locale.ENGLISH))) {
                    readonly = true;
                }
            } else {
                Assert.fail((String)("Please specify the value for property 'CHECK_TEXTBOX_STATE_AS_READONLY_ATTR' in AppDriver.properties file for Application '" + appDriver.getAppName() + "'."));
            }
        } else if (webElem != null && webElem.getAttribute("readonly") != null) {
            readonly = true;
        }
        return readonly;
    }

    public static boolean isElementVisible(SmartAppDriver appDriver, DOMObject domObject) {
        boolean visible = false;
        WebElement webElem = LocatorUtil.findWebElement(appDriver.getWebDriver(), domObject.getLocator(appDriver.getAppConfig().getTestPlatformType(), appDriver.getAppConfig().getAppType(), appDriver.getAppConfig().getAppWebBrowser()));
        if (appDriver.getAppType() == ApplicationType.native_app) {
            if (webElem != null) {
                visible = true;
            }
        } else if (webElem != null && !"hidden".equals(LocatorUtil.getCssValue(webElem, "visibility")) && webElem.getAttribute("hidden") == null) {
            visible = true;
        }
        return visible;
    }

    public static boolean isElementSelected(SmartAppDriver appDriver, DOMObject domObject) {
        boolean selected;
        block8: {
            selected = false;
            WebElement webElem = LocatorUtil.findWebElement(appDriver.getWebDriver(), domObject.getLocator(appDriver.getAppConfig().getTestPlatformType(), appDriver.getAppConfig().getAppType(), appDriver.getAppConfig().getAppWebBrowser()));
            if (appDriver.getAppType() == ApplicationType.native_app) {
                try {
                    if (webElem != null && webElem.isSelected()) {
                        selected = true;
                    }
                }
                catch (Error | Exception ex) {
                    String checkElemOpSelectedAttr = appDriver.getAppConfig().getAppDriverConfig().getWebAttrMap().get("CHECK_OPTION_SELECTED_ATTR");
                    String attrValue = null;
                    if (checkElemOpSelectedAttr != null && !"".equals(checkElemOpSelectedAttr)) {
                        attrValue = webElem.getAttribute(checkElemOpSelectedAttr);
                        if (attrValue != null && !"true".equals(attrValue.toLowerCase(Locale.ENGLISH))) {
                            selected = true;
                        }
                        break block8;
                    }
                    Assert.fail((String)("Please specify the value for property 'CHECK_OPTION_SELECTED_ATTR' in AppDriver.properties file for Application '" + appDriver.getAppName() + "'."));
                }
            } else if (webElem != null && webElem.isSelected()) {
                selected = true;
            }
        }
        return selected;
    }

    public static String getElementText(SmartAppDriver appDriver, DOMObject domObject, int numRetries) {
        String text = "";
        WebElement webElem = null;
        for (int i = 0; i <= numRetries; ++i) {
            block8: {
                try {
                    webElem = LocatorUtil.findWebElement(appDriver.getWebDriver(), domObject.getLocator(appDriver.getAppConfig().getTestPlatformType(), appDriver.getAppConfig().getAppType(), appDriver.getAppConfig().getAppWebBrowser()));
                    if (appDriver.getAppType() == ApplicationType.native_app) {
                        String getElemTextAttr = appDriver.getAppConfig().getAppDriverConfig().getWebAttrMap().get("GET_ELEMENT_TEXT_ATTR");
                        if (getElemTextAttr != null && !"".equals(getElemTextAttr)) {
                            text = webElem.getAttribute(getElemTextAttr);
                        } else {
                            Assert.fail((String)("Please specify the value for property 'GET_ELEMENT_TEXT_ATTR' in AppDriver.properties file for Application '" + appDriver.getAppName() + "'."));
                        }
                    } else if (webElem != null) {
                        text = webElem.getText();
                    }
                }
                catch (Throwable th) {
                    if (i != numRetries) break block8;
                    throw th;
                }
            }
            appDriver.waitForSeconds(2);
        }
        return text;
    }

    public static String getInputTextValue(SmartAppDriver appDriver, DOMObject domObject, int numRetries) {
        String text = "";
        WebElement webElem = null;
        for (int i = 0; i <= numRetries; ++i) {
            block8: {
                try {
                    webElem = LocatorUtil.findWebElement(appDriver.getWebDriver(), domObject.getLocator(appDriver.getAppConfig().getTestPlatformType(), appDriver.getAppConfig().getAppType(), appDriver.getAppConfig().getAppWebBrowser()));
                    if (appDriver.getAppType() == ApplicationType.native_app) {
                        String getElemTextAttr = appDriver.getAppConfig().getAppDriverConfig().getWebAttrMap().get("GET_INPUT_VALUE_ATTR");
                        if (getElemTextAttr != null && !"".equals(getElemTextAttr)) {
                            text = webElem.getAttribute(getElemTextAttr);
                        } else {
                            Assert.fail((String)("Please specify the value for property 'GET_INPUT_VALUE_ATTR' in AppDriver.properties file for Application '" + appDriver.getAppName() + "'."));
                        }
                    } else if (webElem != null) {
                        text = webElem.getAttribute("value");
                    }
                }
                catch (Throwable th) {
                    if (i != numRetries) break block8;
                    throw th;
                }
            }
            appDriver.waitForSeconds(2);
        }
        return text;
    }
}

