/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.standard.domobj;

import io.appium.java_client.MultiTouchAction;
import io.appium.java_client.TouchAction;
import java.util.List;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.objects.DOMObject;
import org.uitnet.testing.smartfwk.ui.core.objects.DOMObjectValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.NewTextLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.checkbox.CheckBoxValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.scrollbar.Scrollbar;
import org.uitnet.testing.smartfwk.ui.standard.domobj.CheckBoxSD;

public class CheckBoxValidatorSD
extends CheckBoxValidator {
    protected DOMObjectValidator domObjValidator;

    public CheckBoxValidatorSD(SmartAppDriver appDriver, CheckBoxSD uiObject, Region region) {
        super(appDriver, uiObject, region);
        this.domObjValidator = new DOMObjectValidator(appDriver, new DOMObject(uiObject.getType(), uiObject.getDisplayName(), uiObject.getPlatformLocators()), region);
    }

    public DOMObjectValidator getDOMObjectValidator() {
        return this.domObjValidator;
    }

    @Override
    public void typeText(String textToType, NewTextLocation location, int numRetries) {
        this.domObjValidator.typeText(textToType, location, numRetries);
    }

    @Override
    public boolean isPresent(int numRetries) {
        return this.domObjValidator.isPresent(numRetries);
    }

    @Override
    public boolean isVisible(int numRetries) {
        return this.domObjValidator.isVisible(numRetries);
    }

    @Override
    public void click(int numRetries) {
        this.domObjValidator.click(numRetries);
    }

    @Override
    public void doubleClick(int numRetries) {
        this.domObjValidator.doubleClick(numRetries);
    }

    @Override
    public void rightClick(int numRetries) {
        this.domObjValidator.rightClick(numRetries);
    }

    @Override
    public void clickAndHold(int numRetries) {
        this.domObjValidator.clickAndHold(numRetries);
    }

    @Override
    public void release(int numRetries) {
        this.domObjValidator.release(numRetries);
    }

    @Override
    public void performKeyDown(Keys keys, int numRetries) {
        this.domObjValidator.performKeyDown(keys, numRetries);
    }

    @Override
    public void performKeyUp(Keys keys, int numRetries) {
        this.domObjValidator.performKeyUp(keys, numRetries);
    }

    @Override
    public void performKeyPressed(Keys keys, int numRetries) {
        this.domObjValidator.performKeyPressed(keys, numRetries);
    }

    @Override
    public CheckBoxValidatorSD scrollElementOnViewport(Scrollbar scrollbar) {
        this.domObjValidator.scrollElementOnViewport(scrollbar);
        return this;
    }

    @Override
    public boolean isCheckBoxChecked(int numRetries) {
        return this.domObjValidator.isSelected(numRetries);
    }

    @Override
    public void validateCheckBoxChecked(int numRetries) {
        try {
            for (int i = 0; i <= numRetries; ++i) {
                try {
                    Assert.assertTrue((boolean)this.isCheckBoxChecked(0), (String)("Checkbox '" + this.uiObject.getDisplayName() + "' is not checked."));
                    return;
                }
                catch (Throwable th) {
                    if (i == numRetries) {
                        throw th;
                    }
                    this.appDriver.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to validate checkbox checked for element '" + this.uiObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void validateCheckBoxUnchecked(int numRetries) {
        try {
            for (int i = 0; i <= numRetries; ++i) {
                try {
                    Assert.assertFalse((boolean)this.isCheckBoxChecked(0), (String)("Checkbox '" + this.uiObject.getDisplayName() + "' is checked."));
                    return;
                }
                catch (Throwable th) {
                    if (i == numRetries) {
                        throw th;
                    }
                    this.appDriver.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to validate checkbox unchecked for element '" + this.uiObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void checkAndValidateChecked(int numRetries) {
        this.domObjValidator.click(numRetries);
        try {
            this.validateCheckBoxChecked(numRetries);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to check the Checkbox '" + this.uiObject.getDisplayName() + "'."));
        }
    }

    @Override
    public void uncheckAndValidateUnchecked(int numRetries) {
        this.domObjValidator.click(numRetries);
        try {
            this.validateCheckBoxUnchecked(numRetries);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to uncheck the Checkbox '" + this.uiObject.getDisplayName() + "'."));
        }
    }

    public WebElement findElement(int numRetries) {
        return this.domObjValidator.findElement(numRetries);
    }

    public WebElement findElementNoException(int numRetries) {
        return this.domObjValidator.findElementNoException(numRetries);
    }

    @Override
    public List<WebElement> findElements(int numRetries) {
        return this.domObjValidator.findElements(numRetries);
    }

    @Override
    public boolean isDisabled(int numRetries) {
        return this.domObjValidator.isDisabled(numRetries);
    }

    @Override
    public void validateDisabled(int numRetries) {
        Assert.assertTrue((boolean)this.domObjValidator.isDisabled(numRetries), (String)("'" + this.uiObject.getDisplayName() + "' element is not disabled."));
    }

    @Override
    public void validateEnabled(int numRetries) {
        Assert.assertFalse((boolean)this.domObjValidator.isDisabled(numRetries), (String)("'" + this.uiObject.getDisplayName() + "' element is not enabled."));
    }

    @Override
    public TouchAction getNewMobileTouchAction() {
        return this.domObjValidator.getNewMobileTouchAction();
    }

    @Override
    public MultiTouchAction getNewMobileMultiTouchAction() {
        return this.domObjValidator.getNewMobileMultiTouchAction();
    }

    @Override
    public Actions getNewSeleniumActions() {
        return this.domObjValidator.getNewSeleniumActions();
    }
}

