/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.standard.imgobj;

import io.appium.java_client.MultiTouchAction;
import io.appium.java_client.TouchAction;
import java.util.Iterator;
import java.util.List;
import org.openqa.selenium.Keys;
import org.openqa.selenium.interactions.Actions;
import org.sikuli.script.Button;
import org.sikuli.script.FindFailed;
import org.sikuli.script.Location;
import org.sikuli.script.Match;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.commons.ImageSection;
import org.uitnet.testing.smartfwk.ui.core.commons.ItemList;
import org.uitnet.testing.smartfwk.ui.core.commons.UIObjectType;
import org.uitnet.testing.smartfwk.ui.core.objects.ImageObject;
import org.uitnet.testing.smartfwk.ui.core.objects.NewTextLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.combobox.ComboBoxValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.scrollbar.Scrollbar;
import org.uitnet.testing.smartfwk.ui.core.objects.validator.mechanisms.TextMatchMechanism;
import org.uitnet.testing.smartfwk.ui.core.utils.ClipboardUtil;
import org.uitnet.testing.smartfwk.ui.standard.imgobj.ComboBoxSI;

public class ComboBoxValidatorSI
extends ComboBoxValidator {
    protected ComboBoxSI comboBoxObj;

    public ComboBoxValidatorSI(SmartAppDriver appDriver, ComboBoxSI uiObject, Region region) {
        super(appDriver, uiObject, region);
        this.comboBoxObj = uiObject;
    }

    @Override
    @Deprecated
    public void validateDisabled(int numRetries) {
        Assert.fail((String)"validateDisabled() API is not supported by ComboBoxSI.");
    }

    @Override
    @Deprecated
    public void validateEnabled(int numRetries) {
        Assert.fail((String)"validateEnabled() API is not supported by ComboBoxSI.");
    }

    @Override
    public boolean isPresent(int numRetries) {
        Match m = this.findElementNoException(numRetries);
        return m != null;
    }

    @Override
    public boolean isVisible(int numRetries) {
        return this.isPresent(numRetries);
    }

    @Override
    public void click(int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.click();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse click on ComboBox '" + this.comboBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    public void click(ImageSection imageSection, int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            this.getImageSection(match, imageSection).click();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse click on ComboBox '" + this.comboBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void doubleClick(int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.doubleClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse double click on ComboBox '" + this.comboBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    public void doubleClick(ImageSection imageSection, int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            this.getImageSection(match, imageSection).doubleClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse double click on ComboBox '" + this.comboBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void rightClick(int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.rightClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse right click on ComboBox '" + this.comboBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    public void rightClick(ImageSection imageSection, int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            this.getImageSection(match, imageSection).rightClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse right click on ComboBox '" + this.comboBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void clickAndHold(int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.mouseDown(Button.LEFT);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse clickAndHold on ComboBox '" + this.comboBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void release(int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.mouseDown(Button.LEFT);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse clickAndHold on ComboBox '" + this.comboBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void performKeyDown(Keys keys, int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.click();
            match.keyDown(this.seleniumToSikuliKeyConverter(keys));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform keyDown on ComboBox '" + this.comboBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void performKeyUp(Keys keys, int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.click();
            match.keyUp(this.seleniumToSikuliKeyConverter(keys));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform keyUp ('" + this.seleniumToSikuliKeyConverter(keys) + "') on ComboBox '" + this.comboBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void performKeyPressed(Keys keys, int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.click();
            match.type(this.seleniumToSikuliKeyConverter(keys));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform keyPressed ('" + this.seleniumToSikuliKeyConverter(keys) + "') on ComboBox '" + this.comboBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void typeText(String text, NewTextLocation location, int numRetries) {
        Match match = this.findElement(numRetries);
        try {
            match.click();
            switch (location) {
                case start: {
                    match.type("\ue008");
                    break;
                }
                case end: {
                    match.type("\ue007");
                    break;
                }
                case replace: {
                    match.type("a", 2);
                }
            }
            match.type(text);
        }
        catch (Throwable th) {
            Assert.fail((String)("Fail to type text '" + text + "' in ComboBox '" + this.comboBoxObj.getDisplayName() + "'."));
        }
    }

    @Override
    public ComboBoxValidatorSI scrollElementOnViewport(Scrollbar scrollbar) {
        return this;
    }

    public Match findElement(int numRetries) {
        Match match = null;
        for (int i = 0; i <= numRetries; ++i) {
            try {
                Region region = this.comboBoxObj.getLocation().getRegionOfImageObject(this.appDriver, this.comboBoxObj.getLeftSideImage(), this.comboBoxObj.getRightSideImage());
                Assert.assertNotNull((Object)region, (String)("Failed to find ComboBox '" + this.comboBoxObj.getDisplayName() + "'."));
                match = new Match(region, 1.0);
                break;
            }
            catch (Throwable th) {
                if (i == numRetries) {
                    Assert.fail((String)("Unable to find ComboBox '" + this.comboBoxObj.getDisplayName() + "'. Reason timeout(waited for " + numRetries * 2 + " seconds)."), (Throwable)th);
                    break;
                }
                this.appDriver.waitForSeconds(2);
                continue;
            }
        }
        return match;
    }

    public Match findElementNoException(int numRetries) {
        Match match = null;
        try {
            match = this.findElement(numRetries);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return match;
    }

    @Override
    public List<Match> findElements(int numRetries) {
        Assert.fail((String)"findElements() api for ComboBoxSI element is not implemented.");
        return null;
    }

    public void dragAndDrop(ImageObject target, Region targetRegion, int numRetries) {
        try {
            Match sourceElem = this.findElement(numRetries);
            Match targetElem = target.getValidator(this.appDriver, targetRegion).findElement(numRetries);
            Assert.assertNotNull((Object)sourceElem, (String)("Failed to find ComboBox '" + this.comboBoxObj.getDisplayName() + "'."));
            Assert.assertNotNull((Object)targetElem, (String)("Failed to find element '" + target.getDisplayName() + "'."));
            sourceElem.drag((Object)targetElem);
            sourceElem.dropAt((Object)targetElem);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform dragAndDrop from source '" + this.comboBoxObj.getDisplayName() + "' to target '" + target.getDisplayName() + "'."), (Throwable)th);
        }
    }

    protected Location getImageSection(Match imageMatch, ImageSection imageSection) {
        switch (imageSection) {
            case topLeft: {
                return imageMatch.getTopLeft();
            }
            case topRight: {
                return imageMatch.getTopRight();
            }
            case bottomLeft: {
                return imageMatch.getBottomLeft();
            }
            case bottomRight: {
                return imageMatch.getBottomRight();
            }
            case center: {
                return imageMatch.getCenter();
            }
        }
        return null;
    }

    @Override
    public void validateSelectedItem(String expectedValue, TextMatchMechanism validationMechanism, int numRetries) {
        if (this.comboBoxObj.isDisabled() || this.comboBoxObj.isReadOnly()) {
            Match match = this.findElement(numRetries);
            this.validateTextValue(match.text(), expectedValue, validationMechanism);
        } else {
            this.validateTextValue(this.getSelectedItem(numRetries), expectedValue, validationMechanism);
        }
    }

    @Override
    public String getSelectedItem(int numRetries) {
        Match match = this.findElement(numRetries);
        if (this.comboBoxObj.isDisabled() || this.comboBoxObj.isReadOnly()) {
            return match.text();
        }
        match.click();
        match.type("ac", 2);
        String contents = ClipboardUtil.getContents();
        ClipboardUtil.clearContents();
        match.click();
        return contents;
    }

    @Override
    public List<String> getSelectedItems(int numRetries) {
        Assert.fail((String)"getSelectedItems() API is not implemented.");
        return null;
    }

    @Override
    public void selectFirstItem(int numRetries) {
        Assert.fail((String)"selectFirstItem() API is not implemented.");
    }

    @Override
    public void selectLastItem(int numRetries) {
        Assert.fail((String)"selectLastItem() API is not implemented.");
    }

    @Override
    public void selectItem(String itemName, int numRetries) {
        Match match = this.findElement(numRetries);
        Region pullDownMenuRegion = this.calculatePullDownMenuRegion(match);
        try {
            match.click();
            ImageObject menuItemObj = new ImageObject(UIObjectType.menuItem, this.comboBoxObj.getDisplayName() + "-MenuItem", itemName);
            Match menuItemMatch = menuItemObj.getValidator(this.appDriver, pullDownMenuRegion).findElement(5);
            Assert.assertNotNull((Object)menuItemMatch, (String)("Failed to find item '" + itemName + "' in pull down menu of ComboBox '" + this.comboBoxObj.getDisplayName() + "'."));
            menuItemMatch.click();
        }
        catch (Throwable th) {
            match.click();
            Assert.fail((String)("Failed to find item '" + itemName + "' in pull down menu of ComboBox '" + this.comboBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    public void selectItemByImage(String imageItem, int numRetries) {
        Match match = this.findElement(numRetries);
        Region pullDownMenuRegion = this.calculatePullDownMenuRegion(match);
        try {
            match.click();
            ImageObject menuItemObj = new ImageObject(UIObjectType.menuItem, this.comboBoxObj.getDisplayName() + "-MenuItem", imageItem);
            Match menuItemMatch = menuItemObj.getValidator(this.appDriver, pullDownMenuRegion).findElement(5);
            Assert.assertNotNull((Object)menuItemMatch, (String)("Failed to find item '" + imageItem + "' in pull down menu of ComboBox '" + this.comboBoxObj.getDisplayName() + "'."));
            menuItemMatch.click();
        }
        catch (Throwable th) {
            match.click();
            Assert.fail((String)("Failed to find item '" + imageItem + "' in pull down menu of ComboBox '" + this.comboBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    protected Region calculatePullDownMenuRegion(Match match) {
        int pullDownX1 = 0;
        int pullDownY1 = 0;
        int pullDownW = 0;
        int pullDownH = 0;
        pullDownW = this.comboBoxObj.getPullDownMenuInfo().getWidth() < 1 ? match.getW() + 10 : this.comboBoxObj.getPullDownMenuInfo().getWidth();
        pullDownH = this.comboBoxObj.getPullDownMenuInfo().getHeight() < 1 ? 20 : this.comboBoxObj.getPullDownMenuInfo().getHeight();
        switch (this.comboBoxObj.getPullDownMenuInfo().getLocation()) {
            case bottom: {
                pullDownX1 = match.getX() - 7;
                pullDownY1 = match.getY() + match.getH();
                break;
            }
            case top: {
                pullDownX1 = match.getX() - 7;
                pullDownY1 = match.getY() - pullDownH;
            }
        }
        Region pullDownMenuRegion = new Region(pullDownX1, pullDownY1, pullDownW, pullDownH);
        return pullDownMenuRegion;
    }

    @Override
    public void selectItems(ItemList<String> itemsToBeSelected, int numRetries) {
        Match match = this.findElement(numRetries);
        Region pullDownMenuRegion = this.calculatePullDownMenuRegion(match);
        String currentItemName = "";
        try {
            match.click();
            Iterator<String> iterator = itemsToBeSelected.getItems().iterator();
            while (iterator.hasNext()) {
                String itemName;
                currentItemName = itemName = iterator.next();
                ImageObject menuItemObj = new ImageObject(UIObjectType.menuItem, this.comboBoxObj.getDisplayName() + "-MenuItem", itemName);
                Match menuItemMatch = menuItemObj.getValidator(this.appDriver, pullDownMenuRegion).findElement(2);
                Assert.assertNotNull((Object)menuItemMatch, (String)("Failed to find item '" + itemName + "' in pull down menu of ComboBox '" + this.comboBoxObj.getDisplayName() + "'."));
                menuItemMatch.click();
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to find item '" + currentItemName + "' in pull down menu of ComboBox '" + this.comboBoxObj.getDisplayName() + "'."));
        }
    }

    public void selectItemsByImage(ItemList<String> imageItemsToBeSelected, int numRetries) {
        Match match = this.findElement(numRetries);
        Region pullDownMenuRegion = this.calculatePullDownMenuRegion(match);
        String currentImageItem = "";
        try {
            match.click();
            Iterator<String> iterator = imageItemsToBeSelected.getItems().iterator();
            while (iterator.hasNext()) {
                String imageItem;
                currentImageItem = imageItem = iterator.next();
                ImageObject menuItemObj = new ImageObject(UIObjectType.menuItem, this.comboBoxObj.getDisplayName() + "-MenuItem", imageItem);
                Match menuItemMatch = menuItemObj.getValidator(this.appDriver, pullDownMenuRegion).findElement(2);
                Assert.assertNotNull((Object)menuItemMatch, (String)("Failed to find item '" + imageItem + "' in pull down menu of ComboBox '" + this.comboBoxObj.getDisplayName() + "'."));
                menuItemMatch.click();
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to find item '" + currentImageItem + "' in pull down menu of ComboBox '" + this.comboBoxObj.getDisplayName() + "'."));
        }
    }

    @Override
    public void validateItemsPresent(ItemList<String> items, int numRetries) {
        Match match = this.findElement(numRetries);
        Region pullDownMenuRegion = this.calculatePullDownMenuRegion(match);
        String currentItemName = "";
        match.click();
        try {
            Iterator<String> iterator = items.getItems().iterator();
            while (iterator.hasNext()) {
                String itemName;
                currentItemName = itemName = iterator.next();
                ImageObject menuItemObj = new ImageObject(UIObjectType.menuItem, this.comboBoxObj.getDisplayName() + "-MenuItem", itemName);
                Match menuItemMatch = menuItemObj.getValidator(this.appDriver, pullDownMenuRegion).findElement(2);
                if (menuItemMatch != null) continue;
                throw new FindFailed("Found no match.");
            }
            match.click();
        }
        catch (Throwable th) {
            match.click();
            Assert.fail((String)("Failed to find item '" + currentItemName + "' in pull down menu of ComboBox '" + this.comboBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    public void validateItemsPresentByImage(ItemList<String> imageItems, int numRetries) {
        Match match = this.findElement(numRetries);
        Region pullDownMenuRegion = this.calculatePullDownMenuRegion(match);
        String currentImageItem = "";
        match.click();
        try {
            Iterator<String> iterator = imageItems.getItems().iterator();
            while (iterator.hasNext()) {
                String imageItem;
                currentImageItem = imageItem = iterator.next();
                ImageObject menuItemObj = new ImageObject(UIObjectType.menuItem, this.comboBoxObj.getDisplayName() + "-MenuItem", imageItem);
                Match menuItemMatch = menuItemObj.getValidator(this.appDriver, pullDownMenuRegion).findElement(5);
                if (menuItemMatch != null) continue;
                throw new FindFailed("Found no match.");
            }
            match.click();
        }
        catch (Throwable th) {
            match.click();
            Assert.fail((String)("Failed to find item '" + currentImageItem + "' in pull down menu of ComboBox '" + this.comboBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void validateItemsNotPresent(ItemList<String> items, int numRetries) {
        Match match = this.findElement(numRetries);
        Region pullDownMenuRegion = this.calculatePullDownMenuRegion(match);
        match.click();
        for (String itemName : items.getItems()) {
            try {
                Match menuItemMatch = pullDownMenuRegion.find((Object)itemName);
                Assert.assertNull((Object)menuItemMatch, (String)("Item '" + itemName + "' in pull down menu of ComboBox '" + this.comboBoxObj.getDisplayName() + "' is already present."));
            }
            catch (FindFailed findFailed) {}
        }
    }

    public void validateItemsNotPresentByImage(ItemList<String> imageItems, int numRetries) {
        Match match = this.findElement(numRetries);
        Region pullDownMenuRegion = this.calculatePullDownMenuRegion(match);
        match.click();
        for (String imageItem : imageItems.getItems()) {
            try {
                Match menuItemMatch = pullDownMenuRegion.find((Object)imageItem);
                Assert.assertNull((Object)menuItemMatch, (String)("Item '" + imageItem + "' in pull down menu of ComboBox '" + this.comboBoxObj.getDisplayName() + "' is already present."));
            }
            catch (FindFailed findFailed) {}
        }
    }

    @Override
    @Deprecated
    public boolean isDisabled(int numRetries) {
        Assert.fail((String)"isDisabled() API is not supported by ComboBox component.");
        return false;
    }

    @Override
    @Deprecated
    public TouchAction getNewMobileTouchAction() {
        Assert.fail((String)"getNewMobileTouchAction() API is not supported by Button component.");
        return null;
    }

    @Override
    @Deprecated
    public MultiTouchAction getNewMobileMultiTouchAction() {
        Assert.fail((String)"getNewMobileMultiTouchAction() API is not supported by Button component.");
        return null;
    }

    @Override
    @Deprecated
    public Actions getNewSeleniumActions() {
        Assert.fail((String)"getNewSeleniumActions() API is not supported by Button component.");
        return null;
    }
}

