/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core;

import io.cucumber.java.Scenario;
import java.awt.Point;
import java.awt.Rectangle;
import org.sikuli.script.Screen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriverFactory;
import org.uitnet.testing.smartfwk.ui.core.config.AppConfig;
import org.uitnet.testing.smartfwk.ui.core.config.ApplicationType;
import org.uitnet.testing.smartfwk.ui.core.config.PlatformType;
import org.uitnet.testing.smartfwk.ui.core.config.TestConfigManager;
import org.uitnet.testing.smartfwk.ui.core.config.UserProfile;
import org.uitnet.testing.smartfwk.ui.core.config.database.orm.OrmDatabaseQueryHandler;
import org.uitnet.testing.smartfwk.ui.core.handler.ScrollElementToViewportHandler;
import org.uitnet.testing.smartfwk.ui.core.objects.logon.LoginPageValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.logon.LoginSuccessPageValidator;
import org.uitnet.testing.smartfwk.ui.core.utils.ScreenCaptureUtil;

public abstract class AbstractAppConnector {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected boolean logonTest = false;
    protected TestConfigManager testConfigManager = TestConfigManager.getInstance();
    protected String appName;
    protected ApplicationType appType;
    protected PlatformType testPlatformType;
    protected AppConfig appConfig;
    protected PlatformType hostPlatformType;
    protected String activeUserProfileName = "";
    protected UserProfile activeUserProfile;
    protected SmartAppDriver appDriver;

    protected AbstractAppConnector(String appName) {
        this.appName = appName;
        this.appConfig = this.testConfigManager.getAppConfig(appName);
        this.appType = this.appConfig.getAppType();
        this.testPlatformType = this.appConfig.getTestPlatformType();
        this.hostPlatformType = this.testConfigManager.getHostPlatformType();
        this.appDriver = SmartAppDriverFactory.getInstance().getLatestAppDriverOrCreateOne(appName);
    }

    public void scenarioSetup() {
    }

    public void scenarioTearDown() {
    }

    public void setScrollElementToViewportHandler(ScrollElementToViewportHandler handler) {
        this.appDriver.setScrollElementToViewportHandler(handler);
    }

    public String getAppName() {
        return this.appName;
    }

    public ApplicationType getAppType() {
        return this.appType;
    }

    public PlatformType getTestPlatformType() {
        return this.testPlatformType;
    }

    public String getActiveUserProfileName() {
        return this.activeUserProfileName;
    }

    public UserProfile getActiveUserProfile() {
        return this.activeUserProfile;
    }

    public SmartAppDriver getAppDriver() {
        return this.appDriver;
    }

    protected LoginPageValidator createNewLoginPageValidator() {
        String loginPageValidatorCls = this.testConfigManager.getAppConfig(this.appName).getAppLoginPageValidatorClass();
        LoginPageValidator loginPageValidator = null;
        try {
            loginPageValidator = (LoginPageValidator)Class.forName(loginPageValidatorCls).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            loginPageValidator.setInitParams(this.appDriver);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to load login page validator class '" + loginPageValidatorCls + "'."), (Throwable)th);
        }
        return loginPageValidator;
    }

    protected LoginSuccessPageValidator createNewLoginSuccessPageValidator() {
        String loginSuccessPageValidatorCls = this.testConfigManager.getAppConfig(this.appName).getAppLoginSuccessPageValidatorClass();
        LoginSuccessPageValidator loginSuccessPageValidator = null;
        try {
            loginSuccessPageValidator = (LoginSuccessPageValidator)Class.forName(loginSuccessPageValidatorCls).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            loginSuccessPageValidator.setInitParams(this.appDriver);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to load login page validator class '" + loginSuccessPageValidatorCls + "'."), (Throwable)th);
        }
        return loginSuccessPageValidator;
    }

    public SmartAppDriver checkLogoutAndLoginAgain(String userProfileName) {
        LoginPageValidator loginPageValidator = this.createNewLoginPageValidator();
        LoginSuccessPageValidator loginSuccessPageValidator = this.createNewLoginSuccessPageValidator();
        if (loginPageValidator.isLoginPageVisible(userProfileName)) {
            this.appDriver.openAppIfNotOpened();
            loginPageValidator.login(userProfileName);
            loginSuccessPageValidator.validate(userProfileName);
        } else if (!loginSuccessPageValidator.isLoginSuccessPageVisible(userProfileName)) {
            this.appDriver.openAppIfNotOpened();
            loginPageValidator.login(userProfileName);
            loginSuccessPageValidator.validate(userProfileName);
        }
        return this.appDriver;
    }

    public TestConfigManager getTestConfigManager() {
        return TestConfigManager.getInstance();
    }

    public AppConfig getAppConfig(String appName) {
        return this.testConfigManager.getAppConfig(appName);
    }

    public SmartAppDriver setActiveUserProfileName(String userProfileName) {
        if (!this.activeUserProfileName.equals(userProfileName)) {
            this.relogin(userProfileName);
            this.activeUserProfileName = userProfileName;
            this.activeUserProfile = this.appDriver.getAppConfig().getUserProfile(userProfileName);
        } else {
            this.checkLogoutAndLoginAgain(userProfileName);
            this.activeUserProfileName = userProfileName;
            this.activeUserProfile = this.appDriver.getAppConfig().getUserProfile(userProfileName);
        }
        return this.appDriver;
    }

    private void relogin(String userProfileName) {
        this.logoutAndNoQuit();
        this.checkLogoutAndLoginAgain(userProfileName);
    }

    public void relogin() {
        this.logoutAndNoQuit();
        this.checkLogoutAndLoginAgain(this.activeUserProfileName);
    }

    public void logoutAndNoQuit() {
        LoginPageValidator loginPageValidator = this.createNewLoginPageValidator();
        LoginSuccessPageValidator loginSuccessPageValidator = this.createNewLoginSuccessPageValidator();
        if (loginSuccessPageValidator.isLoginSuccessPageVisible(this.activeUserProfileName)) {
            loginSuccessPageValidator.logout(this.activeUserProfileName);
            loginPageValidator.validate(this.activeUserProfileName);
        }
    }

    public void logoutAndQuit() {
        try {
            this.logoutAndNoQuit();
        }
        finally {
            SmartAppDriverFactory.getInstance().removeAppDriver(this.appName, this.appDriver.getAppId());
            this.appDriver = SmartAppDriverFactory.getInstance().getLatestAppDriverOrCreateOne(this.appName);
        }
    }

    public OrmDatabaseQueryHandler getDatabaseQueryHandler(String appName, String dbProfileName) {
        return this.testConfigManager.getDatabaseQueryHandler(appName, dbProfileName);
    }

    public void captureScreenshot(Scenario scenario) {
        String fileNameHint = this.prepareScreenshotFileName(scenario) + "-" + scenario.getStatus();
        Rectangle screenArea = null;
        screenArea = (this.appConfig.getTestPlatformType() != PlatformType.windows || this.appConfig.getTestPlatformType() != PlatformType.linux || this.appConfig.getTestPlatformType() != PlatformType.mac) && this.appConfig.getAppType() == ApplicationType.web_app ? new Rectangle(new Point(0, 0), this.appConfig.getBrowserWindowSize()) : Screen.getPrimaryScreen().getRect();
        String imageFile = ScreenCaptureUtil.capture(this.testConfigManager.getAppScreenCaptureDirectory(), null, fileNameHint, screenArea);
        scenario.log("Screenshot Path: " + imageFile);
    }

    public void captureScreenshot(Scenario scenario, String status) {
        String fileNameHint = this.prepareScreenshotFileName(scenario);
        if (status != null) {
            fileNameHint = fileNameHint + "-" + status;
        }
        Rectangle screenArea = null;
        screenArea = (this.appConfig.getTestPlatformType() != PlatformType.windows || this.appConfig.getTestPlatformType() != PlatformType.linux || this.appConfig.getTestPlatformType() != PlatformType.mac) && this.appConfig.getAppType() == ApplicationType.web_app ? new Rectangle(new Point(0, 0), this.appConfig.getBrowserWindowSize()) : Screen.getPrimaryScreen().getRect();
        String imageFile = ScreenCaptureUtil.capture(this.testConfigManager.getAppScreenCaptureDirectory(), null, fileNameHint, screenArea);
        scenario.log("Screenshot Path: " + imageFile);
    }

    public void captureScreenshot(String fileNameHint) {
        Rectangle screenArea = null;
        screenArea = (this.appConfig.getTestPlatformType() != PlatformType.windows || this.appConfig.getTestPlatformType() != PlatformType.linux || this.appConfig.getTestPlatformType() != PlatformType.mac) && this.appConfig.getAppType() == ApplicationType.web_app ? new Rectangle(new Point(0, 0), this.appConfig.getBrowserWindowSize()) : Screen.getPrimaryScreen().getRect();
        ScreenCaptureUtil.capture(this.testConfigManager.getAppScreenCaptureDirectory(), null, fileNameHint, screenArea);
    }

    private String prepareScreenshotFileName(Scenario scenario) {
        String[] idParts = scenario.getId().split("/");
        String fileName = idParts[idParts.length - 1].replace(".", "-").replace(":", "-ScenarioLine(") + ")";
        return fileName;
    }
}

