/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.standard.imgobj;

import io.appium.java_client.MultiTouchAction;
import io.appium.java_client.TouchAction;
import java.util.List;
import org.openqa.selenium.Keys;
import org.openqa.selenium.interactions.Actions;
import org.sikuli.script.Button;
import org.sikuli.script.Location;
import org.sikuli.script.Match;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.commons.ImageSection;
import org.uitnet.testing.smartfwk.ui.core.objects.ImageObject;
import org.uitnet.testing.smartfwk.ui.core.objects.NewTextLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.scrollbar.Scrollbar;
import org.uitnet.testing.smartfwk.ui.core.objects.textbox.TextBoxValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.validator.mechanisms.TextMatchMechanism;
import org.uitnet.testing.smartfwk.ui.core.utils.ClipboardUtil;
import org.uitnet.testing.smartfwk.ui.standard.imgobj.TextBoxSI;

public class TextBoxValidatorSI
extends TextBoxValidator {
    protected TextBoxSI textBoxObj;

    public TextBoxValidatorSI(SmartAppDriver appDriver, TextBoxSI uiObject, Region region) {
        super(appDriver, uiObject, region);
        this.textBoxObj = uiObject;
    }

    @Override
    @Deprecated
    public void validateDisabled(int numRetries) {
        Assert.fail((String)"validateDisabled() API is not supported by TextBoxSI.");
    }

    @Override
    @Deprecated
    public void validateEnabled(int numRetries) {
        Assert.fail((String)"validateEnabled() API is not supported by TextBoxSI.");
    }

    @Override
    public boolean isPresent(int numRetries) {
        Match m = this.findElementNoException(numRetries);
        return m != null;
    }

    @Override
    public boolean isVisible(int numRetries) {
        return this.isPresent(numRetries);
    }

    @Override
    public void click(int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.click();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse click on TextBox '" + this.textBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    public void click(ImageSection imageSection, int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            this.getImageSection(match, imageSection).click();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse click on TextBox '" + this.textBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void doubleClick(int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.doubleClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse double click on TextBox '" + this.textBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    public void doubleClick(ImageSection imageSection, int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            this.getImageSection(match, imageSection).doubleClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse double click on TextBox '" + this.textBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void rightClick(int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.rightClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse right click on TextBox '" + this.textBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    public void rightClick(ImageSection imageSection, int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            this.getImageSection(match, imageSection).rightClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse right click on TextBox '" + this.textBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void clickAndHold(int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.mouseDown(Button.LEFT);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse clickAndHold on TextBox '" + this.textBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void release(int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.mouseDown(Button.LEFT);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse clickAndHold on TextBox '" + this.textBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void performKeyDown(Keys keys, int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.click();
            match.keyDown(this.seleniumToSikuliKeyConverter(keys));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform keyDown on TextBox '" + this.textBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void performKeyUp(Keys keys, int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.click();
            match.keyUp(this.seleniumToSikuliKeyConverter(keys));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform keyUp ('" + this.seleniumToSikuliKeyConverter(keys) + "') on TextBox '" + this.textBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void performKeyPressed(Keys keys, int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.click();
            match.type(this.seleniumToSikuliKeyConverter(keys));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform keyPressed ('" + this.seleniumToSikuliKeyConverter(keys) + "') on TextBox '" + this.textBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void typeText(String text, NewTextLocation location, int numRetries) {
        Match match = this.findElement(numRetries);
        try {
            match.click();
            switch (location) {
                case start: {
                    match.type("\ue008");
                    break;
                }
                case end: {
                    match.type("\ue007");
                    break;
                }
                case replace: {
                    match.type("a", 2);
                }
            }
            match.type(text);
        }
        catch (Throwable th) {
            Assert.fail((String)("Fail to type text '" + text + "' in TextBox '" + this.textBoxObj.getDisplayName() + "'."));
        }
    }

    @Override
    public TextBoxValidatorSI scrollElementOnViewport(Scrollbar scrollbar) {
        return this;
    }

    public Match findElement(int numRetries) {
        Match match = null;
        for (int i = 0; i <= numRetries; ++i) {
            try {
                Region region = this.textBoxObj.getLocation().getRegionOfImageObject(this.appDriver, this.textBoxObj.getLeftSideImage(), this.textBoxObj.getRightSideImage());
                Assert.assertNotNull((Object)region, (String)("Failed to find TextBox '" + this.textBoxObj.getDisplayName() + "'."));
                match = new Match(region, 1.0);
                break;
            }
            catch (Throwable th) {
                if (i == numRetries) {
                    Assert.fail((String)("Unable to find TextBox '" + this.textBoxObj.getDisplayName() + "'. Reason timeout(waited for " + numRetries * 2 + " seconds)."), (Throwable)th);
                    break;
                }
                this.appDriver.waitForSeconds(2);
                continue;
            }
        }
        return match;
    }

    public Match findElementNoException(int numRetries) {
        Match match = null;
        try {
            match = this.findElement(numRetries);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return match;
    }

    @Override
    public List<Match> findElements(int numRetries) {
        Assert.fail((String)"findElements() api for TextBoxSI element is not implemented.");
        return null;
    }

    public void dragAndDrop(ImageObject target, Region targetRegion, int numRetries) {
        try {
            Match sourceElem = this.findElement(numRetries);
            Match targetElem = target.getValidator(this.appDriver, targetRegion).findElement(numRetries);
            Assert.assertNotNull((Object)sourceElem, (String)("Failed to find TextBox '" + this.textBoxObj.getDisplayName() + "'."));
            Assert.assertNotNull((Object)targetElem, (String)("Failed to find element '" + target.getDisplayName() + "'."));
            sourceElem.drag((Object)targetElem);
            sourceElem.dropAt((Object)targetElem);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform dragAndDrop from source '" + this.textBoxObj.getDisplayName() + "' to target '" + target.getDisplayName() + "'."), (Throwable)th);
        }
    }

    protected Location getImageSection(Match imageMatch, ImageSection imageSection) {
        switch (imageSection) {
            case topLeft: {
                return imageMatch.getTopLeft();
            }
            case topRight: {
                return imageMatch.getTopRight();
            }
            case bottomLeft: {
                return imageMatch.getBottomLeft();
            }
            case bottomRight: {
                return imageMatch.getBottomRight();
            }
            case center: {
                return imageMatch.getCenter();
            }
        }
        return null;
    }

    @Override
    public void validateValue(String expectedValue, TextMatchMechanism validationMechanism, int numRetries) {
        if (this.textBoxObj.isDisabled()) {
            Match match = this.findElement(numRetries);
            this.validateTextValue(match.text(), expectedValue, validationMechanism);
        } else {
            this.validateTextValue(this.getValue(numRetries), expectedValue, validationMechanism);
        }
    }

    @Override
    public String getValue(int numRetries) {
        Match match = this.findElement(numRetries);
        if (this.textBoxObj.isDisabled()) {
            return match.text();
        }
        match.click();
        ClipboardUtil.clearContents();
        match.type("ac", 2);
        String contents = ClipboardUtil.getContents();
        ClipboardUtil.clearContents();
        match.click();
        return contents;
    }

    @Override
    @Deprecated
    public boolean isDisabled(int numRetries) {
        Assert.fail((String)"isDisabled() API is not supported by TextBox component.");
        return false;
    }

    @Override
    @Deprecated
    public boolean isReadonly(int numRetries) {
        Assert.fail((String)"isDisabled() API is not supported by TextBox component.");
        return false;
    }

    @Override
    @Deprecated
    public void validateReadonly(int numRetries) {
        Assert.fail((String)"isDisabled() API is not supported by TextBox component.");
    }

    @Override
    @Deprecated
    public void validateNotReadonly(int numRetries) {
        Assert.fail((String)"isDisabled() API is not supported by TextBox component.");
    }

    @Override
    @Deprecated
    public TouchAction getNewMobileTouchAction() {
        Assert.fail((String)"getNewMobileTouchAction() API is not supported by Button component.");
        return null;
    }

    @Override
    @Deprecated
    public MultiTouchAction getNewMobileMultiTouchAction() {
        Assert.fail((String)"getNewMobileMultiTouchAction() API is not supported by Button component.");
        return null;
    }

    @Override
    @Deprecated
    public Actions getNewSeleniumActions() {
        Assert.fail((String)"getNewSeleniumActions() API is not supported by Button component.");
        return null;
    }
}

