/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.standard.imgobj.datagrid;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import org.sikuli.script.FindFailed;
import org.sikuli.script.Match;
import org.sikuli.script.Region;
import org.sikuli.script.Screen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.commons.ItemList;
import org.uitnet.testing.smartfwk.ui.core.commons.UIObjectType;
import org.uitnet.testing.smartfwk.ui.core.objects.ImageObject;
import org.uitnet.testing.smartfwk.ui.core.objects.scrollbar.HorizontalScrollbar;
import org.uitnet.testing.smartfwk.ui.core.objects.scrollbar.VerticalScrollbar;
import org.uitnet.testing.smartfwk.ui.core.utils.DataMatchUtil;
import org.uitnet.testing.smartfwk.ui.standard.imgobj.datagrid.DataGridSI;
import org.uitnet.testing.smartfwk.ui.standard.imgobj.datagrid.HeaderColumnSI;
import org.uitnet.testing.smartfwk.ui.standard.imgobj.datagrid.RowLocation;
import org.uitnet.testing.smartfwk.ui.standard.imgobj.datagrid.SearchCell;
import org.uitnet.testing.smartfwk.ui.standard.imgobj.datagrid.ValueType;

public class DataGridValidatorSI {
    protected Logger logger = LoggerFactory.getLogger(DataGridValidatorSI.class);
    protected SmartAppDriver appDriver;
    protected DataGridSI dataGrid;
    protected Region region;
    int dataGridW;
    int dataGridH;
    int dataGridHeaderX1;
    int dataGridHeaderY1;
    int dataGridHeaderW;
    int dataGridHeaderH;
    int dataGridRecordsAreaX1;
    int dataGridRecordsAreaY1;
    int dataGridRecordsAreaW;
    int dataGridRecordsAreaH;

    public DataGridValidatorSI(SmartAppDriver appDriver, DataGridSI locator, Region region) {
        this.appDriver = appDriver;
        if (appDriver != null) {
            this.region = region == null ? Region.create((Rectangle)new Rectangle(0, 0, new Double(appDriver.getAppConfig().getBrowserWindowSize().getWidth()).intValue(), new Double(appDriver.getAppConfig().getBrowserWindowSize().getHeight()).intValue())) : region;
        }
        this.dataGrid = locator;
    }

    public DataGridSI getUIObject() {
        return this.dataGrid;
    }

    protected void initializeDataGridHeader(int numRetries) {
        Match firstColumnMatch = this.dataGrid.getKeyHeaderColumns().get(0).getValidator(this.appDriver, this.region).findElement(numRetries);
        this.dataGridHeaderX1 = firstColumnMatch.getX();
        this.dataGridHeaderY1 = firstColumnMatch.getY();
        this.dataGridHeaderH = firstColumnMatch.getH();
        try {
            BufferedImage bimg;
            this.dataGridHeaderW = 0;
            for (HeaderColumnSI hcol : this.dataGrid.getKeyHeaderColumns()) {
                bimg = ImageIO.read(new File(hcol.getColumnImage()));
                this.dataGridHeaderW += bimg.getWidth();
            }
            for (HeaderColumnSI hcol : this.dataGrid.getAdditionalHeaderColumns()) {
                bimg = ImageIO.read(new File(hcol.getColumnImage()));
                this.dataGridHeaderW += bimg.getWidth();
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to calculate the width of the DataGrid header '" + this.dataGrid.getDisplayName()), (Throwable)th);
        }
        Screen screen = this.appDriver.getSikuliScreen();
        this.dataGridW = this.dataGrid.getWidth() > 0 ? this.dataGrid.getWidth() : screen.getX() + screen.getW() - this.dataGridHeaderX1;
        this.dataGridH = this.dataGrid.getHeight() > 0 ? this.dataGrid.getHeight() : screen.getY() + screen.getH() - this.dataGridHeaderX1;
    }

    public void initializeDataGrid(int numRetries) {
        this.initializeDataGridHeader(numRetries);
        this.dataGridRecordsAreaX1 = this.dataGridHeaderX1;
        this.dataGridRecordsAreaY1 = this.dataGridHeaderY1 + this.dataGridHeaderH;
        this.dataGridRecordsAreaW = this.dataGridHeaderW;
        this.dataGridRecordsAreaH = this.dataGrid.getHeight() - this.dataGridHeaderH;
    }

    protected boolean isHScrollingRequired() {
        return this.dataGridHeaderW > this.dataGridW;
    }

    public RowLocation isRecordPresent(ItemList<SearchCell> primaryKey, VerticalScrollbar vScrollbar, Region vScrollbarRegion, int numHops, int numHopIters) {
        RowLocation rowLocation = null;
        boolean scrollingEnd = false;
        boolean scrollOpEnabled = false;
        if (vScrollbar != null && !vScrollbar.isScrollbarDisabled(vScrollbarRegion) && vScrollbar.isFullScrollbarVisible(vScrollbarRegion)) {
            scrollOpEnabled = true;
        }
        while ((rowLocation = this.isRecordPresent(primaryKey)) == null && scrollOpEnabled && numHopIters > 0) {
            scrollingEnd = vScrollbar.clickBottomScrollImage(vScrollbarRegion, numHops);
            if (scrollingEnd) {
                rowLocation = this.isRecordPresent(primaryKey);
                break;
            }
            if (--numHopIters >= 0) continue;
        }
        return rowLocation;
    }

    public RowLocation isRecordPresent(ItemList<SearchCell> primaryKey) {
        System.out.println("Going to search record " + primaryKey + " in DataGrid '" + this.dataGrid.getDisplayName() + "'.");
        RowLocation rowLocation = null;
        Set<Integer> rowMarkers = this.findRowMarkerY1();
        LinkedHashMap<HeaderColumnSI, Rectangle> headerColsLocations = new LinkedHashMap<HeaderColumnSI, Rectangle>();
        Rectangle colRect = null;
        Region headerRegion = Region.create((int)this.dataGridHeaderX1, (int)this.dataGridHeaderY1, (int)this.dataGridHeaderW, (int)this.dataGridHeaderH);
        for (SearchCell gridCell : primaryKey.getItems()) {
            colRect = gridCell.getColumn().getValidator(this.appDriver, headerRegion).findElement(0).getRect();
            headerColsLocations.put(gridCell.getColumn(), colRect);
        }
        Region cellRegion = null;
        String valueToValidate = null;
        ImageObject imgObjToValidate = null;
        int lastProcessedRowEndY = new Double(colRect.getY()).intValue() + new Double(colRect.getHeight()).intValue();
        try {
            Iterator<Integer> rowMarkersItr = rowMarkers.iterator();
            for (int i = 0; i < rowMarkers.size(); ++i) {
                int rowMarker = rowMarkersItr.next();
                try {
                    for (SearchCell gridCell : primaryKey.getItems()) {
                        Match m;
                        colRect = (Rectangle)headerColsLocations.get(gridCell.getColumn());
                        cellRegion = new Region(new Double(colRect.getX()).intValue(), lastProcessedRowEndY, new Double(colRect.getWidth()).intValue(), rowMarker - lastProcessedRowEndY);
                        cellRegion.setAutoWaitTimeout(1.0);
                        if (gridCell.getValueType() == ValueType.text) {
                            valueToValidate = (String)gridCell.getValue();
                            String actualText = cellRegion.text();
                            System.out.println("Row: " + (i + 1) + ", ColumnName:" + gridCell.getColumn().getDisplayName() + ", Expected: " + valueToValidate + ", Actual: " + actualText);
                            DataMatchUtil.validateTextValue(actualText, valueToValidate, gridCell.getTextValueValidationMechanism());
                            continue;
                        }
                        if (gridCell.getValueType() == ValueType.imageAsStringPath) {
                            valueToValidate = (String)gridCell.getValue();
                            m = cellRegion.find((Object)valueToValidate);
                            Assert.assertNotNull((Object)m);
                            continue;
                        }
                        if (gridCell.getValueType() == ValueType.imageAsImageObject) {
                            imgObjToValidate = (ImageObject)gridCell.getValue();
                            m = cellRegion.find((Object)imgObjToValidate.getImage());
                            Assert.assertNotNull((Object)m);
                            continue;
                        }
                        Assert.fail((String)("ValueType '" + gridCell.getValueType().name() + "' is not supported."));
                    }
                    rowLocation = new RowLocation(cellRegion.getY(), cellRegion.getY() + cellRegion.getH());
                    break;
                }
                catch (Throwable throwable) {
                    lastProcessedRowEndY = rowMarker;
                    if (i != rowMarkers.size() - 1) continue;
                    throw new FindFailed("Unable to find record");
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return rowLocation;
    }

    public List<List<String>> extractRecordsForVisibleColumns(int numRecords, ItemList<HeaderColumnSI> headerColumns, VerticalScrollbar vScrollbar, Region vScrollbarRegion, int numHops, int numHopIters) {
        LinkedList<List<String>> records = new LinkedList<List<String>>();
        boolean scrollingEnd = false;
        boolean scrollOpEnabled = false;
        if (vScrollbar != null && !vScrollbar.isScrollbarDisabled(vScrollbarRegion) && vScrollbar.isFullScrollbarVisible(vScrollbarRegion)) {
            scrollOpEnabled = true;
        }
        List<List<String>> visibleRecords = null;
        do {
            int i;
            int prevRecordSize = records.size();
            visibleRecords = this.extractVisibleRecordsForVisibleColumns(headerColumns);
            if (visibleRecords == null || visibleRecords.size() == 0) break;
            for (i = prevRecordSize; (numRecords < 0 || numRecords >= 0 && i < numRecords) && i - prevRecordSize < visibleRecords.size(); ++i) {
                List<String> row = visibleRecords.get(i - prevRecordSize);
                if (((Object)records).toString().equals(row.toString())) continue;
                records.add(row);
            }
            if (records.size() >= numRecords || !scrollOpEnabled || numHopIters <= 0) break;
            scrollingEnd = vScrollbar.clickBottomScrollImage(vScrollbarRegion, numHops);
            if (!scrollingEnd) continue;
            visibleRecords = this.extractVisibleRecordsForVisibleColumns(headerColumns);
            if (visibleRecords == null || visibleRecords.size() == 0) break;
            for (i = prevRecordSize; (numRecords < 0 || numRecords >= 0 && i < numRecords) && i - prevRecordSize < visibleRecords.size(); ++i) {
                records.add(visibleRecords.get(i - prevRecordSize));
            }
            break;
        } while (--numHopIters >= 0);
        return records;
    }

    public List<List<String>> extractVisibleRecordsForVisibleColumns(ItemList<HeaderColumnSI> headerColumns) {
        LinkedList<List<String>> records = new LinkedList<List<String>>();
        LinkedHashMap<HeaderColumnSI, Rectangle> headerColsLocations = new LinkedHashMap<HeaderColumnSI, Rectangle>();
        Rectangle colRect = null;
        Region headerRegion = Region.create((int)this.dataGridHeaderX1, (int)this.dataGridHeaderY1, (int)this.dataGridHeaderW, (int)this.dataGridHeaderH);
        for (HeaderColumnSI headerColumn : headerColumns.getItems()) {
            colRect = headerColumn.getValidator(this.appDriver, headerRegion).findElement(0).getRect();
            headerColsLocations.put(headerColumn, colRect);
        }
        String emptyRow = "[";
        for (int i = 1; i < headerColumns.size(); ++i) {
            emptyRow = emptyRow + ", ";
        }
        emptyRow = emptyRow + "]";
        Region cellRegion = null;
        int lastProcessedRowEndY = new Double(colRect.getY()).intValue() + new Double(colRect.getHeight()).intValue();
        Set<Integer> rowMarkers = this.findRowMarkerY1();
        try {
            Iterator<Integer> rowMarkersItr = rowMarkers.iterator();
            for (int i = 0; i < rowMarkers.size(); ++i) {
                int rowMarker = rowMarkersItr.next();
                try {
                    LinkedList<String> row = new LinkedList<String>();
                    for (HeaderColumnSI gridCell : headerColumns.getItems()) {
                        colRect = (Rectangle)headerColsLocations.get(gridCell);
                        cellRegion = new Region(new Double(colRect.getX()).intValue(), lastProcessedRowEndY, new Double(colRect.getWidth()).intValue(), rowMarker - lastProcessedRowEndY);
                        cellRegion.setAutoWaitTimeout(1.0);
                        String cellText = cellRegion.text();
                        if (cellText == null) {
                            cellText = "";
                        }
                        cellText = cellText.trim();
                        row.add(cellText);
                    }
                    if (!emptyRow.equals(((Object)row).toString())) {
                        records.add(row);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                lastProcessedRowEndY = rowMarker;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return records;
    }

    public void validateRecordPresent(ItemList<SearchCell> primaryKey) {
        Assert.assertNotNull((Object)this.isRecordPresent(primaryKey), (String)("Failed to find Record'" + primaryKey.getItems() + "' in DataGrid '" + this.dataGrid.getDisplayName() + "'"));
    }

    public Region getCellRegion(HeaderColumnSI headerColumn, RowLocation rowLocation, HorizontalScrollbar hScrollbar, int scrollStepsToLookup) {
        Region headerRegion = Region.create((int)this.dataGridHeaderX1, (int)this.dataGridHeaderY1, (int)this.dataGridHeaderW, (int)this.dataGridHeaderH);
        Rectangle colRect = null;
        if (hScrollbar == null) {
            try {
                colRect = headerColumn.getValidator(this.appDriver, headerRegion).findElement(0).getRect();
            }
            catch (Throwable throwable) {}
        } else {
            Region hScrollRegion = Region.create((int)this.dataGridHeaderX1, (int)(this.dataGridHeaderY1 + this.dataGridH - 100), (int)this.dataGridW, (int)this.dataGridH);
            hScrollbar.scrollThumbGripToExtremeLeft(hScrollRegion);
            boolean scrollEnded = false;
            while (!scrollEnded) {
                try {
                    colRect = headerColumn.getValidator(this.appDriver, headerRegion).findElement(0).getRect();
                    break;
                }
                catch (Throwable th) {
                    scrollEnded = hScrollbar.clickRightScrollImage(hScrollRegion, scrollStepsToLookup);
                }
            }
        }
        Assert.assertNotNull((Object)colRect, (String)("Failed to find HeaderColumn '" + headerColumn.getDisplayName() + "' in DataGrid '" + this.dataGrid.getDisplayName() + "'."));
        Region cellRegion = Region.create((int)new Double(colRect.getX()).intValue(), (int)rowLocation.getY1(), (int)new Double(colRect.getWidth()).intValue(), (int)rowLocation.getRowHeight());
        cellRegion.setAutoWaitTimeout(1.0);
        return cellRegion;
    }

    public void validateCellValuePresent(SearchCell cellValue, RowLocation rowLocation, HorizontalScrollbar hScrollbar, int scrollStepsToLookup) {
        Region headerRegion = Region.create((int)this.dataGridHeaderX1, (int)this.dataGridHeaderY1, (int)this.dataGridHeaderW, (int)this.dataGridHeaderH);
        Rectangle colRect = null;
        if (hScrollbar == null) {
            try {
                colRect = cellValue.getColumn().getValidator(this.appDriver, headerRegion).findElement(0).getRect();
            }
            catch (Throwable throwable) {}
        } else {
            Region hScrollRegion = Region.create((int)this.dataGridHeaderX1, (int)(this.dataGridHeaderY1 + this.dataGridH - 100), (int)this.dataGridW, (int)this.dataGridH);
            hScrollbar.scrollThumbGripToExtremeLeft(hScrollRegion);
            boolean scrollEnded = false;
            while (!scrollEnded) {
                try {
                    colRect = cellValue.getColumn().getValidator(this.appDriver, headerRegion).findElement(0).getRect();
                    break;
                }
                catch (Throwable th) {
                    scrollEnded = hScrollbar.clickRightScrollImage(hScrollRegion, scrollStepsToLookup);
                }
            }
        }
        Assert.assertNotNull((Object)colRect, (String)("Failed to find HeaderColumn '" + cellValue.getColumn().getDisplayName() + "' in DataGrid '" + this.dataGrid.getDisplayName() + "'."));
        Region cellRegion = Region.create((int)new Double(colRect.getX()).intValue(), (int)rowLocation.getY1(), (int)new Double(colRect.getWidth()).intValue(), (int)rowLocation.getRowHeight());
        cellRegion.setAutoWaitTimeout(1.0);
        String valueToValidate = null;
        ImageObject imgObjToValidate = null;
        try {
            if (cellValue.getValueType() == ValueType.text) {
                valueToValidate = (String)cellValue.getValue();
                String actualText = cellRegion.text();
                System.out.println("ColumnName:" + cellValue.getColumn().getDisplayName() + ", Expected: " + valueToValidate + ", Actual: " + actualText);
                DataMatchUtil.validateTextValue(actualText, valueToValidate, cellValue.getTextValueValidationMechanism());
            } else if (cellValue.getValueType() == ValueType.imageAsStringPath) {
                valueToValidate = (String)cellValue.getValue();
                Match m = cellRegion.find((Object)valueToValidate);
                Assert.assertNotNull((Object)m);
            } else if (cellValue.getValueType() == ValueType.imageAsImageObject) {
                imgObjToValidate = (ImageObject)cellValue.getValue();
                Match m = cellRegion.find((Object)imgObjToValidate.getImage());
                Assert.assertNotNull((Object)m);
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to match cell value '" + cellValue + "' in DataGrid '" + this.dataGrid.getDisplayName() + "'."), (Throwable)th);
        }
    }

    protected Set<Integer> findRowMarkerY1() {
        TreeSet<Integer> rowMarkerY1 = new TreeSet<Integer>();
        for (String rowMarkerImg : this.dataGrid.getRowMarkerImages()) {
            try {
                ImageObject rowMarkerImgObj = new ImageObject(UIObjectType.image, this.dataGrid.getDisplayName() + "-RowMarker", rowMarkerImg);
                Object matches = rowMarkerImgObj.getValidator(this.appDriver, new Region(this.dataGridRecordsAreaX1 - 8, this.dataGridRecordsAreaY1 + 5, this.dataGridRecordsAreaX1 + 50, this.dataGridRecordsAreaH)).findElements(0);
                if (matches == null) continue;
                Iterator iterator = matches.iterator();
                while (iterator.hasNext()) {
                    Match m = (Match)iterator.next();
                    rowMarkerY1.add(m.getY());
                }
            }
            catch (Throwable th) {
            }
        }
        TreeSet<Integer> rowMarkerNormY1 = new TreeSet<Integer>();
        LinkedList<Integer> conPoints = new LinkedList<Integer>();
        int counter = rowMarkerY1.size();
        Iterator iterator = rowMarkerY1.iterator();
        while (iterator.hasNext()) {
            int cp1;
            Iterator iterator2;
            int sum;
            int p = (Integer)iterator.next();
            --counter;
            if (conPoints.size() == 0 || p - (Integer)conPoints.get(conPoints.size() - 1) < 10) {
                conPoints.add(p);
            } else if (p - (Integer)conPoints.get(conPoints.size() - 1) >= 10) {
                sum = 0;
                iterator2 = conPoints.iterator();
                while (iterator2.hasNext()) {
                    cp1 = (Integer)iterator2.next();
                    sum += cp1;
                }
                rowMarkerNormY1.add(sum / conPoints.size());
                conPoints.clear();
            }
            if (counter != 0 || conPoints.size() <= 0) continue;
            sum = 0;
            iterator2 = conPoints.iterator();
            while (iterator2.hasNext()) {
                cp1 = (Integer)iterator2.next();
                sum += cp1;
            }
            rowMarkerNormY1.add(sum / conPoints.size());
            conPoints.clear();
        }
        return rowMarkerNormY1;
    }

    public boolean isPresent(int numRetries) {
        return false;
    }
}

