/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.cache;

import io.cucumber.java.Scenario;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.SubmissionPublisher;
import org.uitnet.testing.smartfwk.ui.core.AbstractAppConnector;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.cache.SmartCacheSubscriber;

public abstract class SmartCache {
    private Map<String, Object> cache = new HashMap<String, Object>();
    private AbstractAppConnector appConnector;
    private SmartAppDriver appDriver;
    private Scenario runningScenario;
    private SubmissionPublisher<SmartCache> publisher = new SubmissionPublisher();

    public <V> void add(String key, V value) {
        this.cache.put(key, value);
    }

    public <V> V get(String key) {
        return (V)this.cache.get(key);
    }

    public <V> V removeAndget(String key) {
        return (V)this.cache.remove(key);
    }

    public Set<String> getKeysStartsWith(String startsWithStr) {
        HashSet<String> keys = new HashSet<String>();
        for (String k : this.cache.keySet()) {
            if (!k.startsWith(startsWithStr)) continue;
            keys.add(k);
        }
        return keys;
    }

    public Set<String> getKeysEndsWith(String endsWithStr) {
        HashSet<String> keys = new HashSet<String>();
        for (String k : this.cache.keySet()) {
            if (!k.endsWith(endsWithStr)) continue;
            keys.add(k);
        }
        return keys;
    }

    public boolean isKeyPresent(String key) {
        return this.cache.get(key) != null;
    }

    public void subscribe(SmartCacheSubscriber subscriber) {
        this.publisher.subscribe(subscriber);
    }

    public void publish(SmartCache cache) {
        this.publisher.submit(cache);
    }

    public AbstractAppConnector getAppConnector() {
        return this.appConnector;
    }

    public void setAppConnector(AbstractAppConnector appConnector) {
        this.appConnector = appConnector;
    }

    public SmartAppDriver getAppDriver() {
        return this.appDriver;
    }

    public void setAppDriver(SmartAppDriver appDriver) {
        this.appDriver = appDriver;
    }

    public Scenario getRunningScenario() {
        return this.runningScenario;
    }

    public void setRunningScenario(Scenario runningScenario) {
        this.runningScenario = runningScenario;
    }
}

