/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.config;

import java.io.File;
import java.io.FileReader;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.commons.Locations;
import org.uitnet.testing.smartfwk.ui.core.config.AppConfig;
import org.uitnet.testing.smartfwk.ui.core.config.AppDriverConfig;
import org.uitnet.testing.smartfwk.ui.core.config.DatabaseProfile;
import org.uitnet.testing.smartfwk.ui.core.config.PlatformType;
import org.uitnet.testing.smartfwk.ui.core.config.SikuliSettings;
import org.uitnet.testing.smartfwk.ui.core.config.UserProfile;
import org.uitnet.testing.smartfwk.ui.core.config.WebBrowserType;
import org.uitnet.testing.smartfwk.ui.core.config.database.orm.OrmDatabaseQueryHandler;
import org.uitnet.testing.smartfwk.ui.core.utils.OSDetectorUtil;

public class TestConfigManager {
    private static TestConfigManager instance;
    private static final String TEST_CONFIG_FILE_PATH;
    private String appsConfigDir;
    private List<String> appNames;
    private String cucumberTestcasesDir;
    private String appScreenCaptureDir;
    private String sikuliConfigDir;
    private String sikuliResourcesDir;
    private PlatformType hostPlatformType;
    private Map<String, AppConfig> appConfigs;
    private Map<String, String> additionalProps;
    private Map<String, AppDriverConfig> seleniumDriverConfigs;
    private SikuliSettings sikuliSettings;

    private TestConfigManager() {
        this.init();
        this.initSikuliSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TestConfigManager getInstance() {
        if (instance != null) return instance;
        Class<TestConfigManager> clazz = TestConfigManager.class;
        synchronized (TestConfigManager.class) {
            if (instance != null) return instance;
            instance = new TestConfigManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void init() {
        this.hostPlatformType = OSDetectorUtil.getHostPlatform();
        this.appNames = new LinkedList<String>();
        this.appConfigs = new LinkedHashMap<String, AppConfig>();
        this.additionalProps = new LinkedHashMap<String, String>();
        String systemTestCfgFilePath = System.getProperty("TEST_CONFIG_FILE_PATH");
        systemTestCfgFilePath = systemTestCfgFilePath == null || "".equals(systemTestCfgFilePath.trim()) ? TEST_CONFIG_FILE_PATH : Locations.getConfigDirPath() + systemTestCfgFilePath;
        try (FileReader fileReader = new FileReader(systemTestCfgFilePath);){
            Properties properties = new Properties();
            properties.load(fileReader);
            this.initTestConfig(properties);
            this.initAppConfigs();
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to read property file - " + TEST_CONFIG_FILE_PATH + ". Going to exit..."), (Throwable)ex);
            System.exit(1);
        }
    }

    private void initTestConfig(Properties properties) {
        try {
            String[] arr;
            String appNamesAsStr;
            this.appsConfigDir = System.getProperty("APPS_CONFIG_DIR");
            if (this.appsConfigDir == null || "".equals(this.appsConfigDir.trim())) {
                this.appsConfigDir = properties.getProperty("APPS_CONFIG_DIR");
                this.appsConfigDir = this.appsConfigDir == null || "".equals(this.appsConfigDir.trim()) ? Locations.getProjectRootDir() + "/test-config/apps-config" : Locations.getProjectRootDir() + File.separator + this.appsConfigDir;
            }
            if (((appNamesAsStr = System.getProperty("APP_NAMES")) == null || "".equals(appNamesAsStr.trim())) && ((appNamesAsStr = properties.getProperty("APP_NAMES")) == null || "".equals(appNamesAsStr.trim()))) {
                Assert.fail((String)"FATAL: No application configured.");
                System.exit(1);
            }
            for (String appName : arr = appNamesAsStr.split(",")) {
                if ("".equals(appName.trim())) continue;
                this.appNames.add(appName.trim());
            }
            if (this.appNames.size() == 0) {
                Assert.fail((String)"FATAL: No application configured.");
                System.exit(1);
            }
            this.cucumberTestcasesDir = System.getProperty("CUCUMBER_TESTCASES_DIR");
            if (this.cucumberTestcasesDir == null || "".equals(this.cucumberTestcasesDir.trim())) {
                this.cucumberTestcasesDir = properties.getProperty("CUCUMBER_TESTCASES_DIR");
                this.cucumberTestcasesDir = this.cucumberTestcasesDir == null || "".equals(this.cucumberTestcasesDir.trim()) ? Locations.getProjectRootDir() + "/cucumber-testcases" : Locations.getProjectRootDir() + File.separator + this.cucumberTestcasesDir;
            }
            this.appScreenCaptureDir = System.getProperty("APP_SCREEN_CAPTURE_DIR");
            if (this.appScreenCaptureDir == null || "".equals(this.appScreenCaptureDir.trim())) {
                this.appScreenCaptureDir = properties.getProperty("APP_SCREEN_CAPTURE_DIR");
                this.appScreenCaptureDir = this.appScreenCaptureDir == null || "".equals(this.appScreenCaptureDir.trim()) ? Locations.getProjectRootDir() + "/test-results/screen-captures" : Locations.getProjectRootDir() + File.separator + this.appScreenCaptureDir;
            }
            this.sikuliConfigDir = System.getProperty("SIKULI_CONFIG_DIR");
            if (this.sikuliConfigDir == null || "".equals(this.sikuliConfigDir.trim())) {
                this.sikuliConfigDir = properties.getProperty("SIKULI_CONFIG_DIR");
                this.sikuliConfigDir = this.sikuliConfigDir == null || "".equals(this.sikuliConfigDir.trim()) ? Locations.getProjectRootDir() + "/test-config/sikuli-config" : Locations.getProjectRootDir() + File.separator + this.sikuliConfigDir;
            }
            this.sikuliResourcesDir = System.getProperty("SIKULI_RESOURCES_DIR");
            if (this.sikuliResourcesDir == null || "".equals(this.sikuliResourcesDir.trim())) {
                this.sikuliResourcesDir = properties.getProperty("SIKULI_RESOURCES_DIR");
                this.sikuliResourcesDir = this.sikuliResourcesDir == null || "".equals(this.sikuliResourcesDir.trim()) ? Locations.getProjectRootDir() + "/sikuli-resources" : Locations.getProjectRootDir() + File.separator + this.sikuliResourcesDir;
            }
            for (Object key : properties.keySet()) {
                String keyStr = String.valueOf(key);
                if (!keyStr.startsWith("_")) continue;
                this.additionalProps.put(keyStr, properties.getProperty(keyStr));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)"Error in loading configured testcase config class. Going to exit...", (Throwable)ex);
            System.exit(1);
        }
    }

    private void initAppConfigs() {
        String currAppName = null;
        try {
            Iterator<String> iterator = this.appNames.iterator();
            while (iterator.hasNext()) {
                String appName;
                currAppName = appName = iterator.next();
                String appConfigFile = this.appsConfigDir + File.separator + appName + File.separator + "AppConfig.properties";
                FileReader fileReader = new FileReader(appConfigFile);
                Properties properties = new Properties();
                properties.load(fileReader);
                fileReader.close();
                AppConfig appConfig = new AppConfig(currAppName, properties, this.appsConfigDir);
                this.appConfigs.put(appName, appConfig);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("Error in loading AppConfig.properties file for application name '" + currAppName + "'. Going to exit..."), (Throwable)ex);
            System.exit(1);
        }
    }

    public AppConfig getAppConfig(String appName) {
        AppConfig appConfig = this.appConfigs.get(appName);
        Assert.assertNotNull((Object)appConfig, (String)("Please configure application config for application '" + appName + "'."));
        return appConfig;
    }

    public UserProfile getUserProfile(String appName, String profileName) {
        AppConfig appConfig = this.getAppConfig(appName);
        return appConfig.getUserProfile(profileName);
    }

    public DatabaseProfile getDatabaseProfile(String appName, String profileName) {
        AppConfig appConfig = this.getAppConfig(appName);
        return appConfig.getDatabaseProfile(profileName);
    }

    public OrmDatabaseQueryHandler getDatabaseQueryHandler(String appName, String profileName) {
        return this.getDatabaseProfile(appName, profileName).getQueryHandler();
    }

    public String getAdditionalPropertyValue(String propName) {
        Assert.assertTrue((boolean)this.additionalProps.containsKey(propName), (String)("Please specify the additional property '" + propName + "' in TestConfig.properties file."));
        return this.additionalProps.get(propName);
    }

    public String getAdditionalPropertyValue(String appName, String propName) {
        return this.getAppConfig(appName).getAdditionalPropertyValue(propName);
    }

    public String getAppScreenCaptureDirectory() {
        return this.appScreenCaptureDir;
    }

    public String getUserProfileAdditionalPropertyValue(String appName, String profileName, String propName) {
        return this.getUserProfile(appName, profileName).getAdditionalPropertyValue(propName);
    }

    private void initSikuliSettings() {
        String sikuliSettingsFile = this.sikuliConfigDir + File.separator + "SikuliSettings.properties";
        try (FileReader fileReader = new FileReader(sikuliSettingsFile);){
            Properties properties = new Properties();
            properties.load(fileReader);
            this.sikuliSettings = new SikuliSettings(this.sikuliConfigDir, properties);
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to read property file - " + sikuliSettingsFile + ". Going to exit..."), (Throwable)ex);
            System.exit(1);
        }
    }

    public Map<String, AppDriverConfig> getSeleniumDriverConfings() {
        return this.seleniumDriverConfigs;
    }

    public AppDriverConfig getSeleniumDriverConfig(WebBrowserType browserType) {
        return this.seleniumDriverConfigs.get(browserType.name());
    }

    public SikuliSettings getSikuliSettings() {
        return this.sikuliSettings;
    }

    public String getSikuliResourcesDir() {
        return this.sikuliResourcesDir;
    }

    public PlatformType getHostPlatformType() {
        return this.hostPlatformType;
    }

    static {
        TEST_CONFIG_FILE_PATH = Locations.getConfigDirPath() + File.separator + "TestConfig.properties";
    }
}

