/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.file.reader.support;

import java.util.ArrayList;
import java.util.List;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.file.reader.support.Condition;
import org.uitnet.testing.smartfwk.ui.core.file.reader.support.Join;
import org.uitnet.testing.smartfwk.ui.core.file.reader.support.Operator;
import org.uitnet.testing.smartfwk.ui.core.file.reader.support.RowFilter;
import org.uitnet.testing.smartfwk.ui.core.file.reader.support.TableRow;

public class Table {
    private String tableName;
    private List<String> columnNames;
    private List<List<String>> rows;

    public Table(String tableName) {
        this.tableName = tableName;
        this.columnNames = new ArrayList<String>();
        this.rows = new ArrayList<List<String>>();
    }

    public String getTableName() {
        return this.tableName;
    }

    public void addColumnName(String columnName) {
        this.columnNames.add(columnName);
    }

    public void addColumnNames(List<String> columnNames) {
        this.columnNames.addAll(columnNames);
    }

    public void addRow(List<String> row) {
        Assert.assertFalse((this.columnNames.size() == 0 ? 1 : 0) != 0, (String)("Failed to add row as there is no column added in the table '" + this.tableName + "'."));
        Assert.assertFalse((row == null ? 1 : 0) != 0, (String)"Row cannot be empty.");
        if (row.size() < this.columnNames.size()) {
            for (int diff = this.columnNames.size() - row.size(); diff > 0; --diff) {
                row.add("");
            }
        } else if (row.size() > this.columnNames.size()) {
            for (int diff = row.size() - this.columnNames.size(); diff > 0; --diff) {
                row.remove(diff);
            }
        }
        this.rows.add(row);
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public List<List<String>> getRawRows() {
        return this.rows;
    }

    public List<String> getRawRow(int index) {
        return this.rows.get(index);
    }

    public List<TableRow> getRows() {
        ArrayList<TableRow> tableRows = new ArrayList<TableRow>();
        for (int i = 0; i < this.rows.size(); ++i) {
            tableRows.add(new TableRow(this, i));
        }
        return tableRows;
    }

    public List<String> getColumnData(String columnName) {
        int colIndex = this.columnNames.indexOf(columnName);
        Assert.assertTrue((colIndex >= 0 ? 1 : 0) != 0, (String)("Column '" + columnName + "' does not exist in the table '" + this.tableName + "'."));
        ArrayList<String> colData = new ArrayList<String>();
        for (List<String> row : this.rows) {
            if (row.size() > colIndex) {
                colData.add(row.get(colIndex));
                continue;
            }
            colData.add("");
        }
        return colData;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnIndex(String columnName) {
        int colIndex = this.columnNames.indexOf(columnName);
        Assert.assertTrue((colIndex >= 0 ? 1 : 0) != 0, (String)("Column '" + columnName + "' does not exist in the table '" + this.tableName + "'."));
        return colIndex;
    }

    public TableRow getRow(int rowNumber) {
        Assert.assertFalse((rowNumber < 1 || rowNumber > this.rows.size() ? 1 : 0) != 0, (String)("Row number should be between 1 and " + this.rows.size() + "."));
        TableRow trow = new TableRow(this, rowNumber - 1);
        return trow;
    }

    public List<TableRow> getRows(RowFilter rowFilter) {
        ArrayList<TableRow> tableRows = new ArrayList<TableRow>();
        Assert.assertFalse((rowFilter == null || rowFilter.getFilter().size() == 0 ? 1 : 0) != 0, (String)"Row filter can not be empty.");
        List<Object> filter = rowFilter.getFilter();
        Join nextJoin = null;
        for (int i = 0; i < this.rows.size(); ++i) {
            TableRow trow = new TableRow(this, i);
            boolean condition1Matched = false;
            nextJoin = null;
            for (Object st : filter) {
                block5: {
                    block3: {
                        boolean condition2Matched;
                        block6: {
                            String colValue;
                            block4: {
                                if (!(st instanceof Condition)) break block3;
                                if (nextJoin != null) break block4;
                                colValue = trow.getColumnValue(((Condition)st).getColumnName());
                                condition1Matched = colValue != null && this.areValuesMatched(colValue, ((Condition)st).getOp(), ((Condition)st).getValue());
                                break block5;
                            }
                            colValue = trow.getColumnValue(((Condition)st).getColumnName());
                            boolean bl = condition2Matched = colValue != null && this.areValuesMatched(colValue, ((Condition)st).getOp(), ((Condition)st).getValue());
                            if (nextJoin != Join.and) break block6;
                            condition1Matched = condition1Matched && condition2Matched;
                            break block5;
                        }
                        if (nextJoin != Join.or) break block5;
                        condition1Matched = condition1Matched || condition2Matched;
                        break block5;
                    }
                    if (st instanceof Join) {
                        nextJoin = (Join)((Object)st);
                        continue;
                    }
                }
                if (filter.size() != 1 || condition1Matched) continue;
                break;
            }
            if (!condition1Matched) continue;
            tableRows.add(trow);
        }
        return tableRows;
    }

    private boolean areValuesMatched(String value1, Operator op, String value2) {
        boolean matched = false;
        switch (op) {
            case eq: {
                if (value1.equals("") && value2.equals("")) {
                    matched = true;
                    break;
                }
                if (value1.equals("") || value2.equals("")) {
                    matched = false;
                    break;
                }
                try {
                    matched = Double.parseDouble(value1) == Double.parseDouble(value2);
                }
                catch (Exception ex) {
                    matched = value1.equals(value2);
                }
                break;
            }
            case ne: {
                if (value1.equals("") && value2.equals("")) {
                    matched = false;
                    break;
                }
                if (value1.equals("") || value2.equals("")) {
                    matched = true;
                    break;
                }
                try {
                    matched = Double.parseDouble(value1) != Double.parseDouble(value2);
                }
                catch (Exception ex) {
                    matched = !value1.equals(value2);
                }
                break;
            }
            case gt: {
                if (value1.equals("") && value2.equals("")) {
                    matched = true;
                    break;
                }
                if (value1.equals("") || value2.equals("")) {
                    matched = false;
                    break;
                }
                matched = Double.parseDouble(value1) > Double.parseDouble(value2);
                break;
            }
            case gte: {
                if (value1.equals("") && value2.equals("")) {
                    matched = true;
                    break;
                }
                if (value1.equals("") || value2.equals("")) {
                    matched = false;
                    break;
                }
                matched = Double.parseDouble(value1) >= Double.parseDouble(value2);
                break;
            }
            case lt: {
                if (value1.equals("") && value2.equals("")) {
                    matched = true;
                    break;
                }
                if (value1.equals("") || value2.equals("")) {
                    matched = false;
                    break;
                }
                matched = Double.parseDouble(value1) < Double.parseDouble(value2);
                break;
            }
            case lte: {
                if (value1.equals("") && value2.equals("")) {
                    matched = true;
                    break;
                }
                if (value1.equals("") || value2.equals("")) {
                    matched = false;
                    break;
                }
                matched = Double.parseDouble(value1) <= Double.parseDouble(value2);
                break;
            }
            case startsWith: {
                matched = value1.startsWith(value2);
                break;
            }
            case dontStartsWith: {
                matched = !value1.startsWith(value2);
                break;
            }
            case contains: {
                matched = value1.contains(value2);
                break;
            }
            case dontContains: {
                matched = !value1.contains(value2);
                break;
            }
            case endsWith: {
                matched = value1.endsWith(value2);
                break;
            }
            case dontEndsWith: {
                matched = !value1.endsWith(value2);
                break;
            }
        }
        return matched;
    }

    public String toString() {
        String str = "Table Name: " + this.tableName + "\n" + this.columnNames + "\n";
        for (List<String> row : this.rows) {
            str = str + row + "\n";
        }
        return str;
    }
}

