/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.objects;

import com.google.common.base.Function;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.MultiTouchAction;
import io.appium.java_client.PerformsTouchActions;
import io.appium.java_client.TouchAction;
import java.time.Duration;
import java.util.List;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.interactions.MoveTargetOutOfBoundsException;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.config.PlatformType;
import org.uitnet.testing.smartfwk.ui.core.objects.DOMObject;
import org.uitnet.testing.smartfwk.ui.core.objects.NewTextLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.UIObjectValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.scrollbar.Scrollbar;
import org.uitnet.testing.smartfwk.ui.core.utils.LocatorUtil;
import org.uitnet.testing.smartfwk.ui.core.utils.PageScrollUtil;
import org.uitnet.testing.smartfwk.ui.core.utils.WebElementUtil;

public class DOMObjectValidator
extends UIObjectValidator {
    private DOMObject domObject;

    public DOMObjectValidator(SmartAppDriver appDriver, DOMObject domObject, Region region) {
        super(appDriver, domObject, region);
        this.domObject = domObject;
    }

    @Override
    public DOMObject getUIObject() {
        return this.domObject;
    }

    public String getAttributeValue(String attributeName, int numRetries) {
        try {
            WebElement webElem = this.findElement(numRetries);
            return webElem.getAttribute(attributeName);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to get attribute (name='" + attributeName + "') value for element '" + this.domObject.getDisplayName() + "'."), (Throwable)th);
            return null;
        }
    }

    public String getAttributeValueWhenElementVisible(String attributeName, int numRetries) {
        try {
            for (int i = 0; i <= numRetries; ++i) {
                block6: {
                    try {
                        if (this.isVisible(0)) {
                            return this.getAttributeValue(attributeName, 0);
                        }
                        Assert.fail((String)"Element is not visible.");
                    }
                    catch (Throwable th) {
                        if (i != numRetries) break block6;
                        throw th;
                    }
                }
                this.appDriver.waitForSeconds(2);
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to get attribute '" + attributeName + "' value from visible element '" + this.domObject.getDisplayName() + "'."), (Throwable)th);
        }
        return null;
    }

    public String getAttributeValueWhenAttributeValueNonEmpty(String attributeName, int numRetries) {
        try {
            for (int i = 0; i <= numRetries; ++i) {
                block6: {
                    try {
                        String value = this.getAttributeValue(attributeName, 0);
                        if (value != null && !"".equals(value.trim())) {
                            return value;
                        }
                        Assert.fail((String)"Attribute value is empty.");
                    }
                    catch (Throwable th) {
                        if (i != numRetries) break block6;
                        throw th;
                    }
                }
                this.appDriver.waitForSeconds(2);
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to get non-empty attribute '" + attributeName + "' value from element '" + this.domObject.getDisplayName() + "'."), (Throwable)th);
        }
        return null;
    }

    public WebElement findElement(int numRetries) {
        WebElement webElem = null;
        for (int i = 0; i <= numRetries; ++i) {
            try {
                webElem = LocatorUtil.findWebElement(this.appDriver.getWebDriver(), this.domObject.getLocator(this.appDriver.getAppConfig().getTestPlatformType(), this.appDriver.getAppConfig().getAppType(), this.appDriver.getAppConfig().getAppWebBrowser()));
                Assert.assertNotNull((Object)webElem, (String)("Unable to find element '" + this.domObject.getDisplayName() + "'."));
                if (this.appDriver.getScrollElementToViewportHandler() == null) break;
                this.appDriver.getScrollElementToViewportHandler().handle(this.appDriver, webElem);
                break;
            }
            catch (Throwable th) {
                if (i == numRetries) {
                    Assert.fail((String)("Unable to find element '" + this.domObject.getDisplayName() + "'. Reason timeout(waited for " + numRetries * 2 + " seconds)."), (Throwable)th);
                    break;
                }
                this.appDriver.waitForSeconds(2);
                continue;
            }
        }
        return webElem;
    }

    public void waitForPageLoad() {
        WebDriverWait wait = new WebDriverWait(this.appDriver.getWebDriver(), Duration.ofSeconds(30L));
        wait.until((java.util.function.Function)new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                String readyState = String.valueOf(((JavascriptExecutor)DOMObjectValidator.this.appDriver.getWebDriver()).executeScript("return document.readyState", new Object[0]));
                return "complete".equals(readyState);
            }
        });
    }

    public WebElement findElementNoException(int numRetries) {
        WebElement webElem = null;
        for (int i = 0; i <= numRetries; ++i) {
            try {
                webElem = LocatorUtil.findWebElement(this.appDriver.getWebDriver(), this.domObject.getLocator(this.appDriver.getAppConfig().getTestPlatformType(), this.appDriver.getAppConfig().getAppType(), this.appDriver.getAppConfig().getAppWebBrowser()));
                if (webElem != null) {
                    if (this.appDriver.getScrollElementToViewportHandler() == null) break;
                    this.appDriver.getScrollElementToViewportHandler().handle(this.appDriver, webElem);
                    break;
                }
                Assert.fail();
            }
            catch (Throwable th) {
                webElem = null;
                if (i == numRetries) break;
            }
            this.appDriver.waitForSeconds(2);
        }
        return webElem;
    }

    @Override
    public List<WebElement> findElements(int numRetries) {
        List<WebElement> webElems = null;
        for (int i = 0; i <= numRetries; ++i) {
            try {
                webElems = LocatorUtil.findWebElements(this.appDriver.getWebDriver(), this.domObject.getLocator(this.appDriver.getAppConfig().getTestPlatformType(), this.appDriver.getAppConfig().getAppType(), this.appDriver.getAppConfig().getAppWebBrowser()));
                Assert.assertNotNull(webElems, (String)("Unable to find elements for '" + this.domObject.getDisplayName() + "'."));
                Assert.assertTrue((webElems.size() > 0 ? 1 : 0) != 0, (String)("Unable to find elements for '" + this.domObject.getDisplayName() + "' locator."));
                break;
            }
            catch (Throwable th) {
                if (i == numRetries) {
                    Assert.fail((String)("Unable to find elements for '" + this.uiObject.getDisplayName() + "' locator. Reason timeout(waited for " + numRetries * 2 + " seconds)."), (Throwable)th);
                    break;
                }
                this.appDriver.waitForSeconds(2);
                continue;
            }
        }
        return webElems;
    }

    @Override
    public DOMObjectValidator scrollElementOnViewport(Scrollbar scrollbar) {
        if (scrollbar == null) {
            return this;
        }
        scrollbar.scrollElementToViewport(this.appDriver, this.getUIObject());
        return this;
    }

    @Override
    public boolean isPresent(int numRetries) {
        boolean elemPresent = false;
        WebElement webElem = null;
        for (int i = 0; i <= numRetries; ++i) {
            try {
                webElem = LocatorUtil.findWebElement(this.appDriver.getWebDriver(), this.domObject.getLocator(this.appDriver.getAppConfig().getTestPlatformType(), this.appDriver.getAppConfig().getAppType(), this.appDriver.getAppConfig().getAppWebBrowser()));
                if (webElem != null) {
                    elemPresent = true;
                    break;
                }
                Assert.fail();
            }
            catch (Throwable th) {
                if (i == numRetries) break;
            }
            this.appDriver.waitForSeconds(2);
        }
        return elemPresent;
    }

    @Override
    public boolean isVisible(int numRetries) {
        boolean elemVisible = false;
        for (int i = 0; i <= numRetries; ++i) {
            try {
                if (WebElementUtil.isElementVisible(this.appDriver, this.domObject)) {
                    elemVisible = true;
                    break;
                }
                Assert.fail();
            }
            catch (Throwable th) {
                if (i == numRetries) break;
            }
            this.appDriver.waitForSeconds(2);
        }
        return elemVisible;
    }

    public boolean isReadonly(int numRetries) {
        boolean elemReadonly = false;
        for (int i = 0; i <= numRetries; ++i) {
            try {
                if (WebElementUtil.isElementReadonly(this.appDriver, this.domObject)) {
                    elemReadonly = true;
                    break;
                }
                Assert.fail();
            }
            catch (Throwable th) {
                if (i == numRetries) break;
            }
            this.appDriver.waitForSeconds(2);
        }
        return elemReadonly;
    }

    public boolean isDisabled(int numRetries) {
        boolean elemDisabled = false;
        for (int i = 0; i <= numRetries; ++i) {
            try {
                if (WebElementUtil.isElementDisabled(this.appDriver, this.domObject)) {
                    elemDisabled = true;
                    break;
                }
                Assert.fail();
            }
            catch (Throwable th) {
                if (i == numRetries) break;
            }
            this.appDriver.waitForSeconds(2);
        }
        return elemDisabled;
    }

    public boolean isDisabledButNotReadonly(int numRetries) {
        boolean elemDisabled = false;
        for (int i = 0; i <= numRetries; ++i) {
            try {
                if (WebElementUtil.isElementDisabledButNotReadonly(this.appDriver, this.domObject)) {
                    elemDisabled = true;
                    break;
                }
                Assert.fail();
            }
            catch (Throwable th) {
                if (i == numRetries) break;
            }
            this.appDriver.waitForSeconds(2);
        }
        return elemDisabled;
    }

    public boolean isSelected(int numRetries) {
        boolean elemSelected = false;
        for (int i = 0; i <= numRetries; ++i) {
            try {
                if (WebElementUtil.isElementSelected(this.appDriver, this.domObject)) {
                    elemSelected = true;
                    break;
                }
                Assert.fail();
            }
            catch (Throwable th) {
                if (i == numRetries) break;
            }
            this.appDriver.waitForSeconds(2);
        }
        return elemSelected;
    }

    public String getText(int numRetries) {
        try {
            return WebElementUtil.getElementText(this.appDriver, this.domObject, numRetries);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to get text from element '" + this.domObject.getDisplayName() + "'."), (Throwable)th);
            return null;
        }
    }

    public String getTextWhenElementVisible(int numRetries) {
        try {
            for (int i = 0; i <= numRetries; ++i) {
                block6: {
                    try {
                        if (this.isVisible(0)) {
                            return this.getText(0);
                        }
                        Assert.fail((String)"Text is not visible.");
                    }
                    catch (Throwable th) {
                        if (i != numRetries) break block6;
                        throw th;
                    }
                }
                this.appDriver.waitForSeconds(2);
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to get text from visible element '" + this.domObject.getDisplayName() + "'."), (Throwable)th);
        }
        return null;
    }

    public String getTextWhenElementValueNonEmpty(int numRetries) {
        try {
            for (int i = 0; i <= numRetries; ++i) {
                block7: {
                    try {
                        if (this.isVisible(0)) {
                            String value = this.getText(0);
                            if (value != null && !"".equals(value.trim())) {
                                return value;
                            }
                            Assert.fail((String)"Text is empty.");
                        }
                        Assert.fail((String)"Text is not visible.");
                    }
                    catch (Throwable th) {
                        if (i != numRetries) break block7;
                        throw th;
                    }
                }
                this.appDriver.waitForSeconds(2);
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to get non-empty text from visible element '" + this.domObject.getDisplayName() + "'."), (Throwable)th);
        }
        return null;
    }

    public void validatePresentWithNonEmptyText(int numRetries) {
        try {
            for (int i = 0; i <= numRetries; ++i) {
                block7: {
                    try {
                        if (this.isVisible(0)) {
                            String value = this.getText(0);
                            if (value != null && !"".equals(value.trim())) {
                                return;
                            }
                            Assert.fail((String)"Text is empty.");
                        }
                        Assert.fail((String)"Text is not visible.");
                    }
                    catch (Throwable th) {
                        if (i != numRetries) break block7;
                        throw th;
                    }
                }
                this.appDriver.waitForSeconds(2);
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Element '" + this.domObject.getDisplayName() + "' is not visible with non-empty text."), (Throwable)th);
        }
    }

    public void copyTextToClipboard(int numRetries) {
        try {
            for (int i = 0; i < 5; ++i) {
                try {
                    WebElement webElem = this.findElement(numRetries);
                    PageScrollUtil.mouseClick(this.appDriver, webElem);
                    Actions webActions = new Actions(this.appDriver.getWebDriver());
                    webActions.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"})}).sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "c"})});
                    break;
                }
                catch (ElementNotVisibleException | MoveTargetOutOfBoundsException ex) {
                    this.appDriver.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to copy contents into clipboard. Element '" + this.domObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    public void pasteTextFromClipboard(int numRetries) {
        try {
            for (int i = 0; i < 5; ++i) {
                try {
                    WebElement webElem = this.findElement(numRetries);
                    PageScrollUtil.mouseClick(this.appDriver, webElem);
                    Actions webActions = new Actions(this.appDriver.getWebDriver());
                    webActions.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"})}).sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "v"})}).build().perform();
                    break;
                }
                catch (ElementNotVisibleException | MoveTargetOutOfBoundsException ex) {
                    this.appDriver.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to paste clipboard contents into field '" + this.domObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void click(int numRetries) {
        try {
            for (int i = 0; i < 5; ++i) {
                try {
                    WebElement webElem = this.findElement(numRetries);
                    PageScrollUtil.mouseClick(this.appDriver, webElem);
                    break;
                }
                catch (ElementNotVisibleException | MoveTargetOutOfBoundsException ex) {
                    this.appDriver.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse click on element '" + this.domObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void doubleClick(int numRetries) {
        try {
            for (int i = 0; i < 5; ++i) {
                try {
                    WebElement webElem = this.findElement(numRetries);
                    PageScrollUtil.mouseDoubleClick(this.appDriver, webElem);
                    break;
                }
                catch (ElementNotVisibleException | MoveTargetOutOfBoundsException ex) {
                    this.appDriver.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse double click on element '" + this.domObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void rightClick(int numRetries) {
        try {
            WebElement webElem = this.findElement(numRetries);
            Point location = webElem.getLocation();
            Dimension size = webElem.getSize();
            this.appDriver.getSikuliScreen().rightClick((Object)new Region(location.getX(), location.getY(), size.getWidth(), size.getHeight()));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse right click on element '" + this.domObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void clickAndHold(int numRetries) {
        for (int i = 0; i < 5; ++i) {
            try {
                WebElement webElem = this.findElement(numRetries);
                PageScrollUtil.mouseClickAndHold(this.appDriver, webElem);
                break;
            }
            catch (ElementNotVisibleException | MoveTargetOutOfBoundsException ex) {
                this.appDriver.waitForSeconds(2);
                continue;
            }
        }
    }

    @Override
    public void release(int numRetries) {
        for (int i = 0; i < 5; ++i) {
            try {
                WebElement webElem = this.findElement(numRetries);
                PageScrollUtil.mouseRelease(this.appDriver, webElem);
                break;
            }
            catch (ElementNotVisibleException | MoveTargetOutOfBoundsException ex) {
                this.appDriver.waitForSeconds(2);
                continue;
            }
        }
    }

    public void dragAndDrop(DOMObject target, int numRetries) {
        try {
            for (int i = 0; i < 5; ++i) {
                try {
                    WebElement sourceElem = this.findElement(numRetries);
                    WebElement targetElem = target.getValidator(this.appDriver, this.region).findElement(numRetries);
                    PageScrollUtil.mouseDragAndDrop(this.appDriver, sourceElem, targetElem);
                    break;
                }
                catch (ElementNotVisibleException | MoveTargetOutOfBoundsException ex) {
                    this.appDriver.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform dragAndDrop from source '" + this.domObject.getDisplayName() + "' to target '" + target.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void performKeyDown(Keys keys, int numRetries) {
        for (int i = 0; i < 5; ++i) {
            try {
                WebElement webElem = this.findElement(numRetries);
                Actions actions = new Actions(this.appDriver.getWebDriver());
                actions.keyDown(webElem, (CharSequence)keys).build().perform();
                break;
            }
            catch (ElementNotVisibleException | MoveTargetOutOfBoundsException ex) {
                this.appDriver.waitForSeconds(2);
                continue;
            }
        }
    }

    @Override
    public void performKeyUp(Keys keys, int numRetries) {
        for (int i = 0; i < 5; ++i) {
            try {
                WebElement webElem = this.findElement(numRetries);
                Actions actions = new Actions(this.appDriver.getWebDriver());
                actions.keyUp(webElem, (CharSequence)keys).build().perform();
                break;
            }
            catch (ElementNotVisibleException | MoveTargetOutOfBoundsException ex) {
                this.appDriver.waitForSeconds(2);
                continue;
            }
        }
    }

    @Override
    public void performKeyPressed(Keys keys, int numRetries) {
        for (int i = 0; i < 5; ++i) {
            try {
                WebElement webElem = this.findElement(numRetries);
                Actions actions = new Actions(this.appDriver.getWebDriver());
                actions.keyDown(webElem, (CharSequence)keys).keyUp(webElem, (CharSequence)keys).build().perform();
                break;
            }
            catch (ElementNotVisibleException | MoveTargetOutOfBoundsException ex) {
                this.appDriver.waitForSeconds(2);
                continue;
            }
        }
    }

    @Override
    public void typeText(String text, NewTextLocation location, int numRetries) {
        for (int i = 0; i < 5; ++i) {
            try {
                WebElement webElem = this.findElement(numRetries);
                switch (location) {
                    case start: {
                        String newtext = text;
                        Actions actions = new Actions(this.appDriver.getWebDriver());
                        webElem.sendKeys(new CharSequence[]{Keys.HOME});
                        actions.sendKeys(webElem, new CharSequence[]{newtext}).build().perform();
                        break;
                    }
                    case end: {
                        String newtext = text;
                        Actions actions = new Actions(this.appDriver.getWebDriver());
                        webElem.sendKeys(new CharSequence[]{Keys.END});
                        actions.sendKeys(webElem, new CharSequence[]{newtext}).build().perform();
                        break;
                    }
                    case replace: {
                        webElem.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"})});
                        webElem.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
                        Actions actions = new Actions(this.appDriver.getWebDriver());
                        actions.sendKeys(webElem, new CharSequence[]{text}).build().perform();
                    }
                }
                break;
            }
            catch (ElementNotVisibleException | MoveTargetOutOfBoundsException ex) {
                this.appDriver.waitForSeconds(2);
                continue;
            }
        }
    }

    @Override
    public TouchAction getNewMobileTouchAction() {
        if (this.appDriver.getTestPlatformType() == PlatformType.ios_mobile || this.appDriver.getTestPlatformType() == PlatformType.android_mobile) {
            return new TouchAction((PerformsTouchActions)((AppiumDriver)this.appDriver.getWebDriver()));
        }
        return null;
    }

    @Override
    public MultiTouchAction getNewMobileMultiTouchAction() {
        if (this.appDriver.getTestPlatformType() == PlatformType.ios_mobile || this.appDriver.getTestPlatformType() == PlatformType.android_mobile) {
            return new MultiTouchAction((PerformsTouchActions)((AppiumDriver)this.appDriver.getWebDriver()));
        }
        return null;
    }

    @Override
    public Actions getNewSeleniumActions() {
        return new Actions(this.appDriver.getWebDriver());
    }
}

