/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.objects.scrollbar;

import org.sikuli.script.Match;
import org.sikuli.script.Region;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;

public class VerticalScrollbar {
    private static Logger logger = LoggerFactory.getLogger(VerticalScrollbar.class);
    protected String thumbGripTopPartImage;
    protected String thumbGripTopPartImageFocused;
    protected String thumbGripBottomPartImage;
    protected String thumbGripBottomPartImageFocused;
    protected String topScrollImageEnabled;
    protected String topScrollImageEnabledFocused;
    protected String bottomScrollImageEnabled;
    protected String bottomScrollImageEnabledFocused;
    protected String topScrollImageDisabled;
    protected String bottomScrollImageDisabled;

    public VerticalScrollbar(String thumbGripTopPartImage, String thumbGripTopPartImageFocused, String thumbGripBottomPartImage, String thumbGripBottomPartImageFocused, String topScrollImageEnabled, String topScrollImageEnabledFocused, String bottomScrollImageEnabled, String bottomScrollImageEnabledFocused, String topScrollImageDisabled, String bottomScrollImageDisabled) {
        this.thumbGripTopPartImage = thumbGripTopPartImage;
        this.thumbGripTopPartImageFocused = thumbGripTopPartImageFocused;
        this.thumbGripBottomPartImage = thumbGripBottomPartImage;
        this.thumbGripBottomPartImageFocused = thumbGripBottomPartImageFocused;
        this.topScrollImageEnabled = topScrollImageEnabled;
        this.topScrollImageEnabledFocused = topScrollImageEnabledFocused;
        this.bottomScrollImageEnabled = bottomScrollImageEnabled;
        this.bottomScrollImageEnabledFocused = bottomScrollImageEnabledFocused;
        this.topScrollImageDisabled = topScrollImageDisabled;
        this.bottomScrollImageDisabled = bottomScrollImageDisabled;
    }

    public boolean isThumbGripTopPartImageVisible(Region region) {
        Match thumbGripFound2;
        try {
            thumbGripFound2 = region.find((Object)this.thumbGripTopPartImage);
            if (thumbGripFound2 != null) {
                return true;
            }
        }
        catch (Throwable thumbGripFound2) {
            // empty catch block
        }
        try {
            thumbGripFound2 = region.find((Object)this.thumbGripTopPartImageFocused);
            if (thumbGripFound2 != null) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public boolean isThumbGripBottomPartImageVisible(Region region) {
        Match thumbGripFound2;
        try {
            thumbGripFound2 = region.find((Object)this.thumbGripBottomPartImage);
            if (thumbGripFound2 != null) {
                return true;
            }
        }
        catch (Throwable thumbGripFound2) {
            // empty catch block
        }
        try {
            thumbGripFound2 = region.find((Object)this.thumbGripBottomPartImageFocused);
            if (thumbGripFound2 != null) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public boolean isTopScrollImageVisible(Region region) {
        Match bottomScrollFound2;
        try {
            bottomScrollFound2 = region.find((Object)this.topScrollImageEnabled);
            if (bottomScrollFound2 != null) {
                return true;
            }
        }
        catch (Throwable bottomScrollFound2) {
            // empty catch block
        }
        try {
            bottomScrollFound2 = region.find((Object)this.topScrollImageEnabledFocused);
            if (bottomScrollFound2 != null) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public boolean isBottomScrollImageVisible(Region region) {
        Match bottomScrollFound2;
        try {
            bottomScrollFound2 = region.find((Object)this.bottomScrollImageEnabled);
            if (bottomScrollFound2 != null) {
                return true;
            }
        }
        catch (Throwable bottomScrollFound2) {
            // empty catch block
        }
        try {
            bottomScrollFound2 = region.find((Object)this.bottomScrollImageEnabledFocused);
            if (bottomScrollFound2 != null) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public Match findThumbGripTopPartImage(Region region) {
        Match match2;
        try {
            match2 = region.find((Object)this.thumbGripTopPartImage);
            if (match2 != null) {
                return match2;
            }
        }
        catch (Throwable match2) {
            // empty catch block
        }
        try {
            match2 = region.find((Object)this.thumbGripTopPartImageFocused);
            if (match2 != null) {
                return match2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public Match findThumbGripBottomPartImage(Region region) {
        Match match2;
        try {
            match2 = region.find((Object)this.thumbGripBottomPartImage);
            if (match2 != null) {
                return match2;
            }
        }
        catch (Throwable match2) {
            // empty catch block
        }
        try {
            match2 = region.find((Object)this.thumbGripBottomPartImageFocused);
            if (match2 != null) {
                return match2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public Match findTopScrollImage(Region region) {
        Match match2;
        try {
            match2 = region.find((Object)this.topScrollImageEnabled);
            if (match2 != null) {
                return match2;
            }
        }
        catch (Throwable match2) {
            // empty catch block
        }
        try {
            match2 = region.find((Object)this.topScrollImageEnabledFocused);
            if (match2 != null) {
                return match2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public Match findBottomScrollImage(Region region) {
        Match match2;
        try {
            match2 = region.find((Object)this.bottomScrollImageEnabled);
            if (match2 != null) {
                return match2;
            }
        }
        catch (Throwable match2) {
            // empty catch block
        }
        try {
            match2 = region.find((Object)this.bottomScrollImageEnabledFocused);
            if (match2 != null) {
                return match2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public boolean isFullScrollbarVisible(Region region) {
        try {
            if (this.isTopScrollImageVisible(region) && this.isBottomScrollImageVisible(region)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public void validateFullScrollbarVisible(Region region) {
        Assert.assertTrue((this.isTopScrollImageVisible(region) && this.isBottomScrollImageVisible(region) ? 1 : 0) != 0, (String)"Full horizontal scrollbar is not visible.");
    }

    public boolean isScrollbarDisabled(Region region) {
        Match found;
        try {
            found = region.find((Object)this.topScrollImageDisabled);
            if (found != null) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            found = region.find((Object)this.bottomScrollImageDisabled);
            if (found != null) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public void validateScrollbarDisabled(Region region) {
        Assert.assertTrue((boolean)this.isScrollbarDisabled(region), (String)"Horizontal scrollbar is not disabled.");
    }

    private boolean isImagesCollidedVertically(Match m1, Match m2) {
        if (m1 == null || m2 == null) {
            return false;
        }
        double p1 = m1.getRect().getY() + m1.getRect().getHeight();
        double p2 = m2.getRect().getY();
        if (p2 - p1 <= 5.0) {
            return true;
        }
        p1 = m2.getRect().getY() + m2.getRect().getHeight();
        return p1 - (p2 = m1.getRect().getY()) <= 5.0;
    }

    public boolean clickTopScrollImage(Region region, int times) {
        try {
            Match found = this.findTopScrollImage(region);
            if (found != null) {
                for (int i = 0; i < times; ++i) {
                    found.click();
                }
                Match thumbGripTopPartImgFound = this.findThumbGripTopPartImage(region);
                return this.isImagesCollidedVertically(found, thumbGripTopPartImgFound);
            }
            logger.error("Error during clickTopScrollImage.");
            Assert.fail((String)"Error during clickTopScrollImage.");
        }
        catch (Throwable th) {
            logger.error("Error during clickTopScrollImage.", th);
            Assert.fail((String)"Error during clickTopScrollImage.", (Throwable)th);
        }
        return false;
    }

    public boolean clickBottomScrollImage(Region region, int times) {
        try {
            Match found = this.findBottomScrollImage(region);
            if (found != null) {
                for (int i = 0; i < times; ++i) {
                    found.click();
                }
                Match thumbGripBottomPartImgFound = this.findThumbGripBottomPartImage(region);
                return this.isImagesCollidedVertically(thumbGripBottomPartImgFound, found);
            }
        }
        catch (Throwable th) {
            logger.error("Error during clickBottomScrollImage.", th);
            Assert.fail((String)"Error during clickBottomScrollImage.", (Throwable)th);
        }
        return false;
    }

    public void scrollThumbGripToExtremeTop(Region region) {
        try {
            Match thumbGripTopPartImageFound = this.findThumbGripTopPartImage(region);
            Match topScrollImageEnabledFound = this.findTopScrollImage(region);
            if (thumbGripTopPartImageFound != null && topScrollImageEnabledFound != null) {
                thumbGripTopPartImageFound.drag((Object)thumbGripTopPartImageFound);
                thumbGripTopPartImageFound.dropAt((Object)topScrollImageEnabledFound);
                System.out.println("AA");
            } else if (topScrollImageEnabledFound != null) {
                do {
                    topScrollImageEnabledFound.click();
                } while ((thumbGripTopPartImageFound = this.findThumbGripTopPartImage(region)) == null);
                thumbGripTopPartImageFound.drag((Object)thumbGripTopPartImageFound);
                thumbGripTopPartImageFound.dropAt((Object)topScrollImageEnabledFound);
            }
        }
        catch (Throwable th) {
            logger.error("Error during scrollThumbGripToExtremeTop.", th);
            Assert.fail((String)"Error during scrollThumbGripToExtremeTop.", (Throwable)th);
        }
    }

    public void scrollThumbGripToExtremeBottom(Region region) {
        try {
            Match thumbGripBottomPartImageFound = this.findThumbGripBottomPartImage(region);
            Match bottomScrollImageEnabledFound = this.findBottomScrollImage(region);
            if (thumbGripBottomPartImageFound != null && bottomScrollImageEnabledFound != null) {
                thumbGripBottomPartImageFound.drag((Object)thumbGripBottomPartImageFound);
                thumbGripBottomPartImageFound.dropAt((Object)bottomScrollImageEnabledFound);
            } else if (bottomScrollImageEnabledFound != null) {
                do {
                    bottomScrollImageEnabledFound.click();
                } while ((thumbGripBottomPartImageFound = this.findThumbGripBottomPartImage(region)) == null);
                thumbGripBottomPartImageFound.drag((Object)thumbGripBottomPartImageFound);
                thumbGripBottomPartImageFound.dropAt((Object)bottomScrollImageEnabledFound);
            }
        }
        catch (Throwable th) {
            logger.error("Error during scrollThumbGripToExtremeBottom.", th);
            Assert.fail((String)"Error during scrollThumbGripToExtremeBottom.", (Throwable)th);
        }
    }
}

