/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.standard.imgobj;

import io.appium.java_client.MultiTouchAction;
import io.appium.java_client.TouchAction;
import java.util.List;
import org.openqa.selenium.Keys;
import org.openqa.selenium.interactions.Actions;
import org.sikuli.script.Button;
import org.sikuli.script.Location;
import org.sikuli.script.Match;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.commons.ImageSection;
import org.uitnet.testing.smartfwk.ui.core.commons.UIObjectType;
import org.uitnet.testing.smartfwk.ui.core.objects.ImageObject;
import org.uitnet.testing.smartfwk.ui.core.objects.NewTextLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.radio.RadioButtonValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.scrollbar.Scrollbar;
import org.uitnet.testing.smartfwk.ui.standard.imgobj.RadioButtonSI;

public class RadioButtonValidatorSI
extends RadioButtonValidator {
    protected RadioButtonSI rbObject;

    public RadioButtonValidatorSI(SmartAppDriver appDriver, RadioButtonSI uiObject, Region region) {
        super(appDriver, uiObject, region);
        this.rbObject = uiObject;
    }

    @Override
    public boolean isPresent(int numRetries) {
        Match m = this.findElementNoException(numRetries);
        return m != null;
    }

    @Override
    public boolean isVisible(int numRetries) {
        return this.isPresent(numRetries);
    }

    @Override
    public void click(int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.click();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse click on RadioButton '" + this.rbObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    public void click(ImageSection imageSection, int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            this.getImageSection(match, imageSection).click();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse click on RadioButton '" + this.rbObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void doubleClick(int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.doubleClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse double click on RadioButton '" + this.rbObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    public void doubleClick(ImageSection imageSection, int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            this.getImageSection(match, imageSection).doubleClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse double click on RadioButton '" + this.rbObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void rightClick(int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.rightClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse right click on RadioButton '" + this.rbObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    public void rightClick(ImageSection imageSection, int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            this.getImageSection(match, imageSection).rightClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse right click on RadioButton '" + this.rbObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void clickAndHold(int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.mouseDown(Button.LEFT);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse clickAndHold on RadioButton '" + this.rbObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void release(int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.mouseDown(Button.LEFT);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse clickAndHold on RadioButton '" + this.rbObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void performKeyDown(Keys keys, int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.click();
            match.keyDown(this.seleniumToSikuliKeyConverter(keys));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform keyDown on RadioButton '" + this.rbObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void performKeyUp(Keys keys, int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.click();
            match.keyUp(this.seleniumToSikuliKeyConverter(keys));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform keyUp ('" + this.seleniumToSikuliKeyConverter(keys) + "') on RadioButton '" + this.rbObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void performKeyPressed(Keys keys, int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.click();
            match.keyDown(this.seleniumToSikuliKeyConverter(keys));
            match.keyUp(this.seleniumToSikuliKeyConverter(keys));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform keyPressed ('" + this.seleniumToSikuliKeyConverter(keys) + "') on RadioButton '" + this.rbObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    @Deprecated
    public void typeText(String text, NewTextLocation location, int numRetries) {
        Assert.fail((String)"typeText() API is not supported for RadioButton element.");
    }

    @Override
    public RadioButtonValidatorSI scrollElementOnViewport(Scrollbar scrollbar) {
        return this;
    }

    public Match findElement(int numRetries) {
        Match match = null;
        for (int i = 0; i <= numRetries; ++i) {
            try {
                Region region = this.rbObject.getRadioButtonImageLocation().getRegionOfImageObject(this.appDriver, this.rbObject.getRadioButtonImage());
                Assert.assertNotNull((Object)region, (String)("Failed to find RadioButton '" + this.rbObject.getDisplayName() + "'."));
                match = new Match(region, 1.0);
                break;
            }
            catch (Throwable th) {
                if (i == numRetries) {
                    Assert.fail((String)("Unable to find RadioButton '" + this.rbObject.getDisplayName() + "'. Reason timeout(waited for " + numRetries * 2 + " seconds)."), (Throwable)th);
                    break;
                }
                this.appDriver.waitForSeconds(2);
                continue;
            }
        }
        return match;
    }

    public Match findElementNoException(int numRetries) {
        Match match = null;
        try {
            match = this.findElement(numRetries);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return match;
    }

    @Override
    public List<Match> findElements(int numRetries) {
        Region r = this.rbObject.getRadioButtonImageLocation().getRegion(this.appDriver);
        return new ImageObject(UIObjectType.radioButton, this.rbObject.getDisplayName(), this.rbObject.getRadioButtonImage()).getValidator(this.appDriver, r).findElements(numRetries);
    }

    public void dragAndDrop(ImageObject target, Region targetRegion, int numRetries) {
        try {
            Match sourceElem = this.findElement(numRetries);
            Match targetElem = target.getValidator(this.appDriver, targetRegion).findElement(numRetries);
            Assert.assertNotNull((Object)sourceElem, (String)("Failed to find RadioButton '" + this.rbObject.getDisplayName() + "'."));
            Assert.assertNotNull((Object)targetElem, (String)("Failed to find element '" + target.getDisplayName() + "'."));
            sourceElem.drag((Object)targetElem);
            sourceElem.dropAt((Object)targetElem);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform dragAndDrop from source '" + this.rbObject.getDisplayName() + "' to target '" + target.getDisplayName() + "'."), (Throwable)th);
        }
    }

    protected Location getImageSection(Match imageMatch, ImageSection imageSection) {
        switch (imageSection) {
            case topLeft: {
                return imageMatch.getTopLeft();
            }
            case topRight: {
                return imageMatch.getTopRight();
            }
            case bottomLeft: {
                return imageMatch.getBottomLeft();
            }
            case bottomRight: {
                return imageMatch.getBottomRight();
            }
            case center: {
                return imageMatch.getCenter();
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public void validateDisabled(int numRetries) {
        Assert.fail((String)"validateDisabled() is not supported for RadioButton component.");
    }

    @Override
    @Deprecated
    public void validateEnabled(int numRetries) {
        Assert.fail((String)"validateEnabled() is not supported for RadioButton component.");
    }

    @Override
    public void select(int numRetries) {
        this.click(numRetries);
    }

    @Override
    @Deprecated
    public void validateSelected(int numRetries) {
        Assert.fail((String)"validateEnabled() is not supported for RadioButton component.");
    }

    @Override
    @Deprecated
    public void validateNotSelected(int numRetries) {
        Assert.fail((String)"validateEnabled() is not supported for RadioButton component.");
    }

    @Override
    public boolean isDisabled(int numRetries) {
        Assert.fail((String)"isDisabled() API is not supported by RadioButton component.");
        return false;
    }

    @Override
    @Deprecated
    public TouchAction getNewMobileTouchAction() {
        Assert.fail((String)"getNewMobileTouchAction() API is not supported by RadioButton component.");
        return null;
    }

    @Override
    @Deprecated
    public MultiTouchAction getNewMobileMultiTouchAction() {
        Assert.fail((String)"getNewMobileMultiTouchAction() API is not supported by RadioButton component.");
        return null;
    }

    @Override
    @Deprecated
    public Actions getNewSeleniumActions() {
        Assert.fail((String)"getNewSeleniumActions() API is not supported by RadioButton component.");
        return null;
    }

    @Override
    public boolean isDisabledButNotReadonly(int numRetries) {
        Assert.fail((String)"validateEnabledButNotReadonly() API is not supported by RadioButton component.");
        return false;
    }

    @Override
    public void validateDisabledButNotReadonly(int numRetries) {
        Assert.fail((String)"validateEnabledButNotReadonly() API is not supported by RadioButton component.");
    }

    @Override
    public void validateEnabledButNotReadonly(int numRetries) {
        Assert.fail((String)"validateEnabledButNotReadonly() API is not supported by RadioButton component.");
    }
}

