/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.validator;

import java.text.SimpleDateFormat;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.objects.validator.mechanisms.TextMatchMechanism;
import org.uitnet.testing.smartfwk.ui.core.utils.DataMatchUtil;
import org.uitnet.testing.smartfwk.ui.core.utils.StringUtil;

public class FieldValidator {
    private FieldValidator() {
    }

    public static void validateFieldValueAsNull(String fieldName, Object actualValue) {
        Assert.assertNull((Object)actualValue, (String)("Field '" + fieldName + "' value should be null. Actual Value: " + actualValue));
    }

    public static void validateFieldValueAsNotNull(String fieldName, Object actualValue) {
        Assert.assertNotNull((Object)actualValue, (String)("Field '" + fieldName + "' value should not be null. Actual Value: " + actualValue));
    }

    public static void validateFieldValueAsEmpty(String fieldName, String actualValue) {
        Assert.assertTrue((boolean)StringUtil.isEmptyAfterTrim(actualValue), (String)("Field '" + fieldName + "' value should be empty. Actual Value: " + actualValue));
    }

    public static void validateFieldValueAsNonEmpty(String fieldName, String actualValue) {
        Assert.assertFalse((boolean)StringUtil.isEmptyAfterTrim(actualValue), (String)("Field '" + fieldName + "' value should not be empty. Actual Value: " + actualValue));
    }

    public static void validateFieldValueAsNumeric(String fieldName, String actualValue, boolean removeComma) {
        if (!StringUtil.isEmptyNoTrim(actualValue)) {
            try {
                String actualValue2 = removeComma ? actualValue.replaceAll(",", "") : actualValue;
                Double.parseDouble(actualValue2);
            }
            catch (Error | Exception e) {
                Assert.fail((String)("Field '" + fieldName + "' value should be numeric. Actual Value: " + actualValue));
            }
        }
    }

    public static void validateFieldValueAsNumericButNotDecimal(String fieldName, String actualValue, boolean removeComma) {
        if (!StringUtil.isEmptyNoTrim(actualValue)) {
            try {
                String actualValue2 = removeComma ? actualValue.replaceAll(",", "") : actualValue;
                Long.parseLong(actualValue2);
            }
            catch (Error | Exception e) {
                Assert.fail((String)("Field '" + fieldName + "' value should be non-decimal. Actual Value: " + actualValue));
            }
        }
    }

    public static void validateFieldValueAsNonNumeric(String fieldName, String actualValue, boolean removeComma) {
        if (!StringUtil.isEmptyNoTrim(actualValue)) {
            String actualValue2 = removeComma ? actualValue.replaceAll(",", "") : actualValue;
            Double.parseDouble(actualValue2);
            Assert.fail((String)("Field '" + fieldName + "' value should not be numeric. Actual Value: " + actualValue));
        }
    }

    public static void validateFieldValueAsExpectedValue(String fieldName, Object actualValue, Object expectedValue) {
        if (actualValue == null || expectedValue == null) {
            if (actualValue != expectedValue) {
                Assert.fail((String)("Field '" + fieldName + "' value is not matched with expected value. Actual Value: " + actualValue + ", Expected Value: " + expectedValue));
            }
        } else if (!("" + actualValue).equals("" + expectedValue)) {
            Assert.fail((String)("Field '" + fieldName + "' value is not matched with expected value. Actual Value: " + actualValue + ", Expected Value: " + expectedValue));
        }
    }

    public static void validateFieldValueAsExpectedValue(String fieldName, Object actualValue, Object expectedValue, TextMatchMechanism textMatchMechanism) {
        if (actualValue == null || expectedValue == null) {
            if (actualValue != expectedValue) {
                Assert.fail((String)("Field '" + fieldName + "' value is not matched with expected value. Actual Value: " + actualValue + ", Expected Value: " + expectedValue));
            }
        } else if (!DataMatchUtil.matchTextValue("" + actualValue, "" + expectedValue, textMatchMechanism)) {
            Assert.fail((String)("Field '" + fieldName + "' value is not matched with expected value. Actual Value: " + actualValue + ", Expected value: " + expectedValue + ", Text Match Mechanism: " + textMatchMechanism.name()));
        }
    }

    public static void validateFieldValueAsNotExpectedValue(String fieldName, Object actualValue, Object expectedValue) {
        if (actualValue == null || expectedValue == null) {
            if (actualValue == expectedValue) {
                Assert.fail((String)("Field '" + fieldName + "' value should not match with expected value. Actual Value: " + actualValue + ", Expected Value: " + expectedValue));
            }
        } else if (("" + actualValue).equals("" + expectedValue)) {
            Assert.fail((String)("Field '" + fieldName + "' value should not match with expected value. Actual Value: " + actualValue + ", Expected Value: " + expectedValue));
        }
    }

    public static void validateFieldValueAsExpectedDateTimeFormat(String fieldName, String actualValue, String expectedDateFormat) {
        try {
            if (!StringUtil.isEmptyAfterTrim(actualValue)) {
                SimpleDateFormat formatter = new SimpleDateFormat(expectedDateFormat);
                formatter.setLenient(true);
                formatter.parse(actualValue.trim());
            }
        }
        catch (Exception ex) {
            Assert.fail((String)("Field '" + fieldName + "' value (" + actualValue + ") is not in the expected format (" + expectedDateFormat + ")."));
        }
    }

    public static void validateFieldValueAsOfExpectedLength(String fieldName, Object actualValue, int expectedLength) {
        FieldValidator.validateFieldValueAsNotNull(fieldName, actualValue);
        Assert.assertEquals((int)("" + actualValue).length(), (int)expectedLength, (String)("Field '" + fieldName + "' value does not contain same number of character count as expected count. Actual count: " + ("" + actualValue).length() + ", Expected count: " + expectedLength + "."));
    }

    public static void validateFieldValueAsEmail(String fieldName, String actualValue) {
        String[] parts;
        FieldValidator.validateFieldValueAsNotNull(fieldName, actualValue);
        String actualValue2 = actualValue.trim();
        if (actualValue2.contains(" ")) {
            Assert.fail((String)("Field '" + fieldName + "' value is not a valid email. It should not contain whitespace. Actual value: " + actualValue));
        }
        if ((parts = actualValue2.split("@")).length < 2) {
            Assert.fail((String)("Field '" + fieldName + "' value is not a valid email. It does not contain domain part after '@' symbol. Actual value: " + actualValue));
        }
        if (parts.length > 2) {
            Assert.fail((String)("Field '" + fieldName + "' value is not a valid email. It contains multiple '@' symbols. Actual value: " + actualValue));
        }
        if (parts[0].length() == 0) {
            Assert.fail((String)("Field '" + fieldName + "' value is not a valid email. It does not contain left part before '@' symbol. Actual value: " + actualValue));
        }
        if (!parts[1].contains(".")) {
            Assert.fail((String)("Field '" + fieldName + "' value is not a valid email. It does not contain period(.) after '@' symbol. Actual value: " + actualValue));
        }
        if (parts[1].startsWith(".")) {
            Assert.fail((String)("Field '" + fieldName + "' value is not a valid email. It should not start with period(.) after '@' symbol. Actual value: " + actualValue));
        }
        if (parts[1].endsWith(".")) {
            Assert.fail((String)("Field '" + fieldName + "' value is not a valid email. It should not ends with period(.) after '@' symbol. Actual value: " + actualValue));
        }
    }
}

