/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.objects.scrollbar;

import java.awt.Rectangle;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;
import org.sikuli.script.Match;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.commons.LocatorType;
import org.uitnet.testing.smartfwk.ui.core.objects.UIObject;
import org.uitnet.testing.smartfwk.ui.core.objects.scrollbar.HorizontalScrollbar;
import org.uitnet.testing.smartfwk.ui.core.objects.scrollbar.VerticalScrollbar;

public class Scrollbar {
    protected Scrollbar parent;
    protected HorizontalScrollbar hScrollbar;
    protected VerticalScrollbar vScrollbar;
    protected Region hScrollbarRegion;
    protected Region vScrollbarRegion;

    public Scrollbar(HorizontalScrollbar hScrollbar, Region hScrollbarRegion, VerticalScrollbar vScrollbar, Region vScrollbarRegion) {
        this.hScrollbar = hScrollbar;
        this.hScrollbarRegion = hScrollbarRegion;
        this.vScrollbar = vScrollbar;
        this.vScrollbarRegion = vScrollbarRegion;
    }

    public Scrollbar getParent() {
        return this.parent;
    }

    public Scrollbar setParent(Scrollbar parent) {
        this.parent = parent;
        return this;
    }

    public VerticalScrollbar getVScrollbar() {
        return this.vScrollbar;
    }

    public HorizontalScrollbar getHScrollbar() {
        return this.hScrollbar;
    }

    public Rectangle findHScrollbarThumbGripLeftPartImageLocation() {
        Match match;
        if (this.hScrollbar != null && (match = this.hScrollbar.findThumbGripLeftPartImage(this.hScrollbarRegion)) != null) {
            return match.getRect();
        }
        return null;
    }

    public Rectangle findVScrollbarThumbGripTopPartImageLocation() {
        Match match;
        if (this.vScrollbar != null && (match = this.vScrollbar.findThumbGripTopPartImage(this.vScrollbarRegion)) != null) {
            return match.getRect();
        }
        return null;
    }

    public void scrollThumbGripToExtremeTop() {
        if (this.vScrollbar != null) {
            this.vScrollbar.scrollThumbGripToExtremeTop(this.vScrollbarRegion);
        }
    }

    public void scrollThumbGripToExtremeBottom() {
        if (this.vScrollbar != null) {
            this.vScrollbar.scrollThumbGripToExtremeBottom(this.vScrollbarRegion);
        }
    }

    public void scrollThumbGripToExtremeLeft() {
        if (this.hScrollbar != null) {
            this.hScrollbar.scrollThumbGripToExtremeLeft(this.hScrollbarRegion);
        }
    }

    public void scrollThumbGripToExtremeRight() {
        if (this.hScrollbar != null) {
            this.hScrollbar.scrollThumbGripToExtremeRight(this.hScrollbarRegion);
        }
    }

    public void scrollElementToViewport(SmartAppDriver appDriver, UIObject elemLocator) {
        if (elemLocator.getLocatorType() == LocatorType.DOM) {
            UIObject domLocator = elemLocator;
            WebElement webElem = null;
            try {
                System.out.println("AAA");
                Rectangle vScrollbarThumbGripCurrLocation = this.findVScrollbarThumbGripTopPartImageLocation();
                webElem = (WebElement)domLocator.getValidator(appDriver, null).findElementNoException(0);
                boolean vsbEndReached = false;
                boolean vsbTGCurrPointReached = false;
                int vsbEndReachedCounter = 0;
                while (true) {
                    Point webElemPoint;
                    boolean hsbEndReached = false;
                    while (true) {
                        if (webElem != null) {
                            if (this.hScrollbar == null) break;
                            webElemPoint = webElem.getLocation();
                            Match hscM1 = this.hScrollbar.findLeftScrollImage(this.hScrollbarRegion);
                            if (webElemPoint.getX() - hscM1.getX() <= 80 || hsbEndReached) break;
                            hsbEndReached = this.hScrollbar.clickRightScrollImage(this.hScrollbarRegion, 2);
                            webElem = (WebElement)domLocator.getValidator(appDriver, null).findElementNoException(0);
                            if (webElem != null) continue;
                            this.hScrollbar.clickLeftScrollImage(this.hScrollbarRegion, 2);
                            webElem = (WebElement)domLocator.getValidator(appDriver, null).findElementNoException(0);
                            break;
                        }
                        if (this.hScrollbar == null) break;
                        if (hsbEndReached) {
                            this.hScrollbar.scrollThumbGripToExtremeLeft(this.hScrollbarRegion);
                            break;
                        }
                        hsbEndReached = this.hScrollbar.clickRightScrollImage(this.hScrollbarRegion, 2);
                        webElem = (WebElement)domLocator.getValidator(appDriver, null).findElementNoException(0);
                    }
                    if (webElem != null) {
                        if (this.vScrollbar != null) {
                            webElemPoint = webElem.getLocation();
                            Match vscM1 = this.vScrollbar.findTopScrollImage(this.vScrollbarRegion);
                            if (webElemPoint.getY() - vscM1.getY() > 80 && !vsbEndReached) {
                                vsbEndReached = this.vScrollbar.clickBottomScrollImage(this.vScrollbarRegion, 2);
                                webElem = (WebElement)domLocator.getValidator(appDriver, null).findElementNoException(0);
                                if (webElem != null) continue;
                                this.vScrollbar.clickTopScrollImage(this.vScrollbarRegion, 2);
                                webElem = (WebElement)domLocator.getValidator(appDriver, null).findElementNoException(0);
                            }
                        }
                    } else if (!(this.vScrollbar == null || vsbEndReachedCounter > 0 && vsbTGCurrPointReached)) {
                        if (vsbEndReachedCounter == 0 && vsbEndReached) {
                            this.vScrollbar.scrollThumbGripToExtremeTop(this.vScrollbarRegion);
                            vsbEndReached = false;
                            ++vsbEndReachedCounter;
                            continue;
                        }
                        vsbEndReached = this.vScrollbar.clickBottomScrollImage(this.vScrollbarRegion, 2);
                        Rectangle vScrollbarThumbGripRunLocation = this.findVScrollbarThumbGripTopPartImageLocation();
                        if (vScrollbarThumbGripRunLocation.getY() - vScrollbarThumbGripCurrLocation.getY() >= 0.0) {
                            vsbTGCurrPointReached = true;
                        }
                        webElem = (WebElement)domLocator.getValidator(appDriver, null).findElementNoException(0);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable th) {
                Assert.fail((String)("Failed to scroll element '" + elemLocator.getDisplayName() + "' into view port."), (Throwable)th);
            }
            Assert.assertNotNull(webElem, (String)("Failed to find element '" + elemLocator.getDisplayName() + "'"));
        } else if (elemLocator.getLocatorType() == LocatorType.IMAGE) {
            UIObject imgLocator = elemLocator;
            Match match = null;
            try {
                Rectangle vScrollbarThumbGripCurrLocation = this.findVScrollbarThumbGripTopPartImageLocation();
                match = (Match)imgLocator.getValidator(appDriver, null).findElementNoException(0);
                boolean vsbEndReached = false;
                boolean vsbTGCurrPointReached = false;
                int vsbEndReachedCounter = 0;
                while (true) {
                    boolean hsbEndReached = false;
                    while (true) {
                        if (match != null) {
                            if (this.hScrollbar == null) break;
                            Match hscM1 = this.hScrollbar.findLeftScrollImage(this.hScrollbarRegion);
                            if (match.getX() - hscM1.getX() <= 80 || hsbEndReached) break;
                            hsbEndReached = this.hScrollbar.clickRightScrollImage(this.hScrollbarRegion, 2);
                            match = (Match)imgLocator.getValidator(appDriver, null).findElementNoException(0);
                            if (match != null) continue;
                            this.hScrollbar.clickLeftScrollImage(this.hScrollbarRegion, 2);
                            match = (Match)imgLocator.getValidator(appDriver, null).findElementNoException(0);
                            break;
                        }
                        if (this.hScrollbar == null) break;
                        if (hsbEndReached) {
                            this.hScrollbar.scrollThumbGripToExtremeLeft(this.hScrollbarRegion);
                            break;
                        }
                        hsbEndReached = this.hScrollbar.clickRightScrollImage(this.hScrollbarRegion, 2);
                        match = (Match)imgLocator.getValidator(appDriver, null).findElementNoException(0);
                    }
                    if (match != null) {
                        if (this.vScrollbar != null) {
                            Match vscM1 = this.vScrollbar.findTopScrollImage(this.vScrollbarRegion);
                            if (match.getY() - vscM1.getY() > 80 && !vsbEndReached) {
                                vsbEndReached = this.vScrollbar.clickBottomScrollImage(this.vScrollbarRegion, 2);
                                match = (Match)imgLocator.getValidator(appDriver, null).findElementNoException(0);
                                if (match != null) continue;
                                this.vScrollbar.clickTopScrollImage(this.vScrollbarRegion, 2);
                                match = (Match)imgLocator.getValidator(appDriver, null).findElementNoException(0);
                            }
                        }
                    } else if (!(this.vScrollbar == null || vsbEndReachedCounter > 0 && vsbTGCurrPointReached)) {
                        if (vsbEndReachedCounter == 0 && vsbEndReached) {
                            this.vScrollbar.scrollThumbGripToExtremeTop(this.vScrollbarRegion);
                            vsbEndReached = false;
                            ++vsbEndReachedCounter;
                            continue;
                        }
                        vsbEndReached = this.vScrollbar.clickBottomScrollImage(this.vScrollbarRegion, 2);
                        Rectangle vScrollbarThumbGripRunLocation = this.findVScrollbarThumbGripTopPartImageLocation();
                        if (vScrollbarThumbGripRunLocation.getY() - vScrollbarThumbGripCurrLocation.getY() >= 0.0) {
                            vsbTGCurrPointReached = true;
                        }
                        match = (Match)imgLocator.getValidator(appDriver, null).findElementNoException(0);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable th) {
                Assert.fail((String)("Failed to scroll element '" + elemLocator.getDisplayName() + "' into view port."), (Throwable)th);
            }
            Assert.assertNotNull((Object)match, (String)("Failed to find element '" + elemLocator.getDisplayName() + "'"));
        }
    }
}

