/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.standard.domobj;

import io.appium.java_client.MultiTouchAction;
import io.appium.java_client.TouchAction;
import java.util.List;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.objects.DOMObject;
import org.uitnet.testing.smartfwk.ui.core.objects.DOMObjectValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.NewTextLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.radio.RadioButtonValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.scrollbar.Scrollbar;
import org.uitnet.testing.smartfwk.ui.standard.domobj.RadioButtonSD;

public class RadioButtonValidatorSD
extends RadioButtonValidator {
    protected DOMObjectValidator domObjValidator;

    public RadioButtonValidatorSD(SmartAppDriver appDriver, RadioButtonSD uiObject, Region region) {
        super(appDriver, uiObject, region);
        this.domObjValidator = new DOMObjectValidator(appDriver, new DOMObject(uiObject.getType(), uiObject.getDisplayName(), uiObject.getPlatformLocators()), region);
    }

    public DOMObjectValidator getDOMObjectValidator() {
        return this.domObjValidator;
    }

    @Override
    public void typeText(String textToType, NewTextLocation location, int numRetries) {
        this.domObjValidator.typeText(textToType, location, numRetries);
    }

    @Override
    public boolean isPresent(int numRetries) {
        return this.domObjValidator.isPresent(numRetries);
    }

    @Override
    public boolean isVisible(int numRetries) {
        return this.domObjValidator.isVisible(numRetries);
    }

    @Override
    public void click(int numRetries) {
        this.domObjValidator.click(numRetries);
    }

    @Override
    public void doubleClick(int numRetries) {
        this.domObjValidator.doubleClick(numRetries);
    }

    @Override
    public void rightClick(int numRetries) {
        this.domObjValidator.rightClick(numRetries);
    }

    @Override
    public void clickAndHold(int numRetries) {
        this.domObjValidator.clickAndHold(numRetries);
    }

    @Override
    public void release(int numRetries) {
        this.domObjValidator.release(numRetries);
    }

    @Override
    public void performKeyDown(Keys keys, int numRetries) {
        this.domObjValidator.performKeyDown(keys, numRetries);
    }

    @Override
    public void performKeyUp(Keys keys, int numRetries) {
        this.domObjValidator.performKeyUp(keys, numRetries);
    }

    @Override
    public void performKeyPressed(Keys keys, int numRetries) {
        this.domObjValidator.performKeyPressed(keys, numRetries);
    }

    @Override
    public RadioButtonValidatorSD scrollElementOnViewport(Scrollbar scrollbar) {
        this.domObjValidator.scrollElementOnViewport(scrollbar);
        return this;
    }

    public WebElement findElement(int numRetries) {
        return this.domObjValidator.findElement(numRetries);
    }

    public WebElement findElementNoException(int numRetries) {
        return this.domObjValidator.findElementNoException(numRetries);
    }

    @Override
    public List<WebElement> findElements(int numRetries) {
        return this.domObjValidator.findElements(numRetries);
    }

    @Override
    public boolean isDisabled(int numRetries) {
        return this.domObjValidator.isDisabled(numRetries);
    }

    @Override
    public void validateDisabled(int numRetries) {
        Assert.assertTrue((boolean)this.domObjValidator.isDisabled(numRetries), (String)("'" + this.uiObject.getDisplayName() + "' element is not disabled."));
    }

    @Override
    public void validateEnabled(int numRetries) {
        Assert.assertFalse((boolean)this.domObjValidator.isDisabled(numRetries), (String)("'" + this.uiObject.getDisplayName() + "' element is not enabled."));
    }

    @Override
    public boolean isDisabledButNotReadonly(int numRetries) {
        return this.domObjValidator.isDisabledButNotReadonly(numRetries);
    }

    @Override
    public void validateDisabledButNotReadonly(int numRetries) {
        Assert.assertTrue((boolean)this.domObjValidator.isDisabledButNotReadonly(numRetries), (String)("'" + this.uiObject.getDisplayName() + "' element is not disabled."));
    }

    @Override
    public void validateEnabledButNotReadonly(int numRetries) {
        Assert.assertFalse((boolean)this.domObjValidator.isDisabledButNotReadonly(numRetries), (String)("'" + this.uiObject.getDisplayName() + "' element is not enabled."));
    }

    @Override
    public void select(int numRetries) {
        try {
            for (int i = 0; i <= numRetries; ++i) {
                try {
                    WebElement webElem = this.findElement(0);
                    webElem.click();
                    try {
                        this.validateSelected(numRetries);
                    }
                    catch (Throwable th) {
                        Assert.fail((String)("Failed to select radio button '" + this.uiObject.getDisplayName() + "'."));
                    }
                    return;
                }
                catch (Throwable th) {
                    if (i == numRetries) {
                        throw th;
                    }
                    this.appDriver.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to select element '" + this.uiObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void validateSelected(int numRetries) {
        try {
            for (int i = 0; i <= numRetries; ++i) {
                try {
                    WebElement webElem = this.findElement(0);
                    Assert.assertTrue((boolean)webElem.isSelected(), (String)("Radio button '" + this.uiObject.getDisplayName() + "' is not selected."));
                    return;
                }
                catch (Throwable th) {
                    if (i == numRetries) {
                        throw th;
                    }
                    this.appDriver.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to validate element '" + this.uiObject.getDisplayName() + "' as selected."), (Throwable)th);
        }
    }

    @Override
    public void validateNotSelected(int numRetries) {
        try {
            for (int i = 0; i <= numRetries; ++i) {
                try {
                    WebElement webElem = this.findElement(0);
                    Assert.assertFalse((boolean)webElem.isSelected(), (String)("Radio button '" + this.uiObject.getDisplayName() + "' is selected."));
                    return;
                }
                catch (Throwable th) {
                    if (i == numRetries) {
                        throw th;
                    }
                    this.appDriver.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to validate element '" + this.uiObject.getDisplayName() + "' as not selected."), (Throwable)th);
        }
    }

    @Override
    public TouchAction getNewMobileTouchAction() {
        return this.domObjValidator.getNewMobileTouchAction();
    }

    @Override
    public MultiTouchAction getNewMobileMultiTouchAction() {
        return this.domObjValidator.getNewMobileMultiTouchAction();
    }

    @Override
    public Actions getNewSeleniumActions() {
        return this.domObjValidator.getNewSeleniumActions();
    }
}

