/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.api.core.reader;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.testng.Assert;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XmlDocumentReader {
    protected Document xmlDoc;

    public XmlDocumentReader(File xmlFilePath) {
        try {
            Assert.assertNotNull((Object)xmlFilePath, (String)"XML file path cannot be null.");
            this.xmlDoc = this.parseXML(Files.readAllBytes(Paths.get(xmlFilePath.getAbsolutePath(), new String[0])));
        }
        catch (Exception ex) {
            Assert.fail((String)"Failed to parse XML document.", (Throwable)ex);
        }
    }

    public XmlDocumentReader(String xmlAsString) {
        try {
            Assert.assertNotNull((Object)xmlAsString, (String)"XML document cannot be null.");
            Assert.assertNotEquals((Object)xmlAsString.trim(), (Object)"", (String)"XML document cannot be empty.");
            this.xmlDoc = this.parseXML(xmlAsString.getBytes());
        }
        catch (Exception ex) {
            Assert.fail((String)"Failed to parse XML document.", (Throwable)ex);
        }
    }

    private Document parseXML(byte[] contents) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        Document xmlDocument = null;
        try (ByteArrayInputStream is = new ByteArrayInputStream(contents);){
            xmlDocument = builder.parse(is);
        }
        return xmlDocument;
    }

    public Document getDocument() {
        return this.xmlDoc;
    }
}

