/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.config;

import java.io.File;
import java.io.FileReader;
import java.util.Properties;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.commons.Locations;

public class EnvironmentConfig {
    private String name;
    private Properties properties;

    public EnvironmentConfig(String appName, String environmentName) {
        this.name = environmentName;
        this.properties = new Properties();
        if (environmentName != null && !"".equals(environmentName.trim())) {
            this.init(appName);
        } else {
            this.name = "Default";
        }
    }

    private void init(String appName) {
        String activeEnvConfigPath = Locations.getConfigDirPath() + File.separator + "apps-config" + File.separator + appName + File.separator + "environments" + File.separator + this.name + ".properties";
        Assert.assertTrue((boolean)new File(activeEnvConfigPath).exists(), (String)("Missing '" + activeEnvConfigPath + "' environment file in '" + appName + "' application."));
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(activeEnvConfigPath);
            this.properties.load(fileReader);
            fileReader.close();
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to read property file - " + activeEnvConfigPath + ". Going to exit..."), (Throwable)ex);
            System.exit(1);
        }
    }

    public String getName() {
        return this.name;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

