/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.standard.imgobj.datagrid;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.sikuli.script.Region;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.commons.LocatorType;
import org.uitnet.testing.smartfwk.ui.core.commons.UIObjectType;
import org.uitnet.testing.smartfwk.ui.core.objects.scrollbar.HorizontalScrollbar;
import org.uitnet.testing.smartfwk.ui.core.objects.scrollbar.VerticalScrollbar;
import org.uitnet.testing.smartfwk.ui.standard.imgobj.datagrid.DataGridValidatorSI;
import org.uitnet.testing.smartfwk.ui.standard.imgobj.datagrid.HeaderColumnSI;

public class DataGridSI {
    protected LocatorType locatorType = LocatorType.IMAGE;
    protected UIObjectType uiObjectType = UIObjectType.table;
    protected String displayName;
    protected List<HeaderColumnSI> keyHeaderColumns;
    protected List<HeaderColumnSI> additionalHeaderColumns;
    protected List<String> rowMarkerImages;
    protected int numLeftFrozenColumns;
    protected int numRightFrozenColumns;
    protected VerticalScrollbar vScrollbar;
    protected HorizontalScrollbar hScrollbar;
    protected int width;
    protected int height;

    public DataGridSI(String displayName, int widthInPx, int heightInPx) {
        this.displayName = displayName;
        this.keyHeaderColumns = new LinkedList<HeaderColumnSI>();
        this.additionalHeaderColumns = new LinkedList<HeaderColumnSI>();
        this.rowMarkerImages = new LinkedList<String>();
        this.vScrollbar = null;
        this.hScrollbar = null;
        this.width = widthInPx;
        this.height = heightInPx;
    }

    public LocatorType getLocatorType() {
        return this.locatorType;
    }

    public UIObjectType getUiObjectType() {
        return this.uiObjectType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public DataGridSI addKeyHeaderColumns(HeaderColumnSI ... objects) {
        if (objects != null && objects.length > 0) {
            this.keyHeaderColumns.addAll(Arrays.asList(objects));
        }
        return this;
    }

    public List<HeaderColumnSI> getKeyHeaderColumns() {
        return this.keyHeaderColumns;
    }

    public HeaderColumnSI getKeyHeaderColumn(String columnDisplayName) {
        for (HeaderColumnSI colObj : this.keyHeaderColumns) {
            if (!columnDisplayName.equals(colObj.getDisplayName())) continue;
            return colObj;
        }
        return null;
    }

    public DataGridSI addAdditionalHeaderColumns(HeaderColumnSI ... objects) {
        if (objects != null && objects.length > 0) {
            this.additionalHeaderColumns.addAll(Arrays.asList(objects));
        }
        return this;
    }

    public List<HeaderColumnSI> getAdditionalHeaderColumns() {
        return this.additionalHeaderColumns;
    }

    public HeaderColumnSI getAdditionalHeaderColumn(String columnDisplayName) {
        for (HeaderColumnSI colObj : this.additionalHeaderColumns) {
            if (!columnDisplayName.equals(colObj.getDisplayName())) continue;
            return colObj;
        }
        return null;
    }

    public DataGridSI addRowMarkerImages(String ... images) {
        if (images != null && images.length > 0) {
            this.rowMarkerImages.addAll(Arrays.asList(images));
        }
        return this;
    }

    public List<String> getRowMarkerImages() {
        return this.rowMarkerImages;
    }

    public int getNumLeftFrozenColumns() {
        return this.numLeftFrozenColumns;
    }

    public DataGridSI setNumLeftFrozenColumns(int numLeftFrozenColumns) {
        this.numLeftFrozenColumns = numLeftFrozenColumns;
        return this;
    }

    public int getNumRightFrozenColumns() {
        return this.numRightFrozenColumns;
    }

    public DataGridSI setNumRightFrozenColumns(int numRightFrozenColumns) {
        this.numRightFrozenColumns = numRightFrozenColumns;
        return this;
    }

    public VerticalScrollbar getVScrollbar() {
        return this.vScrollbar;
    }

    public DataGridSI setVScrollbar(VerticalScrollbar vScrollbar) {
        this.vScrollbar = vScrollbar;
        return this;
    }

    public HorizontalScrollbar getHScrollbar() {
        return this.hScrollbar;
    }

    public DataGridSI setHScrollbar(HorizontalScrollbar hScrollbar) {
        this.hScrollbar = hScrollbar;
        return this;
    }

    public int getWidth() {
        return this.width;
    }

    public DataGridSI setWidth(int width) {
        this.width = width;
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public DataGridSI setHeight(int height) {
        this.height = height;
        return this;
    }

    public DataGridValidatorSI getValidator(SmartAppDriver appDriver, Region region) {
        return new DataGridValidatorSI(appDriver, this, region);
    }
}

