/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.config;

import java.io.File;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.sikuli.basics.Settings;
import org.sikuli.script.OCR;
import org.testng.Assert;

public class SikuliSettings {
    private String sikuliSettingsFilePath;
    private String ocrDataPath;
    private Properties props;

    public SikuliSettings(String sikuliSettingsFilePath, Properties props) {
        this.sikuliSettingsFilePath = sikuliSettingsFilePath;
        this.props = props;
        this.ocrDataPath = sikuliSettingsFilePath + File.separator + "tessdata";
        this.initializeSikuli();
    }

    public String getOcrDataPath() {
        return this.ocrDataPath;
    }

    public String getPropertyValue(String propName) {
        if (!propName.startsWith("_") && !propName.startsWith("Settings.")) {
            Assert.fail((String)"Property name should start with prefix underscore ( _ ) or Settings.");
        }
        if (!this.props.containsKey(propName)) {
            Assert.fail((String)("Please specify the property '" + propName + "' in '" + this.sikuliSettingsFilePath + "' file."));
        }
        return this.props.getProperty(propName);
    }

    public Map<String, String> getAllSettings() {
        LinkedHashMap<String, String> keyValuePairs = new LinkedHashMap<String, String>();
        for (Object key : this.props.keySet()) {
            String strKey = (String)key;
            if (!strKey.startsWith("Settings.")) continue;
            keyValuePairs.put(strKey.substring("Settings.".length()), this.props.getProperty(strKey));
        }
        return keyValuePairs;
    }

    protected void initializeSikuli() {
        try {
            Map<String, String> settings = this.getAllSettings();
            for (String name : settings.keySet()) {
                String value = settings.get(name);
                Field f = Settings.class.getDeclaredField(name);
                if (f.isAccessible()) {
                    f.set(null, this.createObjectFromTypedValue(name, value));
                    continue;
                }
                f.setAccessible(true);
                f.set(null, this.createObjectFromTypedValue(name, value));
                f.setAccessible(false);
            }
            System.out.println("Sikuli OCRDataPath set to: " + this.getOcrDataPath());
            OCR.Options ocrOptions = OCR.globalOptions();
            ocrOptions.dataPath(this.getOcrDataPath());
        }
        catch (Throwable th) {
            Assert.fail((String)"Failed to initialize the sikuli driver.", (Throwable)th);
        }
    }

    protected Object createObjectFromTypedValue(String propertyName, String typedValue) {
        String[] typeValueArr = typedValue.split(":");
        Assert.assertTrue((typeValueArr.length > 1 ? 1 : 0) != 0, (String)("typedValue format is wrong for property '" + propertyName + "'. It should be <data-type>:<value>"));
        switch (typeValueArr[0]) {
            case "integer": {
                return Integer.parseInt(typeValueArr[1]);
            }
            case "string": {
                return typeValueArr[1];
            }
            case "float": {
                return Float.valueOf(Float.parseFloat(typeValueArr[1]));
            }
            case "double": {
                return Double.parseDouble(typeValueArr[1]);
            }
            case "boolean": {
                return Boolean.parseBoolean(typeValueArr[1]);
            }
        }
        Assert.fail((String)("'" + typeValueArr[0] + "' datatype is not supported for '" + propertyName + "' property."));
        return null;
    }
}

