/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.utils;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.cache.DefaultSmartCache;

public class ScreenCaptureUtil {
    private static int screenshotId = 0;

    public static Dimension getScreenSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static String capture(String dir, String testClassName, String testCaseName, Rectangle screenArea) {
        String imageFile = null;
        try {
            File dirObj;
            Rectangle screenRectangle = screenArea;
            if (screenArea == null) {
                Dimension screenSize = ScreenCaptureUtil.getScreenSize();
                screenRectangle = new Rectangle(screenSize);
            }
            if (!(dirObj = new File(dir)).exists()) {
                dirObj.mkdirs();
            }
            imageFile = testClassName == null ? dir + File.separator + testCaseName + "-" + ScreenCaptureUtil.getNextScreenshotId() + ".png" : dir + File.separator + testClassName + "-" + testCaseName + "-" + ScreenCaptureUtil.getNextScreenshotId() + ".png";
            ScreenCaptureUtil.captureScreenshot(screenRectangle, imageFile);
        }
        catch (Exception ex) {
            Assert.fail((String)"Failed to take screenshot.", (Throwable)ex);
        }
        return imageFile;
    }

    private static synchronized int getNextScreenshotId() {
        return ++screenshotId;
    }

    private static void captureScreenshot(Rectangle screenRectangle, String targetImageFileName) throws AWTException, IOException {
        SmartAppDriver appDriver = DefaultSmartCache.getInstance().getAppDriver();
        if (appDriver != null) {
            TakesScreenshot takeScreenshot = (TakesScreenshot)appDriver.getWebDriver();
            File imageFile = (File)takeScreenshot.getScreenshotAs(OutputType.FILE);
            File targetFile = new File(targetImageFileName);
            FileUtils.copyFile((File)imageFile, (File)targetFile);
        } else {
            Robot robot = new Robot();
            BufferedImage image = robot.createScreenCapture(screenRectangle);
            ImageIO.write((RenderedImage)image, "png", new File(targetImageFileName));
        }
    }
}

