/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.standard.imgobj;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.commons.LocatorType;
import org.uitnet.testing.smartfwk.ui.core.config.AppConfig;
import org.uitnet.testing.smartfwk.ui.core.config.ApplicationType;
import org.uitnet.testing.smartfwk.ui.core.config.PlatformType;
import org.uitnet.testing.smartfwk.ui.core.config.TestConfigManager;
import org.uitnet.testing.smartfwk.ui.core.config.WebBrowserType;
import org.uitnet.testing.smartfwk.ui.core.objects.ObjectLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.PullDownMenuInfo;
import org.uitnet.testing.smartfwk.ui.core.objects.combobox.ComboBox;
import org.uitnet.testing.smartfwk.ui.core.utils.LocatorUtil;
import org.uitnet.testing.smartfwk.ui.standard.imgobj.ComboBoxValidatorSI;

public class ComboBoxSI
extends ComboBox {
    protected Map<String, String> leftSideImgs = new HashMap<String, String>();
    protected Map<String, String> rightSideImgs = new HashMap<String, String>();
    protected ObjectLocation location;
    protected PullDownMenuInfo pullDownMenuInfo;
    protected boolean readOnly;
    protected boolean disabled;

    public ComboBoxSI(String displayName, String leftSideImg, String rightSideImg, ObjectLocation location, PullDownMenuInfo pullDownMenuInfo) {
        super(LocatorType.IMAGE, displayName);
        this.leftSideImgs.put("default-image", TestConfigManager.getInstance().getSikuliResourcesDir() + File.separator + leftSideImg);
        this.rightSideImgs.put("default-image", TestConfigManager.getInstance().getSikuliResourcesDir() + File.separator + rightSideImg);
        this.location = location;
        this.pullDownMenuInfo = pullDownMenuInfo;
        this.readOnly = true;
        this.disabled = false;
    }

    public ComboBoxSI addPlatformImageForNativeApp(PlatformType platform, String leftSideImg, String rightSideImg) {
        LocatorUtil.setPlatformImageForNativeApp(this.leftSideImgs, platform, leftSideImg);
        LocatorUtil.setPlatformImageForNativeApp(this.rightSideImgs, platform, rightSideImg);
        return this;
    }

    public ComboBoxSI addPlatformImageForWebApp(PlatformType platform, WebBrowserType browserType, String leftSideImg, String rightSideImg) {
        LocatorUtil.setPlatformImageForWebApp(this.leftSideImgs, platform, browserType, leftSideImg);
        LocatorUtil.setPlatformImageForWebApp(this.rightSideImgs, platform, browserType, rightSideImg);
        return this;
    }

    public String getLeftSideImage(PlatformType platform, ApplicationType appType, WebBrowserType browserType) {
        return LocatorUtil.findImage(this.leftSideImgs, platform, appType, browserType);
    }

    public String getRightSideImage(PlatformType platform, ApplicationType appType, WebBrowserType browserType) {
        return LocatorUtil.findImage(this.rightSideImgs, platform, appType, browserType);
    }

    public ObjectLocation getLocation() {
        return this.location;
    }

    public PullDownMenuInfo getPullDownMenuInfo() {
        return this.pullDownMenuInfo;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    public ComboBoxValidatorSI getValidator(SmartAppDriver appDriver, Region region) {
        return new ComboBoxValidatorSI(appDriver, this, region);
    }

    @Override
    public ComboBoxSI clone() {
        Assert.fail((String)"clone() API is not implemented.");
        return this;
    }

    @Override
    public ComboBoxSI updateLocatorParameterWithValue(AppConfig appConfig, String paramName, String paramValue) {
        Assert.fail((String)"updateLocatorParameterWithValue() API is not implemented.");
        return this;
    }
}

