/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.standard.imgobj;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.commons.LocatorType;
import org.uitnet.testing.smartfwk.ui.core.config.AppConfig;
import org.uitnet.testing.smartfwk.ui.core.config.ApplicationType;
import org.uitnet.testing.smartfwk.ui.core.config.PlatformType;
import org.uitnet.testing.smartfwk.ui.core.config.TestConfigManager;
import org.uitnet.testing.smartfwk.ui.core.config.WebBrowserType;
import org.uitnet.testing.smartfwk.ui.core.objects.ObjectLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.label.Label;
import org.uitnet.testing.smartfwk.ui.core.utils.LocatorUtil;
import org.uitnet.testing.smartfwk.ui.standard.imgobj.LabelValidatorSI;

public class LabelSI
extends Label {
    protected Map<String, String> platformImages = new HashMap<String, String>();
    protected ObjectLocation labelImgLocation;

    public LabelSI(String displayName, String labelImg, ObjectLocation labelImgLocation) {
        super(LocatorType.IMAGE, displayName);
        this.platformImages.put("default-image", TestConfigManager.getInstance().getSikuliResourcesDir() + File.separator + labelImg);
        this.labelImgLocation = labelImgLocation;
    }

    public LabelSI addPlatformImageForNativeApp(PlatformType platform, String labelImg) {
        LocatorUtil.setPlatformImageForNativeApp(this.platformImages, platform, labelImg);
        return this;
    }

    public LabelSI addPlatformImageForWebApp(PlatformType platform, WebBrowserType browserType, String labelImg) {
        LocatorUtil.setPlatformImageForWebApp(this.platformImages, platform, browserType, labelImg);
        return this;
    }

    public String getLabelImage(PlatformType platform, ApplicationType appType, WebBrowserType browserType) {
        return LocatorUtil.findImage(this.platformImages, platform, appType, browserType);
    }

    public ObjectLocation getLabelImageLocation() {
        return this.labelImgLocation;
    }

    @Override
    public LabelValidatorSI getValidator(SmartAppDriver appDriver, Region region) {
        return new LabelValidatorSI(appDriver, this, region);
    }

    @Override
    public LabelSI clone() {
        return null;
    }

    @Override
    public LabelSI updateLocatorParameterWithValue(AppConfig appConfig, String paramName, String paramValue) {
        Assert.fail((String)"updateLocatorParameterWithValue() API is not implemented.");
        return this;
    }
}

