/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.validator;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.objects.validator.mechanisms.TextMatchMechanism;
import org.uitnet.testing.smartfwk.ui.core.utils.DataMatchUtil;
import org.uitnet.testing.smartfwk.ui.core.utils.StringUtil;

public class FieldValidator {
    private FieldValidator() {
    }

    public static void validateFieldValueAsNull(String fieldName, Object actualValue) {
        if (actualValue != null) {
            Assert.fail((String)("Field '" + fieldName + "' value should be null."));
        }
    }

    public static void validateFieldValueAsNotNull(String fieldName, Object actualValue) {
        if (actualValue == null) {
            Assert.fail((String)("Field '" + fieldName + "' value should not be null."));
        }
    }

    public static void validateFieldValueAsEmpty(String fieldName, Object actualValue) {
        if (actualValue != null) {
            if (actualValue instanceof String) {
                if (!StringUtil.isEmptyAfterTrim((String)actualValue)) {
                    Assert.fail((String)("Field '" + fieldName + "' value is not empty. Found " + ((String)actualValue).length() + " characters. Text: " + (String)actualValue));
                }
            } else if (actualValue instanceof Collection) {
                if (((Collection)actualValue).size() != 0) {
                    Assert.fail((String)("Field '" + fieldName + "' value is not empty. Found " + ((Collection)actualValue).size() + " elements. Elems: " + (Collection)actualValue));
                }
            } else if (actualValue instanceof Map) {
                if (((Map)actualValue).size() != 0) {
                    Assert.fail((String)("Field '" + fieldName + "' value is not empty. Found " + ((Map)actualValue).size() + " elements. Elems: " + (Map)actualValue));
                }
            } else if (actualValue.getClass().isArray()) {
                if (((Object[])actualValue).length != 0) {
                    Assert.fail((String)("Field '" + fieldName + "' value is not empty. Found " + ((Object[])actualValue).length + " elements. Elems: " + Arrays.asList((Object[])actualValue)));
                }
            } else {
                Assert.fail((String)("Field '" + fieldName + "' value is not empty. Found " + ("" + actualValue).length() + " characters. Text: " + actualValue));
            }
        }
    }

    public static void validateFieldValueAsNonEmpty(String fieldName, Object actualValue) {
        FieldValidator.validateFieldValueAsNotNull(fieldName, actualValue);
        if (actualValue instanceof String) {
            if (StringUtil.isEmptyAfterTrim((String)actualValue)) {
                Assert.fail((String)("Field '" + fieldName + "' value is empty."));
            }
        } else if (actualValue instanceof Collection) {
            if (((Collection)actualValue).size() == 0) {
                Assert.fail((String)("Field '" + fieldName + "' does not contain any element."));
            }
        } else if (actualValue instanceof Map) {
            if (((Map)actualValue).size() == 0) {
                Assert.fail((String)("Field '" + fieldName + "' does not contain any element."));
            }
        } else if (actualValue.getClass().isArray() && ((Object[])actualValue).length == 0) {
            Assert.fail((String)("Field '" + fieldName + "' does not contain any element."));
        }
    }

    public static void validateFieldValueAsNumeric(String fieldName, String actualValue, boolean removeComma) {
        if (!StringUtil.isEmptyNoTrim(actualValue)) {
            try {
                String actualValue2 = removeComma ? actualValue.replaceAll(",", "") : actualValue;
                Double.parseDouble(actualValue2);
            }
            catch (Error | Exception e) {
                Assert.fail((String)("Field '" + fieldName + "' value should be numeric. Actual Value: " + actualValue));
            }
        }
    }

    public static void validateFieldValueAsNumericButNotDecimal(String fieldName, String actualValue, boolean removeComma) {
        if (!StringUtil.isEmptyNoTrim(actualValue)) {
            try {
                String actualValue2 = removeComma ? actualValue.replaceAll(",", "") : actualValue;
                Long.parseLong(actualValue2);
            }
            catch (Error | Exception e) {
                Assert.fail((String)("Field '" + fieldName + "' value should be non-decimal. Actual Value: " + actualValue));
            }
        }
    }

    public static void validateFieldValueAsNonNumeric(String fieldName, String actualValue, boolean removeComma) {
        if (!StringUtil.isEmptyNoTrim(actualValue)) {
            String actualValue2 = removeComma ? actualValue.replaceAll(",", "") : actualValue;
            Double.parseDouble(actualValue2);
            Assert.fail((String)("Field '" + fieldName + "' value should not be numeric. Actual Value: " + actualValue));
        }
    }

    public static void validateFieldValueAsExpectedValue(String fieldName, Object actualValue, Object expectedValue) {
        if (actualValue == null || expectedValue == null) {
            if (actualValue != expectedValue) {
                Assert.fail((String)("Field '" + fieldName + "' value is not matched with expected value. Actual Value: " + actualValue + ", Expected Value: " + expectedValue));
            }
        } else if (!("" + actualValue).equals("" + expectedValue)) {
            Assert.fail((String)("Field '" + fieldName + "' value is not matched with expected value. Actual Value: " + actualValue + ", Expected Value: " + expectedValue));
        }
    }

    public static void validateFieldValueAsExpectedValue(String fieldName, Object actualValue, Object expectedValue, TextMatchMechanism textMatchMechanism) {
        if (actualValue == null || expectedValue == null) {
            if (actualValue != expectedValue) {
                Assert.fail((String)("Field '" + fieldName + "' value is not matched with expected value. Actual Value: " + actualValue + ", Expected Value: " + expectedValue));
            }
        } else if (!DataMatchUtil.matchTextValue("" + actualValue, "" + expectedValue, textMatchMechanism)) {
            Assert.fail((String)("Field '" + fieldName + "' value is not matched with expected value. Actual Value: " + actualValue + ", Expected value: " + expectedValue + ", Text Match Mechanism: " + textMatchMechanism.name()));
        }
    }

    public static void validateFieldValueAsNotExpectedValue(String fieldName, Object actualValue, Object expectedValue) {
        if (actualValue == null || expectedValue == null) {
            if (actualValue == expectedValue) {
                Assert.fail((String)("Field '" + fieldName + "' value should not match with expected value. Actual Value: " + actualValue + ", Expected Value: " + expectedValue));
            }
        } else if (("" + actualValue).equals("" + expectedValue)) {
            Assert.fail((String)("Field '" + fieldName + "' value should not match with expected value. Actual Value: " + actualValue + ", Expected Value: " + expectedValue));
        }
    }

    public static void validateFieldValueAsExpectedDateTimeFormat(String fieldName, String actualValue, String expectedDateFormat) {
        try {
            if (!StringUtil.isEmptyAfterTrim(actualValue)) {
                SimpleDateFormat formatter = new SimpleDateFormat(expectedDateFormat);
                formatter.setLenient(true);
                formatter.parse(actualValue.trim());
            }
        }
        catch (Exception ex) {
            Assert.fail((String)("Field '" + fieldName + "' value (" + actualValue + ") is not in the expected format (" + expectedDateFormat + ")."));
        }
    }

    public static void validateFieldValueAsOfExpectedLength(String fieldName, Object actualValue, int expectedLength) {
        FieldValidator.validateFieldValueAsNotNull(fieldName, actualValue);
        int actualLength = 0;
        if (actualValue instanceof Collection) {
            actualLength = ((Collection)actualValue).size();
            if (actualLength != expectedLength) {
                Assert.fail((String)("Field '" + fieldName + "' does not contain same number of elements as expected. Expected Length: " + expectedLength + ", Actual Length: " + actualLength + ". Actual Elements: " + (Collection)actualValue));
            }
        } else if (actualValue instanceof Map) {
            actualLength = ((Map)actualValue).size();
            if (actualLength != expectedLength) {
                Assert.fail((String)("Field '" + fieldName + "' does not contain same number of elements as expected. Expected Length: " + expectedLength + ", Actual Length: " + actualLength + ". Actual Elements: " + (Map)actualValue));
            }
        } else if (actualValue.getClass().isArray()) {
            actualLength = ((Object[])actualValue).length;
            if (actualLength != expectedLength) {
                Assert.fail((String)("Field '" + fieldName + "' does not contain same number of elements as expected. Expected Length: " + expectedLength + ", Actual Length: " + actualLength + ". Actual Elements: " + Arrays.asList((Object[])actualValue)));
            }
        } else {
            actualLength = ("" + actualValue).length();
            if (actualLength != expectedLength) {
                Assert.fail((String)("Field '" + fieldName + "' value does not contain same number of character count as expected. Expected Length: " + expectedLength + ", Actual Length: " + actualLength + ". Actual Text: " + actualValue));
            }
        }
    }

    public static void validateFieldValueAsEmail(String fieldName, String actualValue) {
        String[] parts;
        FieldValidator.validateFieldValueAsNotNull(fieldName, actualValue);
        String actualValue2 = actualValue.trim();
        if (actualValue2.contains(" ")) {
            Assert.fail((String)("Field '" + fieldName + "' value is not a valid email. It should not contain whitespace. Actual value: " + actualValue));
        }
        if ((parts = actualValue2.split("@")).length < 2) {
            Assert.fail((String)("Field '" + fieldName + "' value is not a valid email. It does not contain domain part after '@' symbol. Actual value: " + actualValue));
        }
        if (parts.length > 2) {
            Assert.fail((String)("Field '" + fieldName + "' value is not a valid email. It contains multiple '@' symbols. Actual value: " + actualValue));
        }
        if (parts[0].length() == 0) {
            Assert.fail((String)("Field '" + fieldName + "' value is not a valid email. It does not contain left part before '@' symbol. Actual value: " + actualValue));
        }
        if (!parts[1].contains(".")) {
            Assert.fail((String)("Field '" + fieldName + "' value is not a valid email. It does not contain period(.) after '@' symbol. Actual value: " + actualValue));
        }
        if (parts[1].startsWith(".")) {
            Assert.fail((String)("Field '" + fieldName + "' value is not a valid email. It should not start with period(.) after '@' symbol. Actual value: " + actualValue));
        }
        if (parts[1].endsWith(".")) {
            Assert.fail((String)("Field '" + fieldName + "' value is not a valid email. It should not ends with period(.) after '@' symbol. Actual value: " + actualValue));
        }
    }

    public static void validateFieldValueInExpectedRange(String fieldName, Double value, double min, double max) {
        FieldValidator.validateFieldValueAsNotNull(fieldName, value);
        if (value < min || value > max) {
            Assert.fail((String)("Field '" + fieldName + "' value '" + value + "' should be in the range (" + min + ", " + max + ")."));
        }
    }

    public static void validateFieldValueInExpectedRange(String fieldName, Integer value, int min, int max) {
        FieldValidator.validateFieldValueAsNotNull(fieldName, value);
        if (value < min || value > max) {
            Assert.fail((String)("Field '" + fieldName + "' value '" + value + "' should be in the range (" + min + ", " + max + ")."));
        }
    }

    public static void validateFieldValueInExpectedRange(String fieldName, Long value, long min, long max) {
        FieldValidator.validateFieldValueAsNotNull(fieldName, value);
        if (value < min || value > max) {
            Assert.fail((String)("Field '" + fieldName + "' value '" + value + "' should be in the range (" + min + ", " + max + ")."));
        }
    }

    public static void validateFieldLengthAsOfExpectedLength(String fieldName, Collection<String> actualElements, Collection<String> expectedElements) {
        FieldValidator.validateFieldValueAsNotNull(fieldName, actualElements);
        FieldValidator.validateFieldValueAsNotNull(fieldName, expectedElements);
        LinkedList<String> diffList = new LinkedList<String>();
        if (expectedElements.size() > actualElements.size()) {
            diffList.addAll(expectedElements);
            diffList.removeAll(actualElements);
            if (diffList.size() > 0) {
                Assert.fail((String)("Field '" + fieldName + "' length is not same as expected length. Expected length: " + expectedElements.size() + ", Actual length: " + actualElements.size() + ", Additional Elements (Expected): " + diffList));
            }
        } else if (actualElements.size() > expectedElements.size()) {
            diffList.addAll(actualElements);
            diffList.removeAll(expectedElements);
            if (diffList.size() > 0) {
                Assert.fail((String)("Field '" + fieldName + "' length is not same as expected length. Expected length: " + expectedElements.size() + ", Actual length: " + actualElements.size() + ", Additional Elements (Actual): " + diffList));
            }
        }
    }

    public static void validateFieldContainsExactlySameElementsAsExpected(String fieldName, Collection<String> actualElements, Collection<String> expectedElements) {
        FieldValidator.validateFieldLengthAsOfExpectedLength(fieldName, actualElements, expectedElements);
        LinkedList<String> unmatchedElements = new LinkedList<String>();
        boolean found = false;
        for (String ee : expectedElements) {
            found = false;
            for (String ae : actualElements) {
                if (!StringUtil.trim(ee).equals(StringUtil.trim(ae))) continue;
                found = true;
                break;
            }
            if (found) continue;
            unmatchedElements.add(ee);
        }
        if (unmatchedElements.size() > 0) {
            Assert.fail((String)("Field '" + fieldName + "' does not contain the following elements: " + unmatchedElements));
        }
    }

    public static void validateFieldContainsExactlySameElementsInOrderAsExpected(String fieldName, List<String> actualElements, List<String> expectedElements) {
        FieldValidator.validateFieldLengthAsOfExpectedLength(fieldName, actualElements, expectedElements);
        LinkedHashMap<Integer, String> unmatchedElements = new LinkedHashMap<Integer, String>();
        String ee = null;
        String ae = null;
        for (int i = 0; i < expectedElements.size(); ++i) {
            ee = StringUtil.trim(expectedElements.get(i));
            try {
                ae = StringUtil.trim(actualElements.get(i));
                if (ee.equals(ae)) continue;
                unmatchedElements.put(i + 1, ee);
                continue;
            }
            catch (Exception ex) {
                unmatchedElements.put(i + 1, ee);
            }
        }
        if (unmatchedElements.size() > 0) {
            Assert.fail((String)("Field '" + fieldName + "' does not contain the following elements in order as expected: " + unmatchedElements));
        }
    }

    public static void fail(String message) {
        Assert.fail((String)message);
    }
}

