/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.data.builder;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class TestDataBuilder {
    private int length = 0;
    private int maxWordLength = 0;
    private boolean includeAlphabetsLower = false;
    private boolean includeAlphabetsUpper = false;
    private String alphabetsLower = "abcdefghijklmnopqrstuvwxyz";
    private String alphabetsUpper = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private boolean includeNumbers = false;
    private String numbers = "1234567890";
    private boolean includeSpecialCharacters = false;
    private String specialCharacters = "`~!@#$%^&*()_-+={[]}\\|;:'\",<.>/?";
    private boolean includeNewLine = false;
    private boolean includeWhiteSpaces = false;
    private boolean includeLeadingWhiteSpace = false;
    private boolean includeTrailingWhiteSpace = false;

    public TestDataBuilder setLength(int length) {
        this.length = length;
        return this;
    }

    public TestDataBuilder setMaxWordLength(int maxWordLength) {
        this.maxWordLength = maxWordLength;
        return this;
    }

    public TestDataBuilder includeAlphabets(boolean includeAlphabets) {
        this.includeAlphabetsLower = includeAlphabets;
        this.includeAlphabetsUpper = includeAlphabets;
        return this;
    }

    public TestDataBuilder includeAlphabetsLower(boolean includeAlphabetsLower) {
        this.includeAlphabetsLower = includeAlphabetsLower;
        return this;
    }

    public TestDataBuilder includeAlphabetsUpper(boolean includeAlphabetsUpper) {
        this.includeAlphabetsUpper = includeAlphabetsUpper;
        return this;
    }

    public TestDataBuilder setAlphabetsLower(String alphabetsLower) {
        this.alphabetsLower = alphabetsLower;
        return this;
    }

    public TestDataBuilder setAlphabetsUpper(String alphabetsUpper) {
        this.alphabetsUpper = alphabetsUpper;
        return this;
    }

    public TestDataBuilder includeNumbers(boolean includeNumbers) {
        this.includeNumbers = includeNumbers;
        return this;
    }

    public TestDataBuilder setNumbers(String numbers) {
        this.numbers = numbers;
        this.includeNumbers = true;
        return this;
    }

    public TestDataBuilder includeSpecialCharacters(boolean includeSpecialCharacters) {
        this.includeSpecialCharacters = includeSpecialCharacters;
        return this;
    }

    public TestDataBuilder setSpecialCharacters(String specialCharacters) {
        this.specialCharacters = specialCharacters;
        this.includeSpecialCharacters = true;
        return this;
    }

    public TestDataBuilder includeNewLine(boolean includeNewLine) {
        this.includeNewLine = includeNewLine;
        return this;
    }

    public TestDataBuilder includeWhiteSpaces(boolean includeWhiteSpaces) {
        this.includeWhiteSpaces = includeWhiteSpaces;
        return this;
    }

    public TestDataBuilder includeLeadingAndTrailingWhiteSpace(boolean includeLeadingAndTrailingWhiteSpace) {
        this.includeLeadingWhiteSpace = includeLeadingAndTrailingWhiteSpace;
        this.includeTrailingWhiteSpace = includeLeadingAndTrailingWhiteSpace;
        return this;
    }

    public TestDataBuilder includeLeadingWhiteSpace(boolean includeLeadingWhiteSpace) {
        this.includeLeadingWhiteSpace = includeLeadingWhiteSpace;
        return this;
    }

    public TestDataBuilder includeTrailingWhiteSpace(boolean includeTrailingWhiteSpace) {
        this.includeTrailingWhiteSpace = includeTrailingWhiteSpace;
        return this;
    }

    public String build() {
        return this.build(0, null);
    }

    public String build(int numLeadingChars, Character leadingChar) {
        StringBuilder sb = new StringBuilder("");
        Random rLowerAlphabet = new Random();
        Random rUpperAlphabet = new Random();
        Random rNumberChars = new Random();
        Random rSpecialChars = new Random();
        if (this.includeLeadingWhiteSpace) {
            sb.append(" ");
        }
        int startIndex = this.includeLeadingWhiteSpace ? 1 : 0;
        int endIndex = this.includeTrailingWhiteSpace ? this.length - 2 : this.length - 1;
        int i = startIndex;
        while (i <= endIndex) {
            if (numLeadingChars > 0) {
                sb.append(leadingChar);
                --numLeadingChars;
                ++i;
                if (sb.length() != this.length) continue;
                break;
            }
            if (this.includeAlphabetsLower) {
                sb.append(this.getNextCharFromStr(this.alphabetsLower, rLowerAlphabet));
                ++i;
                if (sb.length() == this.length) break;
            }
            if (this.includeAlphabetsUpper) {
                sb.append(this.getNextCharFromStr(this.alphabetsUpper, rUpperAlphabet));
                ++i;
                if (sb.length() == this.length) break;
            }
            if (this.includeNumbers) {
                sb.append(this.getNextCharFromStr(this.numbers, rNumberChars));
                ++i;
                if (sb.length() == this.length) break;
            }
            if (!this.includeSpecialCharacters) continue;
            sb.append(this.getNextCharFromStr(this.specialCharacters, rSpecialChars));
            ++i;
            if (sb.length() != this.length) continue;
        }
        List<Integer> wordCountList = this.prepareWordCountList(this.maxWordLength, sb.length());
        int offset = 0;
        for (int i2 = 0; i2 < wordCountList.size() && (offset += wordCountList.get(i2).intValue()) + i2 < this.length; ++i2) {
            sb.insert(offset + i2, " ");
            sb.deleteCharAt(sb.length() - 1);
        }
        if (this.includeWhiteSpaces && sb.length() > 1 && sb.indexOf(" ") < 0) {
            sb.insert(1, " ");
            sb.deleteCharAt(sb.length() - 1);
        }
        if (this.includeNewLine && sb.length() > 1) {
            sb.insert(sb.length() / 2, "\n");
            sb.deleteCharAt(sb.length() - 1);
        }
        if (this.includeTrailingWhiteSpace) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private List<Integer> prepareWordCountList(int maxWordLength, int dataLength) {
        LinkedList<Integer> wordCountList = new LinkedList<Integer>();
        if (maxWordLength > 0) {
            int totalLength = 0;
            Random rWordLength = new Random();
            do {
                int wordCount;
                if ((totalLength += (wordCount = this.generateNextNum(rWordLength, 1, maxWordLength + 1))) <= dataLength) {
                    wordCountList.add(wordCount);
                    continue;
                }
                int diff = totalLength - dataLength;
                if (diff <= 0) continue;
                wordCountList.add(wordCount);
            } while (totalLength < dataLength);
            if (wordCountList.size() > 0) {
                wordCountList.remove(wordCountList.size() - 1);
            }
        }
        return wordCountList;
    }

    private String getNextCharFromStr(String str, Random r) {
        if (str == null || "".equals(str)) {
            return "";
        }
        return "" + str.charAt(this.generateNextNum(r, 0, str.length()));
    }

    private int generateNextNum(Random r, int min, int length) {
        return r.nextInt(length - min) + min;
    }
}

