/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.objects.scrollbar;

import java.io.File;
import org.sikuli.script.Match;
import org.sikuli.script.Region;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.config.TestConfigManager;

public class HorizontalScrollbar {
    private static Logger logger = LoggerFactory.getLogger(HorizontalScrollbar.class);
    protected String thumbGripLeftPartImage;
    protected String thumbGripLeftPartImageFocused;
    protected String thumbGripRightPartImage;
    protected String thumbGripRightPartImageFocused;
    protected String leftScrollImageEnabled;
    protected String leftScrollImageEnabledFocused;
    protected String rightScrollImageEnabled;
    protected String rightScrollImageEnabledFocused;
    protected String leftScrollImageDisabled;
    protected String rightScrollImageDisabled;

    public HorizontalScrollbar(String thumbGripLeftPartImage, String thumbGripLeftPartImageFocused, String thumbGripRightPartImage, String thumbGripRightPartImageFocused, String leftScrollImageEnabled, String leftScrollImageEnabledFocused, String rightScrollImageEnabled, String rightScrollImageEnabledFocused, String leftScrollImageDisabled, String rightScrollImageDisabled) {
        this.thumbGripLeftPartImage = thumbGripLeftPartImage;
        this.thumbGripLeftPartImageFocused = thumbGripLeftPartImageFocused;
        this.thumbGripRightPartImage = thumbGripRightPartImage;
        this.thumbGripRightPartImageFocused = thumbGripRightPartImageFocused;
        this.leftScrollImageEnabled = leftScrollImageEnabled;
        this.leftScrollImageEnabledFocused = leftScrollImageEnabledFocused;
        this.rightScrollImageEnabled = rightScrollImageEnabled;
        this.rightScrollImageEnabledFocused = rightScrollImageEnabledFocused;
        this.leftScrollImageDisabled = leftScrollImageDisabled;
        this.rightScrollImageDisabled = rightScrollImageDisabled;
    }

    public boolean isThumbGripLeftPartImageVisible(Region region) {
        Match thumbGripFound2;
        try {
            thumbGripFound2 = region.find((Object)(TestConfigManager.getInstance().getSikuliResourcesDir() + File.separator + this.thumbGripLeftPartImage));
            if (thumbGripFound2 != null) {
                return true;
            }
        }
        catch (Throwable thumbGripFound2) {
            // empty catch block
        }
        try {
            thumbGripFound2 = region.find((Object)(TestConfigManager.getInstance().getSikuliResourcesDir() + File.separator + this.thumbGripLeftPartImageFocused));
            if (thumbGripFound2 != null) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public boolean isThumbGripRightPartImageVisible(Region region) {
        Match thumbGripFound2;
        try {
            thumbGripFound2 = region.find((Object)(TestConfigManager.getInstance().getSikuliResourcesDir() + File.separator + this.thumbGripRightPartImage));
            if (thumbGripFound2 != null) {
                return true;
            }
        }
        catch (Throwable thumbGripFound2) {
            // empty catch block
        }
        try {
            thumbGripFound2 = region.find((Object)(TestConfigManager.getInstance().getSikuliResourcesDir() + File.separator + this.thumbGripRightPartImageFocused));
            if (thumbGripFound2 != null) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public boolean isLeftScrollImageVisible(Region region) {
        Match rightScrollFound2;
        try {
            rightScrollFound2 = region.find((Object)(TestConfigManager.getInstance().getSikuliResourcesDir() + File.separator + this.leftScrollImageEnabled));
            if (rightScrollFound2 != null) {
                return true;
            }
        }
        catch (Throwable rightScrollFound2) {
            // empty catch block
        }
        try {
            rightScrollFound2 = region.find((Object)(TestConfigManager.getInstance().getSikuliResourcesDir() + File.separator + this.leftScrollImageEnabledFocused));
            if (rightScrollFound2 != null) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public boolean isRightScrollImageVisible(Region region) {
        Match rightScrollFound2;
        try {
            rightScrollFound2 = region.find((Object)(TestConfigManager.getInstance().getSikuliResourcesDir() + File.separator + this.rightScrollImageEnabled));
            if (rightScrollFound2 != null) {
                return true;
            }
        }
        catch (Throwable rightScrollFound2) {
            // empty catch block
        }
        try {
            rightScrollFound2 = region.find((Object)(TestConfigManager.getInstance().getSikuliResourcesDir() + File.separator + this.rightScrollImageEnabledFocused));
            if (rightScrollFound2 != null) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public Match findThumbGripLeftPartImage(Region region) {
        Match match2;
        try {
            match2 = region.find((Object)(TestConfigManager.getInstance().getSikuliResourcesDir() + File.separator + this.thumbGripLeftPartImage));
            if (match2 != null) {
                return match2;
            }
        }
        catch (Throwable match2) {
            // empty catch block
        }
        try {
            match2 = region.find((Object)(TestConfigManager.getInstance().getSikuliResourcesDir() + File.separator + this.thumbGripLeftPartImageFocused));
            if (match2 != null) {
                return match2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public Match findThumbGripRightPartImage(Region region) {
        Match match2;
        try {
            match2 = region.find((Object)(TestConfigManager.getInstance().getSikuliResourcesDir() + File.separator + this.thumbGripRightPartImage));
            if (match2 != null) {
                return match2;
            }
        }
        catch (Throwable match2) {
            // empty catch block
        }
        try {
            match2 = region.find((Object)(TestConfigManager.getInstance().getSikuliResourcesDir() + File.separator + this.thumbGripRightPartImageFocused));
            if (match2 != null) {
                return match2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public Match findLeftScrollImage(Region region) {
        Match match2;
        try {
            match2 = region.find((Object)(TestConfigManager.getInstance().getSikuliResourcesDir() + File.separator + this.leftScrollImageEnabled));
            if (match2 != null) {
                return match2;
            }
        }
        catch (Throwable match2) {
            // empty catch block
        }
        try {
            match2 = region.find((Object)(TestConfigManager.getInstance().getSikuliResourcesDir() + File.separator + this.leftScrollImageEnabledFocused));
            if (match2 != null) {
                return match2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public Match findRightScrollImage(Region region) {
        Match match2;
        try {
            match2 = region.find((Object)(TestConfigManager.getInstance().getSikuliResourcesDir() + File.separator + this.rightScrollImageEnabled));
            if (match2 != null) {
                return match2;
            }
        }
        catch (Throwable match2) {
            // empty catch block
        }
        try {
            match2 = region.find((Object)(TestConfigManager.getInstance().getSikuliResourcesDir() + File.separator + this.rightScrollImageEnabledFocused));
            if (match2 != null) {
                return match2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public boolean isFullScrollbarVisible(Region region) {
        try {
            if (this.isLeftScrollImageVisible(region) && this.isRightScrollImageVisible(region)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public void validateFullScrollbarVisible(Region region) {
        Assert.assertTrue((this.isLeftScrollImageVisible(region) && this.isRightScrollImageVisible(region) ? 1 : 0) != 0, (String)"Full horizontal scrollbar is not visible.");
    }

    public boolean isScrollbarDisabled(Region region) {
        Match found;
        try {
            found = region.find((Object)(TestConfigManager.getInstance().getSikuliResourcesDir() + File.separator + this.leftScrollImageDisabled));
            if (found != null) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            found = region.find((Object)(TestConfigManager.getInstance().getSikuliResourcesDir() + File.separator + this.rightScrollImageDisabled));
            if (found != null) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public void validateScrollbarDisabled(Region region) {
        Assert.assertTrue((boolean)this.isScrollbarDisabled(region), (String)"Horizontal scrollbar is not disabled.");
    }

    private boolean isImagesCollidedHorizontally(Match m1, Match m2) {
        if (m1 == null || m2 == null) {
            return false;
        }
        double p1 = m1.getRect().getX() + m1.getRect().getWidth();
        double p2 = m2.getRect().getX();
        if (p2 - p1 <= 5.0) {
            return true;
        }
        p1 = m2.getRect().getX() + m2.getRect().getWidth();
        p2 = m1.getRect().getX();
        return p2 - p1 <= 5.0;
    }

    public boolean clickLeftScrollImage(Region region, int times) {
        try {
            Match found = this.findLeftScrollImage(region);
            if (found != null) {
                for (int i = 0; i < times; ++i) {
                    found.click();
                }
                Match thumbGripLeftPartImgFound = this.findThumbGripLeftPartImage(region);
                return this.isImagesCollidedHorizontally(found, thumbGripLeftPartImgFound);
            }
            logger.error("Error during clickLeftScrollImage.");
            Assert.fail((String)"Error during clickLeftScrollImage.");
        }
        catch (Throwable th) {
            logger.error("Error during clickLeftScrollImage.", th);
            Assert.fail((String)"Error during clickLeftScrollImage.", (Throwable)th);
        }
        return false;
    }

    public boolean clickRightScrollImage(Region region, int times) {
        try {
            Match found = this.findRightScrollImage(region);
            if (found != null) {
                for (int i = 0; i < times; ++i) {
                    found.click();
                }
                Match thumbGripRightPartImgFound = this.findThumbGripRightPartImage(region);
                return this.isImagesCollidedHorizontally(thumbGripRightPartImgFound, found);
            }
        }
        catch (Throwable th) {
            logger.error("Error during clickRightScrollImage.", th);
            Assert.fail((String)"Error during clickRightScrollImage.", (Throwable)th);
        }
        return false;
    }

    public void scrollThumbGripToExtremeLeft(Region region) {
        try {
            Match thumbGripLeftPartImageFound = this.findThumbGripLeftPartImage(region);
            Match leftScrollImageEnabledFound = this.findLeftScrollImage(region);
            if (thumbGripLeftPartImageFound != null && leftScrollImageEnabledFound != null) {
                thumbGripLeftPartImageFound.drag((Object)leftScrollImageEnabledFound);
            } else if (leftScrollImageEnabledFound != null) {
                do {
                    leftScrollImageEnabledFound.click();
                } while ((thumbGripLeftPartImageFound = this.findThumbGripLeftPartImage(region)) == null);
                thumbGripLeftPartImageFound.drag((Object)leftScrollImageEnabledFound);
            }
        }
        catch (Throwable th) {
            logger.error("Error during scrollThumbGripToExtremeLeft.", th);
            Assert.fail((String)"Error during scrollThumbGripToExtremeLeft.", (Throwable)th);
        }
    }

    public void scrollThumbGripToExtremeRight(Region region) {
        try {
            Match thumbGripRightPartImageFound = this.findThumbGripRightPartImage(region);
            Match rightScrollImageEnabledFound = this.findRightScrollImage(region);
            if (thumbGripRightPartImageFound != null && rightScrollImageEnabledFound != null) {
                thumbGripRightPartImageFound.drag((Object)rightScrollImageEnabledFound);
            } else if (rightScrollImageEnabledFound != null) {
                do {
                    rightScrollImageEnabledFound.click();
                } while ((thumbGripRightPartImageFound = this.findThumbGripRightPartImage(region)) == null);
                thumbGripRightPartImageFound.drag((Object)thumbGripRightPartImageFound);
            }
        }
        catch (Throwable th) {
            logger.error("Error during scrollThumbGripToExtremeRight.", th);
            Assert.fail((String)"Error during scrollThumbGripToExtremeRight.", (Throwable)th);
        }
    }
}

