/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.policy;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.uitnet.testing.smartfwk.ui.core.AbstractAppConnector;

public class DefaultTestMethodPolicy
implements ITestListener {
    Logger logger = LoggerFactory.getLogger(this.getClass());

    public void onTestStart(ITestResult result) {
        AbstractAppConnector baseTest = (AbstractAppConnector)result.getInstance();
        this.logger.info("TESTCASE(Started): '" + baseTest.getClass().getSimpleName() + "-" + result.getMethod().getMethodName() + "'. Wait for completion...");
        baseTest.captureScreenshot(result.getMethod().getMethodName() + "-Initial");
    }

    public void onTestSuccess(ITestResult result) {
        AbstractAppConnector baseTest = (AbstractAppConnector)result.getInstance();
        baseTest.captureScreenshot(result.getMethod().getMethodName() + "-Success");
        this.logger.info("TESTCASE(Finished-Successful): '" + baseTest.getClass().getSimpleName() + "-" + result.getMethod().getMethodName() + "'.");
    }

    public void onTestFailure(ITestResult result) {
        AbstractAppConnector baseTest = (AbstractAppConnector)result.getInstance();
        baseTest.captureScreenshot(result.getMethod().getMethodName() + "-Failed");
        this.logger.info("TESTCASE(Finished-Failed): '" + baseTest.getClass().getSimpleName() + "-" + result.getMethod().getMethodName() + "'.", result.getThrowable());
        baseTest.getAppDriver().refresh();
    }

    public void onTestSkipped(ITestResult result) {
        AbstractAppConnector baseTest = (AbstractAppConnector)result.getInstance();
        baseTest.captureScreenshot(result.getMethod().getMethodName() + "-Skipped");
        this.logger.info("TESTCASE(Finished-Skipped): '" + baseTest.getClass().getSimpleName() + "-" + result.getMethod().getMethodName() + "'.", result.getThrowable());
        baseTest.getAppDriver().refresh();
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        AbstractAppConnector baseTest = (AbstractAppConnector)result.getInstance();
        baseTest.captureScreenshot(result.getMethod().getMethodName() + "-Failed");
        this.logger.info("TESTCASE(Finished-Failed): '" + baseTest.getClass().getSimpleName() + "-" + result.getMethod().getMethodName() + "'.", result.getThrowable());
        baseTest.getAppDriver().refresh();
    }

    public void onStart(ITestContext context) {
    }

    public void onFinish(ITestContext context) {
    }
}

