/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.utils;

import io.appium.java_client.AppiumBy;
import io.appium.java_client.AppiumDriver;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.commons.LocateBy;
import org.uitnet.testing.smartfwk.ui.core.commons.Locator;
import org.uitnet.testing.smartfwk.ui.core.config.ApplicationType;
import org.uitnet.testing.smartfwk.ui.core.config.PlatformType;
import org.uitnet.testing.smartfwk.ui.core.config.WebBrowserType;

public class LocatorUtil {
    private LocatorUtil() {
    }

    public static void setPlatformLocatorForNativeApp(Map<String, Locator> platFormLocators, PlatformType platform, LocateBy locateBy, String locatorValue) {
        platFormLocators.put(LocatorUtil.createNativeAppKey(platform), new Locator(locateBy, locatorValue));
    }

    public static void setPlatformLocatorForWebApp(Map<String, Locator> platFormLocators, PlatformType platform, WebBrowserType browserType, LocateBy locateBy, String locatorValue) {
        platFormLocators.put(LocatorUtil.createWebAppKey(platform, browserType), new Locator(locateBy, locatorValue));
    }

    public static void setPlatformImageForNativeApp(Map<String, String> platFormImages, PlatformType platform, String image) {
        int dotLastIdx = image.lastIndexOf(".");
        String imgFileName = image.substring(0, dotLastIdx) + "-" + platform.getType();
        String imgFileExtn = image.substring(dotLastIdx + 1, image.length());
        String imgPath = imgFileName + "." + imgFileExtn;
        platFormImages.put(LocatorUtil.createNativeAppKey(platform), imgPath);
    }

    public static void setPlatformImageForWebApp(Map<String, String> platFormImages, PlatformType platform, WebBrowserType browserType, String image) {
        int dotLastIdx = image.lastIndexOf(".");
        String imgFileName = image.substring(0, dotLastIdx) + "-" + platform.getType() + "-" + browserType.getType();
        String imgFileExtn = image.substring(dotLastIdx + 1, image.length());
        String imgPath = imgFileName + "." + imgFileExtn;
        platFormImages.put(LocatorUtil.createWebAppKey(platform, browserType), imgPath);
    }

    public static Locator findLocator(Map<String, Locator> platFormLocators, PlatformType platform, ApplicationType appType, WebBrowserType browserType) {
        Locator locator = null;
        if (appType == ApplicationType.web_app) {
            locator = platFormLocators.get(LocatorUtil.createWebAppKey(platform, browserType));
            if (locator == null) {
                locator = platFormLocators.get("default-xpath");
            }
            Assert.assertNotNull((Object)locator, (String)("No locator found for platformType: " + platform.getType() + ", appType: " + appType.getType() + ", browserType: " + browserType.getType()));
        } else if (appType == ApplicationType.native_app) {
            locator = platFormLocators.get(LocatorUtil.createNativeAppKey(platform));
            if (locator == null) {
                locator = platFormLocators.get("default-xpath");
            }
            Assert.assertNotNull((Object)locator, (String)("No locator found for platformType: " + platform.getType() + ", appType: " + appType.getType()));
        } else {
            Assert.fail((String)("Application type '" + appType.getType() + "' is not supported."));
        }
        return locator;
    }

    public static String findImage(Map<String, String> platFormImages, PlatformType platform, ApplicationType appType, WebBrowserType browserType) {
        String image = null;
        if (appType == ApplicationType.web_app) {
            image = platFormImages.get(LocatorUtil.createWebAppKey(platform, browserType));
            if (image == null) {
                image = platFormImages.get("default-image");
            }
            Assert.assertNotNull((Object)image, (String)("No image found for platformType: " + platform.getType() + ", appType: " + appType.getType() + ", browserType: " + browserType.getType()));
        } else if (appType == ApplicationType.native_app) {
            image = platFormImages.get(LocatorUtil.createNativeAppKey(platform));
            if (image == null) {
                image = platFormImages.get("default-image");
            }
            Assert.assertNotNull((Object)image, (String)("No image found for platformType: " + platform.getType() + ", appType: " + appType.getType()));
        } else {
            Assert.fail((String)("Application type '" + appType.getType() + "' is not supported."));
        }
        return image;
    }

    public static WebElement findWebElement(WebDriver appDriver, Locator locator) {
        WebElement webElem = null;
        if (appDriver instanceof AppiumDriver) {
            AppiumDriver driver = (AppiumDriver)appDriver;
            switch (locator.getLocateBy()) {
                case Id: {
                    webElem = driver.findElement(AppiumBy.id((String)locator.getValue()));
                    break;
                }
                case Name: {
                    webElem = driver.findElement(AppiumBy.name((String)locator.getValue()));
                    break;
                }
                case ClassName: {
                    webElem = driver.findElement(AppiumBy.className((String)locator.getValue()));
                    break;
                }
                case CssSelector: {
                    webElem = driver.findElement(AppiumBy.cssSelector((String)locator.getValue()));
                    break;
                }
                case AccessibilityId: {
                    webElem = driver.findElement(AppiumBy.accessibilityId((String)locator.getValue()));
                    break;
                }
                case TagName: {
                    webElem = driver.findElement(AppiumBy.tagName((String)locator.getValue()));
                    break;
                }
                case Xpath: {
                    webElem = driver.findElement(AppiumBy.xpath((String)locator.getValue()));
                    break;
                }
                case LinkText: {
                    webElem = driver.findElement(AppiumBy.linkText((String)locator.getValue()));
                    break;
                }
                case PartialLinkText: {
                    webElem = driver.findElement(AppiumBy.partialLinkText((String)locator.getValue()));
                    break;
                }
                default: {
                    Assert.fail((String)("Locate by '" + locator.getLocateBy().name() + "' is not supported."));
                    break;
                }
            }
        } else {
            RemoteWebDriver driver = (RemoteWebDriver)appDriver;
            switch (locator.getLocateBy()) {
                case Id: {
                    webElem = driver.findElement(By.id((String)locator.getValue()));
                    break;
                }
                case Name: {
                    webElem = driver.findElement(By.name((String)locator.getValue()));
                    break;
                }
                case ClassName: {
                    webElem = driver.findElement(By.className((String)locator.getValue()));
                    break;
                }
                case CssSelector: {
                    webElem = driver.findElement(By.cssSelector((String)locator.getValue()));
                    break;
                }
                case AccessibilityId: {
                    Assert.fail((String)("Locate by '" + locator.getLocateBy().name() + "' is not supported."));
                    break;
                }
                case TagName: {
                    webElem = driver.findElement(By.tagName((String)locator.getValue()));
                    break;
                }
                case Xpath: {
                    webElem = driver.findElement(By.xpath((String)locator.getValue()));
                    break;
                }
                case LinkText: {
                    webElem = driver.findElement(By.linkText((String)locator.getValue()));
                    break;
                }
                case PartialLinkText: {
                    webElem = driver.findElement(By.partialLinkText((String)locator.getValue()));
                    break;
                }
                default: {
                    Assert.fail((String)("Locate by '" + locator.getLocateBy().name() + "' is not supported."));
                }
            }
        }
        return webElem;
    }

    public static List<WebElement> findWebElements(WebDriver appDriver, Locator locator) {
        List webElem = null;
        if (appDriver instanceof AppiumDriver) {
            AppiumDriver driver = (AppiumDriver)appDriver;
            switch (locator.getLocateBy()) {
                case Id: {
                    webElem = driver.findElements(AppiumBy.id((String)locator.getValue()));
                    break;
                }
                case Name: {
                    webElem = driver.findElements(AppiumBy.name((String)locator.getValue()));
                    break;
                }
                case ClassName: {
                    webElem = driver.findElements(AppiumBy.className((String)locator.getValue()));
                    break;
                }
                case CssSelector: {
                    webElem = driver.findElements(AppiumBy.cssSelector((String)locator.getValue()));
                    break;
                }
                case AccessibilityId: {
                    webElem = driver.findElements(AppiumBy.accessibilityId((String)locator.getValue()));
                    break;
                }
                case TagName: {
                    webElem = driver.findElements(AppiumBy.tagName((String)locator.getValue()));
                    break;
                }
                case Xpath: {
                    webElem = driver.findElements(AppiumBy.xpath((String)locator.getValue()));
                    break;
                }
                case LinkText: {
                    webElem = driver.findElements(AppiumBy.linkText((String)locator.getValue()));
                    break;
                }
                case PartialLinkText: {
                    webElem = driver.findElements(AppiumBy.partialLinkText((String)locator.getValue()));
                    break;
                }
                default: {
                    Assert.fail((String)("Locate by '" + locator.getLocateBy().name() + "' is not supported."));
                    break;
                }
            }
        } else {
            RemoteWebDriver driver = (RemoteWebDriver)appDriver;
            switch (locator.getLocateBy()) {
                case Id: {
                    webElem = driver.findElements(By.id((String)locator.getValue()));
                    break;
                }
                case Name: {
                    webElem = driver.findElements(By.name((String)locator.getValue()));
                    break;
                }
                case ClassName: {
                    webElem = driver.findElements(By.className((String)locator.getValue()));
                    break;
                }
                case CssSelector: {
                    webElem = driver.findElements(By.cssSelector((String)locator.getValue()));
                    break;
                }
                case AccessibilityId: {
                    Assert.fail((String)("Locate by '" + locator.getLocateBy().name() + "' is not supported."));
                    break;
                }
                case TagName: {
                    webElem = driver.findElements(By.tagName((String)locator.getValue()));
                    break;
                }
                case Xpath: {
                    webElem = driver.findElements(By.xpath((String)locator.getValue()));
                    break;
                }
                case LinkText: {
                    webElem = driver.findElements(By.linkText((String)locator.getValue()));
                    break;
                }
                case PartialLinkText: {
                    webElem = driver.findElements(By.partialLinkText((String)locator.getValue()));
                    break;
                }
                default: {
                    Assert.fail((String)("Locate by '" + locator.getLocateBy().name() + "' is not supported."));
                }
            }
        }
        return webElem;
    }

    public static String getCssValue(WebElement webElem, String cssKey) {
        try {
            return webElem.getCssValue(cssKey);
        }
        catch (Error | Exception ex) {
            return "";
        }
    }

    private static String createWebAppKey(PlatformType platform, WebBrowserType browserType) {
        return platform.getType() + ":" + ApplicationType.web_app.getType() + ":" + browserType.getType();
    }

    private static String createNativeAppKey(PlatformType platform) {
        return platform.getType() + ":" + ApplicationType.native_app.getType();
    }
}

