/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.utils;

import com.jayway.jsonpath.DocumentContext;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.api.core.reader.JsonDocumentReader;
import org.uitnet.testing.smartfwk.api.core.support.PageObjectInfo;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.commons.FieldValue;
import org.uitnet.testing.smartfwk.ui.core.utils.ObjectUtil;

public class PageObjectUtil {
    private PageObjectUtil() {
    }

    public static PageObjectInfo getPageObjectInfo(String pageObject) {
        int firstIndexOfLeftBrace = pageObject.indexOf("{");
        DocumentContext jsonParams = null;
        if (firstIndexOfLeftBrace >= 0) {
            String jsonParamStr = pageObject.substring(firstIndexOfLeftBrace, pageObject.length());
            pageObject = pageObject.substring(0, firstIndexOfLeftBrace);
            JsonDocumentReader jsonDocReader = new JsonDocumentReader(jsonParamStr);
            jsonParams = jsonDocReader.getDocumentContext();
        }
        int lastIndexOfDot = pageObject.lastIndexOf(".");
        String clazzName = pageObject.substring(0, lastIndexOfDot).trim();
        String qualifiedClazzName = "page_objects." + clazzName;
        String objectName = pageObject.substring(lastIndexOfDot + 1, pageObject.length()).trim();
        return new PageObjectInfo(qualifiedClazzName, objectName, jsonParams);
    }

    public static FieldValue getPageObject(PageObjectInfo poInfo) {
        Field f = null;
        Object value = null;
        try {
            Class<?> clazz = Class.forName(poInfo.getPoClassName());
            f = clazz.getField(poInfo.getPoObjectName());
            value = f.get(clazz);
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to load the page object '" + poInfo.getPoClassName() + "." + poInfo.getPoObjectName() + "'. Reason: " + ex.getCause().getLocalizedMessage()), (Throwable)ex);
        }
        return new FieldValue(f, value);
    }

    public static Object getPageObjectValidator(PageObjectInfo poInfo, SmartAppDriver appDriver) {
        FieldValue fv = PageObjectUtil.getPageObject(poInfo);
        Object validatorObj = null;
        try {
            Method method = fv.getField().getType().getMethod("getValidator", SmartAppDriver.class, Region.class);
            validatorObj = method.invoke(fv.getValue(), appDriver, null);
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to get validator for the page object '" + poInfo.getPoClassName() + "." + poInfo.getPoObjectName() + "'. Reason: " + ex.getCause().getLocalizedMessage()), (Throwable)ex);
        }
        return validatorObj;
    }

    public static Object invokeValidatorMethod(String methodName, Class<?>[] methodArgTypes, Object[] methodArgValues, PageObjectInfo poInfo, SmartAppDriver appDriver) {
        Object validatorObj = PageObjectUtil.getPageObjectValidator(poInfo, appDriver);
        Method method = ObjectUtil.findClassMethod(validatorObj.getClass(), methodName, methodArgTypes);
        try {
            return ObjectUtil.invokeMethod(validatorObj, method, methodArgValues);
        }
        catch (Error | Exception ex) {
            Assert.fail((String)("'" + methodName + "' operation is failed for page object '" + poInfo.getPoClassName() + "." + poInfo.getPoObjectName() + "'. Reason: " + ex.getCause().getLocalizedMessage()), (Throwable)ex);
            return null;
        }
    }
}

