/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.standard.domobj;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.commons.ItemMap;
import org.uitnet.testing.smartfwk.ui.core.objects.DOMObject;
import org.uitnet.testing.smartfwk.ui.core.objects.DOMObjectValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.NewTextLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.radio.RadioButtonGroupValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.scrollbar.Scrollbar;
import org.uitnet.testing.smartfwk.ui.standard.domobj.RadioButtonGroupSD;

public class RadioButtonGroupValidatorSD
extends RadioButtonGroupValidator {
    protected DOMObjectValidator domObjValidator;

    public RadioButtonGroupValidatorSD(SmartAppDriver appDriver, RadioButtonGroupSD uiObject, Region region) {
        super(appDriver, uiObject, region);
        this.domObjValidator = new DOMObjectValidator(appDriver, new DOMObject(uiObject.getType(), uiObject.getDisplayName(), uiObject.getPlatformLocators()), region);
    }

    public DOMObjectValidator getDOMObjectValidator() {
        return this.domObjValidator;
    }

    @Override
    public void typeText(String textToType, NewTextLocation location, int maxIterationsToLocateElements) {
        this.domObjValidator.typeText(textToType, location, maxIterationsToLocateElements);
    }

    @Override
    public boolean isPresent(int maxIterationsToLocateElements) {
        return this.domObjValidator.isPresent(maxIterationsToLocateElements);
    }

    @Override
    public boolean isVisible(int maxIterationsToLocateElements) {
        return this.domObjValidator.isVisible(maxIterationsToLocateElements);
    }

    @Override
    public void click(int maxIterationsToLocateElements) {
        this.domObjValidator.click(maxIterationsToLocateElements);
    }

    @Override
    public void doubleClick(int maxIterationsToLocateElements) {
        this.domObjValidator.doubleClick(maxIterationsToLocateElements);
    }

    @Override
    public void rightClick(int maxIterationsToLocateElements) {
        this.domObjValidator.rightClick(maxIterationsToLocateElements);
    }

    @Override
    public void clickAndHold(int maxIterationsToLocateElements) {
        this.domObjValidator.clickAndHold(maxIterationsToLocateElements);
    }

    @Override
    public void release(int maxIterationsToLocateElements) {
        this.domObjValidator.release(maxIterationsToLocateElements);
    }

    @Override
    public void performKeyDown(Keys keys, int maxIterationsToLocateElements) {
        this.domObjValidator.performKeyDown(keys, maxIterationsToLocateElements);
    }

    @Override
    public void performKeyUp(Keys keys, int maxIterationsToLocateElements) {
        this.domObjValidator.performKeyUp(keys, maxIterationsToLocateElements);
    }

    @Override
    public void performKeyPressed(Keys keys, int maxIterationsToLocateElements) {
        this.domObjValidator.performKeyPressed(keys, maxIterationsToLocateElements);
    }

    @Override
    public RadioButtonGroupValidatorSD scrollElementOnViewport(Scrollbar scrollbar) {
        this.domObjValidator.scrollElementOnViewport(scrollbar);
        return this;
    }

    public WebElement findElement(int maxIterationsToLocateElements) {
        return this.domObjValidator.findElement(maxIterationsToLocateElements);
    }

    public WebElement findElementNoException(int maxIterationsToLocateElements) {
        return this.domObjValidator.findElementNoException(maxIterationsToLocateElements);
    }

    @Override
    public List<WebElement> findElements(int maxIterationsToLocateElements) {
        return this.domObjValidator.findElements(maxIterationsToLocateElements);
    }

    @Override
    public void validateDisabled(int maxIterationsToLocateElements) {
        try {
            for (int i = 0; i <= maxIterationsToLocateElements; ++i) {
                try {
                    Object webElems = this.findElements(0);
                    LinkedList<String> enabledItems = new LinkedList<String>();
                    Iterator iterator = webElems.iterator();
                    while (iterator.hasNext()) {
                        WebElement elem = (WebElement)iterator.next();
                        if (!elem.isEnabled()) continue;
                        enabledItems.add(elem.getAttribute("value"));
                    }
                    if (enabledItems.size() > 0) {
                        Assert.fail((String)("Radio button group '" + this.uiObject.getDisplayName() + "' is not disabled. It has the following enabled items: " + enabledItems));
                    }
                    return;
                }
                catch (Throwable th) {
                    if (i == maxIterationsToLocateElements) {
                        throw th;
                    }
                    this.appDriver.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to validate disabled items for radio group '" + this.uiObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void validateEnabled(int maxIterationsToLocateElements) {
        try {
            for (int i = 0; i <= maxIterationsToLocateElements; ++i) {
                try {
                    Object webElems = this.findElements(0);
                    LinkedList<String> disabledItems = new LinkedList<String>();
                    Iterator iterator = webElems.iterator();
                    while (iterator.hasNext()) {
                        WebElement elem = (WebElement)iterator.next();
                        if (elem.isEnabled()) continue;
                        disabledItems.add(elem.getAttribute("value"));
                    }
                    if (disabledItems.size() > 0) {
                        Assert.fail((String)("Radio button group '" + this.uiObject.getDisplayName() + "' is not enabled. It has the following disabled items: " + disabledItems));
                    }
                    return;
                }
                catch (Throwable th) {
                    if (i == maxIterationsToLocateElements) {
                        throw th;
                    }
                    this.appDriver.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to validate enabled items for radio group '" + this.uiObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void selectOption(String value, String displayValue, int maxIterationsToLocateElements) {
        try {
            for (int i = 0; i <= maxIterationsToLocateElements; ++i) {
                try {
                    Object webElems = this.findElements(0);
                    Iterator iterator = webElems.iterator();
                    while (iterator.hasNext()) {
                        WebElement elem = (WebElement)iterator.next();
                        String elemVal = elem.getAttribute("value");
                        if (elemVal == null || !elemVal.equals(value)) continue;
                        elem.click();
                        break;
                    }
                    try {
                        this.validateSelectedOption(value, displayValue, 2);
                    }
                    catch (Throwable th) {
                        Assert.fail((String)("Failed to select option with value '" + displayValue + "' in radio button group '" + this.uiObject.getDisplayName() + "'."));
                    }
                    return;
                }
                catch (Throwable th) {
                    if (i == maxIterationsToLocateElements) {
                        throw th;
                    }
                    this.appDriver.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to select option '" + displayValue + "' for radio group '" + this.uiObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void validateSelectedOption(String value, String displayValue, int maxIterationsToLocateElements) {
        try {
            for (int i = 0; i <= maxIterationsToLocateElements; ++i) {
                try {
                    Object webElems = this.findElements(0);
                    boolean optionFound = false;
                    Iterator iterator = webElems.iterator();
                    while (iterator.hasNext()) {
                        WebElement elem = (WebElement)iterator.next();
                        String elemVal = elem.getAttribute("value");
                        if (elemVal == null || !elemVal.equals(value) || !elem.isSelected()) continue;
                        optionFound = true;
                        break;
                    }
                    Assert.assertTrue((boolean)optionFound, (String)("Radio button with value '" + displayValue + "' is not selected."));
                    return;
                }
                catch (Throwable th) {
                    if (i == maxIterationsToLocateElements) {
                        throw th;
                    }
                    this.appDriver.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to validate selected option '" + displayValue + "' for element '" + this.uiObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void validateNotSelectedOptions(ItemMap<String, String> options, int maxIterationsToLocateElements) {
        try {
            for (int i = 0; i <= maxIterationsToLocateElements; ++i) {
                try {
                    Object webElems = this.findElements(0);
                    LinkedHashMap<String, String> selectedOptions = new LinkedHashMap<String, String>();
                    for (String optionValue : options.getItems().keySet()) {
                        Iterator iterator = webElems.iterator();
                        while (iterator.hasNext()) {
                            WebElement elem = (WebElement)iterator.next();
                            String elemVal = elem.getAttribute("value");
                            if (elemVal == null || !elemVal.equals(optionValue) || !elem.isSelected()) continue;
                            selectedOptions.put(optionValue, options.getItems().get(optionValue));
                        }
                    }
                    if (selectedOptions.size() > 0) {
                        Assert.fail((String)("Radio button group '" + this.uiObject.getDisplayName() + "' has some of the options selected. Selected options: " + selectedOptions));
                    }
                    return;
                }
                catch (Throwable th) {
                    if (i == maxIterationsToLocateElements) {
                        throw th;
                    }
                    this.appDriver.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to validate not selected item for element '" + this.uiObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public Actions getNewSeleniumActions() {
        return this.domObjValidator.getNewSeleniumActions();
    }
}

